/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.ui.graph;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.ui.graph.GraphicalDebugger;
import org.simantics.debug.ui.graph.Messages;
import org.simantics.ui.workbench.ResourceInput;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.LayoutUtils;

public class GraphicalDebuggerView
extends ViewPart {
    public static final String VIEW_ID = "org.simantics.debug.graphicalDebugger";
    private ResourceInput input;
    private Session session;
    private GraphicalDebugger debugger;
    private Action backAction;
    private Action forwardAction;
    private Action refreshAction;
    private Action homeAction;
    private Action increaseDepthAction;
    private Action decreaseDepthAction;

    public void createPartControl(Composite parent) {
        this.session = Simantics.getSession();
        String sid = this.getViewSite().getSecondaryId();
        Resource r = null;
        if (sid != null) {
            this.input = ResourceInput.unmarshall((String)sid);
            try {
                r = this.input.toResource(this.session);
            }
            catch (DatabaseException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
        }
        parent.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)1));
        this.debugger = new GraphicalDebugger(parent, 0, this.session, r);
        this.debugger.defaultInitializeUI();
        this.makeActions();
        this.contributeActions(this.getViewSite().getActionBars());
        this.updateActionStates();
    }

    public void dispose() {
        super.dispose();
    }

    private void makeActions() {
        this.backAction = new BackAction();
        this.forwardAction = new ForwardAction();
        this.refreshAction = new RefreshAction();
        this.homeAction = new HomeAction();
        this.increaseDepthAction = new IncreaseDepthAction();
        this.decreaseDepthAction = new DecreaseDepthAction();
    }

    private void contributeActions(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)this.backAction);
        toolBar.add((IAction)this.forwardAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.refreshAction);
        toolBar.add((IAction)this.homeAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.decreaseDepthAction);
        toolBar.add((IAction)this.increaseDepthAction);
    }

    public void setFocus() {
        if (this.debugger != null) {
            this.debugger.setFocus();
        }
    }

    private void refreshBrowser() {
        this.debugger.refreshBrowser();
    }

    private void back() {
        this.debugger.back();
    }

    private void forward() {
        this.debugger.forward();
    }

    private void decreaseDepth() {
        this.debugger.setDepth(this.debugger.getDepth() - 1);
    }

    private void increaseDepth() {
        this.debugger.setDepth(this.debugger.getDepth() + 1);
    }

    private void navigateHome() {
        Resource rootLibrary = this.session.getRootLibrary();
        this.debugger.changeLocation(rootLibrary);
    }

    private void updateActionStates() {
        this.backAction.setEnabled(this.debugger.hasBackHistory());
        this.forwardAction.setEnabled(this.debugger.hasForwardHistory());
    }

    class BackAction
    extends Action {
        public BackAction() {
            super(Messages.GraphicalDebuggerView_Back, 1);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        }

        public void run() {
            GraphicalDebuggerView.this.back();
        }
    }

    class DecreaseDepthAction
    extends Action {
        public DecreaseDepthAction() {
            super(Messages.GraphicalDebuggerView_Decrease, 1);
            this.setToolTipText(Messages.GraphicalDebuggerView_DecreaseTT);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        }

        public void run() {
            GraphicalDebuggerView.this.decreaseDepth();
        }
    }

    class ForwardAction
    extends Action {
        public ForwardAction() {
            super(Messages.GraphicalDebuggerView_Forward, 1);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
        }

        public void run() {
            GraphicalDebuggerView.this.forward();
        }
    }

    class HomeAction
    extends Action {
        public HomeAction() {
            super(Messages.GraphicalDebuggerView_Home, 1);
            this.setToolTipText(Messages.GraphicalDebuggerView_HomeTT);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_HOME_NAV"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_HOME_NAV_DISABLED"));
        }

        public void run() {
            GraphicalDebuggerView.this.navigateHome();
        }
    }

    class IncreaseDepthAction
    extends Action {
        public IncreaseDepthAction() {
            super(Messages.GraphicalDebuggerView_Increase, 1);
            this.setToolTipText(Messages.GraphicalDebuggerView_IncreaseTT);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
        }

        public void run() {
            GraphicalDebuggerView.this.increaseDepth();
        }
    }

    class RefreshAction
    extends Action {
        public RefreshAction() {
            super(Messages.GraphicalDebuggerView_Refresh, BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.ui", (String)"icons/refresh.gif"));
        }

        public void run() {
            GraphicalDebuggerView.this.refreshBrowser();
        }
    }
}

