package org.simantics.scl.ui.modulebrowser;

import java.util.Arrays;
import java.util.Iterator;

import gnu.trove.map.hash.THashMap;

public class ModuleNameTreeEntry implements Comparable<ModuleNameTreeEntry> {
    public static final String STANDARD_LIBRARY = "StandardLibrary"; //$NON-NLS-1$
    public static final String HTTP_PREFIX = "http://"; //$NON-NLS-1$
    
    public final ModuleNameTreeEntry parent;
    public final String fullName;
    public final String name;
    public final THashMap<String, ModuleNameTreeEntry> childMap = new THashMap<String, ModuleNameTreeEntry>();
    public boolean isModule;
    
    public ModuleNameTreeEntry(ModuleNameTreeEntry parent, String fullName, String name) {
        this.parent = parent;
        this.fullName = fullName;
        this.name = name;
    }
    
    public void addModule(String moduleFullName) {
        int startingPos = fullName.isEmpty() ? 0 : fullName.length()+1;
        int p;
        if(parent == null && moduleFullName.startsWith(HTTP_PREFIX))
            p = moduleFullName.indexOf('/', HTTP_PREFIX.length());
        else
            p = moduleFullName.indexOf('/', startingPos);
        if(p == -1) {
            if(parent == null) {
                getOrCreateChildMapEntry(STANDARD_LIBRARY).addModule(name);
            }
            else {
                String name = moduleFullName.substring(startingPos);
                ModuleNameTreeEntry entry = getOrCreateChildMapEntry(name);
                entry.isModule = true;
            }
        }
        else {
            String name = moduleFullName.substring(startingPos, p);
            ModuleNameTreeEntry entry = getOrCreateChildMapEntry(name);
            entry.addModule(moduleFullName);
        }
    }
    
    private ModuleNameTreeEntry getOrCreateChildMapEntry(String name) {
        ModuleNameTreeEntry entry = childMap.get(name);
        if(entry == null) {
            String newFullName;
            if(parent == null) {
                if(name.equals(STANDARD_LIBRARY))
                    newFullName = ""; //$NON-NLS-1$
                else
                    newFullName = name;
            }
            else
                newFullName = fullName + "/" + name; //$NON-NLS-1$
            entry = new ModuleNameTreeEntry(this, newFullName, name);
            childMap.put(name, entry);
        }
        return entry;
    }
    
    public Object[] children() {
        Object[] result = childMap.values().toArray();
        Arrays.sort(result);
        return result;
    }

    public void clearModuleFlags() {
        isModule = false;
        for(ModuleNameTreeEntry child : childMap.values())
            child.clearModuleFlags();
    }

    @Override
    public int compareTo(ModuleNameTreeEntry o) {
        return name.compareTo(o.name);
    }
    
    public boolean prune() {
        Iterator<ModuleNameTreeEntry> it = childMap.values().iterator();
        while(it.hasNext()) {
            ModuleNameTreeEntry entry = it.next();
            if(!entry.prune())
                it.remove();
        }
        return isModule || !childMap.isEmpty();
    }
}
