package org.simantics.scl.ui.editor;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditorPreferenceConstants;
import org.simantics.scl.ui.Activator;
import org.simantics.scl.ui.editor.completion.SCLCompletionAssistProcessor;
import org.simantics.scl.ui.editor.completion.SCLTextEditorEnvironment;
import org.simantics.scl.ui.editor2.SCLPresentationReconciler;

public class SCLSourceViewerConfigurationNew extends SourceViewerConfiguration {

    public static final char[] CONTENT_ASSIST_AUTO_CHARS = new char[] { '.' };
    
    ResourceManager resourceManager;
    IPreferenceStore preferenceStore;
    
    private SCLTextEditorEnvironment sclTextEditorEnvironment;
    
    public SCLSourceViewerConfigurationNew(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.preferenceStore = EditorsUI.getPreferenceStore();
        
        this.sclTextEditorEnvironment = new SCLTextEditorEnvironment(""); //$NON-NLS-1$
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[] {
            IDocument.DEFAULT_CONTENT_TYPE
        };
    }
    
	@Override
    public int getTabWidth(ISourceViewer sourceViewer) {
		if (preferenceStore == null)
			return super.getTabWidth(sourceViewer);
		return preferenceStore.getInt(AbstractDecoratedTextEditorPreferenceConstants.EDITOR_TAB_WIDTH);
	}

	@Override
	public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
		String[] indentPrefixes = getIndentPrefixesForTab(getTabWidth(sourceViewer));
		if (indentPrefixes == null)
			return null;

		int length = indentPrefixes.length;
		if (length > 2) {
			// Swap first with second last
			String first = indentPrefixes[0];
			indentPrefixes[0] = indentPrefixes[length - 2];
			indentPrefixes[length - 2] = first;
		}

		return indentPrefixes;
	}
    
    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        return new SCLPresentationReconciler(resourceManager);
    }
    
    @Override
    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        //return new SCLEditorTextHover(sourceViewer, sclTextEditorEnvironment);
        return new DefaultTextHover(sourceViewer);
    }
    
    @Override
    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover();
    }
    
    @Override
    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.enableColoredLabels(true);
        assistant.setStatusLineVisible(true);

        assistant.enableAutoActivation(true);
        assistant.enableAutoInsert(true);
        assistant.setContentAssistProcessor(new SCLCompletionAssistProcessor(sclTextEditorEnvironment), IDocument.DEFAULT_CONTENT_TYPE);
        assistant.setInformationControlCreator(CREATOR);
        assistant.setRestoreCompletionProposalSize(Activator.getInstance().getDialogSettings()); 
        return assistant;
    }
    
    private static final IInformationControlCreator CREATOR = new IInformationControlCreator() {
        
        @Override
        public IInformationControl createInformationControl(Shell parent) {
            return new DefaultInformationControl(parent);
        }
    };
    
    public void updateCompletionAssistModuleName(String moduleName) {
        sclTextEditorEnvironment.updateModuleName(moduleName);
    }
    
//    @Override
//    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
//        return new ContentFormatter();
//    }
    
    public SCLTextEditorEnvironment getSclTextEditorEnvironment() {
        return sclTextEditorEnvironment;
    }
}
