/*******************************************************************************
 * Copyright (c) 2012, 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.structural.annotations.factories;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.graph.rules.MappedElementRule;
import org.simantics.objmap.graph.rules.factory.IGetSetRuleFactory;
import org.simantics.objmap.graph.rules.range.GetSetObjectAccessor;
import org.simantics.objmap.structural.StructuralResource;
import org.simantics.objmap.structural.annotations.TypeRelatedGetObj;
import org.simantics.objmap.structural.annotations.TypeRelatedSetObj;
import org.simantics.objmap.structural.rules.domain.RelatedObjectAccessor;


/**
 * Rule factory for mapped object using Getter/Setter-methods.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class TypeRelatedGetSetObjRuleFactory<Range> implements IGetSetRuleFactory<StructuralResource,Range> {
	
	@Override
	public IBidirectionalMappingRule<StructuralResource,Range> create(ReadGraph g, Annotation annotation,
			Method getter, Method setter)
			throws DatabaseException {
		TypeRelatedGetObj getterAnn = (TypeRelatedGetObj)annotation;
		return new MappedElementRule<StructuralResource,Range>(new RelatedObjectAccessor(g.getResource(getterAnn.value()),true,true,true),
					new GetSetObjectAccessor<Range,Range>(getter, setter));
	}
	
	@Override
	public boolean isSetter(Annotation getterAnnotation, Annotation annotation) {
		TypeRelatedGetObj getterAnn = (TypeRelatedGetObj)getterAnnotation;
		TypeRelatedSetObj setterAnn = (TypeRelatedSetObj)annotation;
		return getterAnn.value().equals(setterAnn.value());
	}
	
	

}
