/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.structural.annotations.factories;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;

import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.graph.annotations.RelatedValue;
import org.simantics.objmap.graph.rules.ValueRule;
import org.simantics.objmap.graph.rules.adapters.IdentityAdapter;
import org.simantics.objmap.graph.rules.adapters.ValueAdapter;
import org.simantics.objmap.structural.rules.domain.RelatedValueAccessor;
import org.simantics.objmap.graph.rules.factory.IFieldRuleFactory;
import org.simantics.objmap.graph.rules.range.AdaptedRangeAccessor;
import org.simantics.objmap.graph.rules.range.FieldAccessor;
import org.simantics.objmap.graph.rules.range.IRangeAccessor;
import org.simantics.objmap.structural.StructuralResource;


public class RelatedValueRuleFactory<Range> implements IFieldRuleFactory<StructuralResource, Range> {

    @Override
    public IBidirectionalMappingRule<StructuralResource, Range> create(ReadGraph g, Annotation _annotation, Field field) throws ResourceNotFoundException,
            ValidationException, ServiceException {
        RelatedValue annotation = (RelatedValue) _annotation;
        Class<? extends ValueAdapter> adapterClass = annotation.adapter();
        IRangeAccessor<Range,Object> rangeAccessor = new FieldAccessor<Range,Object>(field);
        Resource valueType;
        if (adapterClass == IdentityAdapter.class) {
            valueType = DataTypeUtils.dataTypeOfClass(g, field.getType());
        } else {
            try {
                ValueAdapter adapter = adapterClass.newInstance();
                rangeAccessor = new AdaptedRangeAccessor<Range>(rangeAccessor, adapter);
                valueType = adapter.rangeTypeToDomainType(g, field.getType());
            } catch (InstantiationException e) {
                throw new RuntimeException(e);
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return new ValueRule<StructuralResource,Range>(new RelatedValueAccessor(g.getResource(annotation.value()), valueType,false,true,false), rangeAccessor);
    }

}
