/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.rules.range;

import java.lang.reflect.Field;

import org.simantics.objmap.exceptions.MappingException;


/**
 * Accesses the given field of the element.
 * @author Hannu Niemist�
 */
public class FieldAccessorWithDefault<Range,T> extends FieldAccessor<Range,T> {
    
	T defaultValue;

	public FieldAccessorWithDefault(Field field, T defaultValue) {
        super(field);
        this.defaultValue = defaultValue;
    }

    @Override
	public T get(Range element) throws MappingException {
		T value = super.get(element);
		if(value == null)
		    return defaultValue;
		else
		    return value;
	}
}
