/*******************************************************************************
 * Copyright (c) 2012, 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.annotations.factories;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.graph.annotations.OrderedElementsAdd;
import org.simantics.objmap.graph.annotations.OrderedElementsGet;
import org.simantics.objmap.graph.annotations.OrderedElementsRem;
import org.simantics.objmap.graph.rules.MappedElementsRule;
import org.simantics.objmap.graph.rules.domain.RelatedOrderedSetElementsAccessor;
import org.simantics.objmap.graph.rules.factory.ICollectionRuleFactory;
import org.simantics.objmap.graph.rules.range.ListAccessor;


public class OrderedElementsRuleFactory<Range> implements ICollectionRuleFactory<Resource,Range> {
	
	@Override
	public IBidirectionalMappingRule<Resource, Range> create(ReadGraph g, Annotation annotation,
			Method getter, Method adder, Method remover)
			throws DatabaseException {
		OrderedElementsGet getterAnn = (OrderedElementsGet)annotation;
		return new MappedElementsRule<Resource,Range>(new RelatedOrderedSetElementsAccessor(getterAnn.composition()),
					new ListAccessor<Range,Range>(getter, adder, remover));
	}
	
	@Override
	public boolean isAdder(Annotation getterAnnotation, Annotation annotation) {
		OrderedElementsGet getterAnn = (OrderedElementsGet)getterAnnotation;
		OrderedElementsAdd adderAnn = (OrderedElementsAdd)annotation;
		return true;
	}
	
	@Override
	public boolean isRemover(Annotation getterAnnotation, Annotation annotation) {
		OrderedElementsGet getterAnn = (OrderedElementsGet)getterAnnotation;
		OrderedElementsRem adderAnn = (OrderedElementsRem)annotation;
		return true;
	}

}
