/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.tests.commands;

import java.util.ArrayList;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.testing.common.CommandSequenceEnvironment;
import org.simantics.db.testing.common.WriteCommand;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.tests.traits.SingleResourceTrait;
import org.simantics.modeling.tests.traits.SingleResourceTraitImpl;
import org.simantics.structural.stubs.StructuralResource2;

public class MergeFlags
extends WriteCommand<CommandSequenceEnvironment> {
    private SingleResourceTrait diagram;

    public MergeFlags(SingleResourceTrait diagram) {
        this.diagram = diagram;
    }

    public MergeFlags(Resource diagram) {
        this(new SingleResourceTraitImpl(diagram));
    }

    public Resource getComposite(ReadGraph graph) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource resource = this.diagram.getResource();
        if (graph.isInstanceOf(resource, DIA.Diagram)) {
            return graph.getSingleObject(resource, MOD.DiagramToComposite);
        }
        if (graph.isInstanceOf(resource, STR.Composite)) {
            return resource;
        }
        throw new DatabaseException("Expected diagram or composite, got " + NameUtils.getSafeName((ReadGraph)graph, (Resource)resource));
    }

    protected void run(WriteGraph graph, CommandSequenceEnvironment environment) throws DatabaseException {
        System.err.println("Merging flags in: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.getComposite((ReadGraph)graph)));
        ArrayList groups = new ArrayList();
        org.simantics.modeling.flags.MergeFlags.collectFlagGroupsInComposite((ReadGraph)graph, (Resource)this.getComposite((ReadGraph)graph), groups);
        for (ArrayList group : groups) {
            org.simantics.modeling.flags.MergeFlags.merge((WriteGraph)graph, (List)group);
        }
    }
}

