/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.writer;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.layer0.Layer0;

public abstract class GraphWriterPartial implements GraphWriter {

	ClusteringSupport clustering;
	ReadGraph graph;
	Layer0 l0;
	
	public GraphWriterPartial(ReadGraph graph) {	
		this.graph = graph;
		this.l0 = Layer0.getInstance(graph);
		clustering = graph.getSession().getService(ClusteringSupport.class);
	}
	
	@Override
	public ReadGraph getGraph() {
		return graph;
	}
	
//	@Override
//	public GraphWriter create(Resource type) {
//		return create(type);
//		return let(b.InstanceOf, type);
//	}
	
	@Override
	public GraphWriter create(String name, Resource type) throws DatabaseException  {
		create(type);
		return let(l0.HasName, name, l0.String);
	}
	
	@Override
	public GraphWriter create(int clusterHint, String name, Resource type) throws DatabaseException {
		create(clusterHint, type);
		return let(clusterHint, l0.HasName, name, l0.String);
	}
	
	@Override
	public GraphWriter create(int clusterHint) throws DatabaseException {
		return create();
	}
	
	@Override
	public GraphWriter create(int clusterHint, Resource type) throws DatabaseException {
		return create(type);
	}
	
	@Override
	public GraphWriter let(int clusterHint, Resource p, Object value,
		Resource dataType) throws DatabaseException {
		return let(p, value, dataType);
	}
	
	@Override
	public GraphWriter createLiteral(int clusterHint, Object value,
		Resource dataType) throws DatabaseException {
		return createLiteral(value, dataType);
	}

    @Override
    public GraphWriter stat(Resource s, Resource p, Resource o) throws DatabaseException {
        return handle(s).let(p, o);     
    }	
    
    @Override
    public GraphWriter createInverse(int clusterHint, Resource r) throws DatabaseException {
    	return createInverse(r);
    }
    
}
