package org.simantics.browsing.ui.nattable;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.nebula.widgets.nattable.style.theme.ModernNatTableThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.tree.painter.IndentedTreeImagePainter;
import org.eclipse.nebula.widgets.nattable.tree.painter.TreeImagePainter;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;

public class GENatTableThemeConfiguration extends ModernNatTableThemeConfiguration{

	GETreeData treeData;

	public GENatTableThemeConfiguration(GETreeData treeData, int style) {
		super();
		this.treeData = treeData;
		this.oddRowBgColor = GUIHelper.getColor(250, 250, 250);
	}

	@Override
	public void createPainterInstances() {
		super.createPainterInstances();

		TextPainter cellTextPainter = new TextPainter();
		cellTextPainter.setTrimText(false);
		this.defaultCellPainter =
				new GEStyler(treeData,
						new GEIconPainter(
								new PaddingDecorator(
										cellTextPainter,
										0,
										5,
										0,
										5,
										false)));

		TreeImagePainter treeImagePainter =
				new TreeImagePainter(
						false,
						GUIHelper.getImage("right"), //$NON-NLS-1$
						GUIHelper.getImage("right_down"), //$NON-NLS-1$
						GUIHelper.getImageByURL("transparent", 
								FileLocator.find(Activator.getDefault().getBundle(), 
										new Path("images/transparent.png"), null))); //$NON-NLS-1$
		this.treeStructurePainter =
				new BackgroundPainter(
						new PaddingDecorator(
								new IndentedTreeImagePainter(
										10,
										null,
										CellEdgeEnum.LEFT,
										treeImagePainter,
										false,
										2,
										true),
								0,
								5,
								0,
								5,
								false));
		TreeImagePainter treeSelectionImagePainter =
				new TreeImagePainter(
						false,
						GUIHelper.getImage("right_inv"), //$NON-NLS-1$
						GUIHelper.getImage("right_down_inv"), //$NON-NLS-1$
						GUIHelper.getImageByURL("transparent", 
								FileLocator.find(Activator.getDefault().getBundle(), 
										new Path("images/transparent.png"), null))); //$NON-NLS-1$
		this.treeStructureSelectionPainter =
				new BackgroundPainter(
						new PaddingDecorator(
								new IndentedTreeImagePainter(
										10,
										null,
										CellEdgeEnum.LEFT,
										treeSelectionImagePainter,
										false,
										2,
										true),
								0,
								5,
								0,
								5,
								false));
	}

}
