/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.xmlio;

import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.interop.xmlio.LoadRule;
import org.simantics.interop.xmlio.LoadXML;
import org.simantics.layer0.Layer0;

public class DefaultLoadRule
implements LoadRule {
    private Layer0 l0;

    @Override
    public Resource getResource(ReadGraph graph, String uri) throws DatabaseException {
        return graph.getResource(uri);
    }

    @Override
    public Object createValue(ReadGraph graph, List<String> value, List<String> types) throws DatabaseException {
        if (types.contains("http://www.simantics.org/Layer0-1.1/String")) {
            return value.get(0);
        }
        if (types.contains("http://www.simantics.org/Layer0-1.1/Boolean")) {
            return Boolean.parseBoolean(value.get(0));
        }
        if (types.contains("http://www.simantics.org/Layer0-1.1/Byte")) {
            return Byte.parseByte(value.get(0));
        }
        if (types.contains("http://www.simantics.org/Layer0-1.1/Double")) {
            return Double.parseDouble(value.get(0));
        }
        if (types.contains("http://www.simantics.org/Layer0-1.1/Integer")) {
            return Integer.parseInt(value.get(0));
        }
        if (types.contains("http://www.simantics.org/Layer0-1.1/Long")) {
            return Long.parseLong(value.get(0));
        }
        if (types.contains("http://www.simantics.org/Layer0-1.1/Float")) {
            return Float.valueOf(Float.parseFloat(value.get(0)));
        }
        if (types.contains("http://www.simantics.org/Layer0-1.1/StringArray")) {
            String[] result = new String[value.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = value.get(i);
                ++i;
            }
            return result;
        }
        if (types.contains("http://www.simantics.org/Layer0-1.1/BooleanArray")) {
            boolean[] result = new boolean[value.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = Boolean.parseBoolean(value.get(i));
                ++i;
            }
            return result;
        }
        if (types.contains("http://www.simantics.org/Layer0-1.1/BooleanArray")) {
            boolean[] result = new boolean[value.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = Boolean.parseBoolean(value.get(i));
                ++i;
            }
            return result;
        }
        if (types.contains("http://www.simantics.org/Layer0-1.1/ByteArray")) {
            byte[] result = new byte[value.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = Byte.parseByte(value.get(i));
                ++i;
            }
            return result;
        }
        if (types.contains("http://www.simantics.org/Layer0-1.1/DoubleArray")) {
            double[] result = new double[value.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = Double.parseDouble(value.get(i));
                ++i;
            }
            return result;
        }
        if (types.contains("http://www.simantics.org/Layer0-1.1/IntegerArray")) {
            int[] result = new int[value.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = Integer.parseInt(value.get(i));
                ++i;
            }
            return result;
        }
        if (types.contains("http://www.simantics.org/Layer0-1.1/LongArray")) {
            long[] result = new long[value.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = Long.parseLong(value.get(i));
                ++i;
            }
            return result;
        }
        if (types.contains("http://www.simantics.org/Layer0-1.1/FloatArray")) {
            float[] result = new float[value.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = Float.parseFloat(value.get(i));
                ++i;
            }
            return result;
        }
        throw new DatabaseException("Unknow value");
    }

    @Override
    public void initializeWithBundles(ReadGraph graph, List<LoadXML.Bundle> bundles) throws DatabaseException {
        this.l0 = Layer0.getInstance((ReadGraph)graph);
    }
}

