/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.geometry;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jcae.opencascade.jni.TopoDS_Shape;
import org.simantics.db.Resource;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.shape.ArcCylinder;
import org.simantics.g3d.shape.Mesh;
import org.simantics.opencascade.OccTriangulator;
import org.simantics.plant3d.geometry.BuiltinMeshProvider;

public class ElbowGeometryProvider
extends BuiltinMeshProvider {
    private double radius = 0.01;
    private double turnRadius = 0.05;
    private double turnAngle = 1.5707963267948966;

    public ElbowGeometryProvider(Resource resource) {
        super(resource);
    }

    public Collection<TopoDS_Shape> getModel() throws Exception {
        if (this.radius < MathTools.NEAR_ZERO || this.turnRadius < MathTools.NEAR_ZERO) {
            return Collections.emptyList();
        }
        double t = Math.tan((Math.PI - this.turnAngle) * 0.5);
        double R = 0.0;
        if (t > MathTools.NEAR_ZERO) {
            R = this.turnRadius / t;
        }
        TopoDS_Shape shape = OccTriangulator.makeTorus((double[])new double[]{-R, 0.0, -this.turnRadius}, (double[])new double[]{0.0, 1.0, 0.0}, (double)this.turnRadius, (double)this.radius, (double)0.0, (double)(Math.PI * 2), (double)this.turnAngle);
        return Collections.singletonList(shape);
    }

    public Mesh getMesh() {
        if (this.radius < MathTools.NEAR_ZERO || this.turnRadius < MathTools.NEAR_ZERO) {
            return null;
        }
        double t = Math.tan((Math.PI - this.turnAngle) * 0.5);
        double R = 0.0;
        if (t > MathTools.NEAR_ZERO) {
            R = this.turnRadius / t;
        }
        ArcCylinder cyl = new ArcCylinder();
        return cyl.create(new Point3d(-R, 0.0, -this.turnRadius), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, 0.0, 1.0), this.turnRadius, this.radius, this.turnAngle, 16, 0.2);
    }

    public void setProperties(Map<String, Object> props) {
        if (props.containsKey("turnRadius")) {
            this.turnRadius = (Double)props.get("turnRadius");
        }
        if (props.containsKey("turnAngle")) {
            this.turnAngle = (Double)props.get("turnAngle");
        }
        if (props.containsKey("radius")) {
            this.radius = (Double)props.get("radius");
        }
        if (this.radius < MathTools.NEAR_ZERO) {
            this.radius = MathTools.NEAR_ZERO;
        }
    }

    @Override
    public void updateCalculatedProperties(Map<String, Object> returnProps) {
        double t = Math.tan((Math.PI - this.turnAngle) * 0.5);
        double R = 0.0;
        if (t > MathTools.NEAR_ZERO) {
            R = this.turnRadius / t;
        }
        returnProps.put("length", R);
    }
}

