/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.actions;

import java.util.ArrayList;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.Ray;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.toolbar.ToolComposite;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.g3d.vtk.swt.InteractiveVtkComposite;
import org.simantics.g3d.vtk.utils.vtkUtil;
import org.simantics.plant3d.Activator;
import org.simantics.plant3d.actions.RoutePipeAction;
import org.simantics.plant3d.scenegraph.EndComponent;
import org.simantics.plant3d.scenegraph.InlineComponent;
import org.simantics.plant3d.scenegraph.Nozzle;
import org.simantics.plant3d.scenegraph.P3DRootNode;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import org.simantics.plant3d.scenegraph.TurnComponent;
import org.simantics.plant3d.scenegraph.controlpoint.PipeControlPoint;
import vtk.vtkRenderer;

public class TranslateFreeVariableLengthAction
extends RoutePipeAction {
    private InlineComponent component;

    public TranslateFreeVariableLengthAction(InteractiveVtkComposite panel, P3DRootNode root, ToolComposite toolComposite) {
        super(panel, root, toolComposite, false);
        this.setText("Translate");
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/arrow_refresh.png"));
    }

    public void setNode(IG3DNode node) {
        if (node instanceof InlineComponent) {
            this.component = (InlineComponent)node;
            if (this.component.isVariableLength() && (this.component.getNext() == null || this.component.getPrevious() == null)) {
                PipelineComponent pathLegStart = this.component.getNext() == null ? this.component.getControlPoint().findPreviousEnd().getPipelineComponent() : this.component.getControlPoint().findNextEnd().getPipelineComponent();
                this.setComponent(pathLegStart);
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        } else {
            this.component = null;
            this.setEnabled(false);
        }
    }

    @Override
    protected void activate() throws Exception {
        this.state = RoutePipeAction.ToolState.INITIALIZING;
        this.added.clear();
        this.pipeRun = this.startComponent.getPipeRun();
        PipeControlPoint start = this.startComponent.getControlPoint();
        this.activateNextPrev(start);
    }

    @Override
    protected void activateNextPrev(PipeControlPoint start) throws Exception {
        if (!this.reversed && start.isDualInline()) {
            start = start.getDualSub();
        } else if (this.reversed && start.isDualSub()) {
            start = start.parent;
        }
        this.pipeRun = this.component.getPipeRun();
        ArrayList<PipeControlPoint> cps = new ArrayList<PipeControlPoint>();
        PipeControlPoint s = null;
        s = this.component.getNext() == null ? this.component.getControlPoint().findPreviousEnd(cps) : this.component.getControlPoint().findNextEnd(cps);
        if (s.getPipelineComponent() != this.startComponent) {
            throw new Exception("Path leg start mismatch");
        }
        this.setPreviousPosition(start.getWorldPosition());
        this.currentPosition = this.component.getPosition();
        if (this.startComponent instanceof Nozzle) {
            this.direction = this.startComponent.getControlPoint().getDirectedControlPointDirection();
            this.lock = RoutePipeAction.LockType.CUSTOM;
        } else if (this.startComponent instanceof PipelineComponent) {
            if (this.startComponent instanceof InlineComponent) {
                this.direction = this.startComponent.getControlPoint().getInlineDir();
                if (this.reversed) {
                    this.direction.negate();
                }
                this.lock = RoutePipeAction.LockType.CUSTOM;
                if (((InlineComponent)this.startComponent).isVariableLength()) {
                    this.direction = null;
                    this.lock = RoutePipeAction.LockType.NONE;
                }
                Vector3d v = new Vector3d();
                if (!this.reversed) {
                    start.getControlPointEnds((Tuple3d)v, (Tuple3d)this.previousPosition);
                } else {
                    start.getControlPointEnds((Tuple3d)this.previousPosition, (Tuple3d)v);
                }
            } else if (this.startComponent instanceof TurnComponent) {
                if (start.asFixedAngle()) {
                    this.direction = this.startComponent.getControlPoint().getPathLegDirection(this.reversed ? PipeControlPoint.Direction.PREVIOUS : PipeControlPoint.Direction.NEXT);
                    this.lock = RoutePipeAction.LockType.CUSTOM;
                } else {
                    this.direction = null;
                    this.lock = RoutePipeAction.LockType.NONE;
                }
            } else if (this.startComponent instanceof EndComponent) {
                throw new Exception("Not supported");
            }
        } else {
            throw new Exception("Not supported");
        }
        this.currentPosition = new Vector3d(this.previousPosition);
        this.state = RoutePipeAction.ToolState.ROUTING;
        if (this.direction != null) {
            this.direction.normalize();
        }
        this.startRemovable = start.isDeletable();
        start.setDeletable(false);
        for (PipeControlPoint pcp : cps) {
            this.added.add(pcp.getPipelineComponent());
            pcp.setDeletable(false);
        }
        this.added.add(this.component);
        this.translateAxisGizmo.attach((VtkView)this.panel);
        this.setPreviousPosition(this.previousPosition);
        this.updateCurrentPoint();
    }

    @Override
    public void deactivate() {
        super.deactivate();
    }

    @Override
    protected void addPoint() throws Exception {
    }

    @Override
    protected void endPiping() throws Exception {
        this.state = RoutePipeAction.ToolState.NOT_ACTIVE;
        this.panel.useDefaultAction();
    }

    @Override
    protected void updateRouting(double x, double y) {
        if (this.useDefault) {
            return;
        }
        this.endTo = null;
        this.endType = null;
        this.endPort = null;
        Ray ray = vtkUtil.createMouseRay((vtkRenderer)this.panel.getRenderer(), (double)x, (double)y);
        Vector3d o = new Vector3d((Tuple3d)ray.pos);
        Vector3d d = ray.dir;
        this.updateCurrentPoint(o, d);
        this.updateRoute(o, d);
        this.panel.refresh();
    }
}

