/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.opencascade;

import javax.vecmath.Vector2d;
import org.jcae.opencascade.jni.BRepAlgoAPI_Common;
import org.jcae.opencascade.jni.BRepAlgoAPI_Cut;
import org.jcae.opencascade.jni.BRepAlgoAPI_Fuse;
import org.jcae.opencascade.jni.BRepBuilderAPI_MakeEdge;
import org.jcae.opencascade.jni.BRepBuilderAPI_MakeFace;
import org.jcae.opencascade.jni.BRepBuilderAPI_MakeWire;
import org.jcae.opencascade.jni.BRepBuilderAPI_Transform;
import org.jcae.opencascade.jni.BRepFilletAPI_MakeChamfer;
import org.jcae.opencascade.jni.BRepFilletAPI_MakeFillet;
import org.jcae.opencascade.jni.BRepPrimAPI_MakeBox;
import org.jcae.opencascade.jni.BRepPrimAPI_MakeCone;
import org.jcae.opencascade.jni.BRepPrimAPI_MakeCylinder;
import org.jcae.opencascade.jni.BRepPrimAPI_MakePrism;
import org.jcae.opencascade.jni.BRepPrimAPI_MakeSphere;
import org.jcae.opencascade.jni.BRepPrimAPI_MakeTorus;
import org.jcae.opencascade.jni.BRepPrimAPI_MakeWedge;
import org.jcae.opencascade.jni.BRepTools;
import org.jcae.opencascade.jni.BRep_Builder;
import org.jcae.opencascade.jni.GP_Elips;
import org.jcae.opencascade.jni.GP_Trsf;
import org.jcae.opencascade.jni.IGESControl_Reader;
import org.jcae.opencascade.jni.STEPControl_Reader;
import org.jcae.opencascade.jni.TopAbs_ShapeEnum;
import org.jcae.opencascade.jni.TopExp_Explorer;
import org.jcae.opencascade.jni.TopoDS_Compound;
import org.jcae.opencascade.jni.TopoDS_Edge;
import org.jcae.opencascade.jni.TopoDS_Face;
import org.jcae.opencascade.jni.TopoDS_Shape;
import org.jcae.opencascade.jni.TopoDS_Wire;

public class OccTriangulator {
    public static final double MIN_VALUE = 0.001;

    public static TopoDS_Shape getShapeFromFile(String filename) {
        assert (filename != null);
        String lowerFileName = filename.toLowerCase();
        if (lowerFileName.endsWith(".stp") || lowerFileName.endsWith(".step")) {
            TopoDS_Shape shape = OccTriangulator.importSTEP(filename);
            return shape;
        }
        if (lowerFileName.endsWith(".iges")) {
            TopoDS_Shape shape = OccTriangulator.importIGES(filename);
            return shape;
        }
        if (lowerFileName.endsWith(".brep")) {
            TopoDS_Shape shape = OccTriangulator.importBREP(filename);
            return shape;
        }
        throw new UnsupportedOperationException("Unsupported format " + filename);
    }

    public static TopoDS_Shape importBREP(String filename) {
        return OccTriangulator.importBREP(filename, 1.0);
    }

    public static TopoDS_Shape importBREP(String filename, double scale) {
        BRep_Builder aBuilder = new BRep_Builder();
        TopoDS_Shape myShape = BRepTools.read((String)filename, (BRep_Builder)aBuilder);
        aBuilder.delete();
        if (Math.abs(scale - 1.0) < 0.001) {
            return myShape;
        }
        TopoDS_Shape scaled = OccTriangulator.makeScale(myShape, scale);
        myShape.delete();
        return scaled;
    }

    public static TopoDS_Shape importIGES(String filename) {
        IGESControl_Reader aReader = new IGESControl_Reader();
        aReader.setReadUnitM();
        aReader.readFile(filename.getBytes());
        aReader.clearShapes();
        aReader.transferRoots();
        TopoDS_Shape result = aReader.oneShape();
        aReader.delete();
        return result;
    }

    public static TopoDS_Shape importSTEP(String filename) {
        STEPControl_Reader aReader = new STEPControl_Reader();
        aReader.setReadUnitM();
        aReader.readFile(filename.getBytes());
        aReader.clearShapes();
        aReader.transferRoots();
        TopoDS_Shape result = aReader.oneShape();
        aReader.delete();
        return result;
    }

    public static TopoDS_Shape makeTranslation(TopoDS_Shape aShape, double x, double y, double z) {
        GP_Trsf theTransformation = new GP_Trsf();
        theTransformation.setTranslation(new double[]{x, y, z});
        BRepBuilderAPI_Transform bt = new BRepBuilderAPI_Transform(aShape, theTransformation, true);
        TopoDS_Shape shape = bt.shape();
        bt.delete();
        theTransformation.delete();
        return shape;
    }

    public static TopoDS_Shape makeTorus(double[] pointStruct, double[] dirStruct, double r1, double r2) {
        double[] axe = new double[6];
        System.arraycopy(pointStruct, 0, axe, 0, 3);
        System.arraycopy(dirStruct, 0, axe, 3, 3);
        BRepPrimAPI_MakeTorus torus = new BRepPrimAPI_MakeTorus(axe, r1, r2);
        TopoDS_Shape tds = torus.shape();
        torus.delete();
        return tds;
    }

    public static TopoDS_Shape makeTorus(double[] pointStruct, double[] dirStruct, double[] dirStruct2, double r1, double r2) {
        double[] axe = new double[9];
        System.arraycopy(pointStruct, 0, axe, 0, 3);
        System.arraycopy(dirStruct, 0, axe, 3, 3);
        System.arraycopy(dirStruct2, 0, axe, 6, 3);
        BRepPrimAPI_MakeTorus torus = new BRepPrimAPI_MakeTorus(axe, r1, r2);
        TopoDS_Shape tds = torus.shape();
        torus.delete();
        return tds;
    }

    public static TopoDS_Shape makeTorus(double[] pointStruct, double[] dirStruct, double r1, double r2, double angle1, double angle2, double angle) {
        double[] axe = new double[6];
        System.arraycopy(pointStruct, 0, axe, 0, 3);
        System.arraycopy(dirStruct, 0, axe, 3, 3);
        BRepPrimAPI_MakeTorus torus = new BRepPrimAPI_MakeTorus(axe, r1, r2, angle1, angle2, angle);
        TopoDS_Shape tds = torus.shape();
        torus.delete();
        return tds;
    }

    public static TopoDS_Shape makeTorus(double[] pointStruct, double[] dirStruct, double[] dirStruct2, double r1, double r2, double angle1, double angle2, double angle) {
        double[] axe = new double[9];
        System.arraycopy(pointStruct, 0, axe, 0, 3);
        System.arraycopy(dirStruct, 0, axe, 3, 3);
        System.arraycopy(dirStruct2, 0, axe, 6, 3);
        BRepPrimAPI_MakeTorus torus = new BRepPrimAPI_MakeTorus(axe, r1, r2, angle1, angle2, angle);
        TopoDS_Shape tds = torus.shape();
        torus.delete();
        return tds;
    }

    public static TopoDS_Shape makeSphere(double x, double y, double z, double radius) {
        double[] c = new double[]{x, y, z};
        BRepPrimAPI_MakeSphere sphere = new BRepPrimAPI_MakeSphere(c, radius);
        TopoDS_Shape tds = sphere.shape();
        sphere.delete();
        return tds;
    }

    public static TopoDS_Shape makeRotation(TopoDS_Shape aShape, double[] axisStruct, double angle) {
        GP_Trsf theTransformation = new GP_Trsf();
        theTransformation.setRotation(axisStruct, angle);
        BRepBuilderAPI_Transform bt = new BRepBuilderAPI_Transform(aShape, theTransformation, true);
        TopoDS_Shape shape = bt.shape();
        bt.delete();
        theTransformation.delete();
        return shape;
    }

    public static TopoDS_Shape makeScale(TopoDS_Shape aShape, double s) {
        GP_Trsf theTransformation = new GP_Trsf();
        theTransformation.setValues(s, 0.0, 0.0, 0.0, 0.0, s, 0.0, 0.0, 0.0, 0.0, s, 0.0);
        BRepBuilderAPI_Transform bt = new BRepBuilderAPI_Transform(aShape, theTransformation, true);
        TopoDS_Shape shape = bt.shape();
        bt.delete();
        theTransformation.delete();
        return shape;
    }

    public static TopoDS_Shape makeCylinder(double[] pointStruct, double[] dirStruct, double radius, double height) {
        double[] axe = new double[6];
        System.arraycopy(pointStruct, 0, axe, 0, 3);
        System.arraycopy(dirStruct, 0, axe, 3, 3);
        BRepPrimAPI_MakeCylinder cyl = new BRepPrimAPI_MakeCylinder(axe, radius, height, Math.PI * 2);
        TopoDS_Shape tds = cyl.shape();
        cyl.delete();
        return tds;
    }

    public static TopoDS_Shape makeCopy(TopoDS_Shape topoDS_Shape) {
        return OccTriangulator.makeScale(topoDS_Shape, 1.0);
    }

    public static TopoDS_Shape makeCone(double[] pointStruct, double[] dirStruct, double radius1, double radius2, double height) {
        double[] axe = new double[6];
        System.arraycopy(pointStruct, 0, axe, 0, 3);
        System.arraycopy(dirStruct, 0, axe, 3, 3);
        BRepPrimAPI_MakeCone cone = new BRepPrimAPI_MakeCone(axe, radius1, radius2, height, Math.PI * 2);
        TopoDS_Shape tds = cone.shape();
        cone.delete();
        return tds;
    }

    public static TopoDS_Shape makeCompound(TopoDS_Shape[] shapes) {
        BRep_Builder builder = new BRep_Builder();
        TopoDS_Compound comp = new TopoDS_Compound();
        builder.makeCompound(comp);
        int i = 0;
        while (i < shapes.length) {
            builder.add((TopoDS_Shape)comp, shapes[i]);
            ++i;
        }
        builder.delete();
        return comp;
    }

    public static TopoDS_Shape makeBox(double x1, double y1, double z1, double x2, double y2, double z2) {
        double[] p1 = new double[]{x1, y1, z1};
        double[] p2 = new double[]{x2, y2, z2};
        BRepPrimAPI_MakeBox box = new BRepPrimAPI_MakeBox(p1, p2);
        TopoDS_Shape tds = box.shape();
        box.delete();
        return tds;
    }

    public static TopoDS_Shape makeCut(TopoDS_Shape shape1, TopoDS_Shape shape2) {
        BRepAlgoAPI_Cut cut = new BRepAlgoAPI_Cut(shape1, shape2);
        TopoDS_Shape s = cut.shape();
        cut.delete();
        return s;
    }

    public static TopoDS_Shape makeCommon(TopoDS_Shape shape1, TopoDS_Shape shape2) {
        BRepAlgoAPI_Common common = new BRepAlgoAPI_Common(shape1, shape2);
        TopoDS_Shape s = common.shape();
        common.delete();
        return s;
    }

    public static TopoDS_Shape makeFuse(TopoDS_Shape shape1, TopoDS_Shape shape2) {
        BRepAlgoAPI_Fuse fuse = new BRepAlgoAPI_Fuse(shape1, shape2);
        TopoDS_Shape s = fuse.shape();
        fuse.delete();
        return s;
    }

    public static TopoDS_Shape makeWedge(double[] pointStruct, double[] dirStruct, double dx, double dy, double dz, double xmin, double zmin, double xmax, double zmax) {
        double[] axe = new double[6];
        System.arraycopy(pointStruct, 0, axe, 0, 3);
        System.arraycopy(dirStruct, 0, axe, 3, 3);
        BRepPrimAPI_MakeWedge wedge = new BRepPrimAPI_MakeWedge(axe, dx, dy, dz, xmin, zmin, xmax, zmax);
        TopoDS_Shape s = wedge.shape();
        wedge.delete();
        return s;
    }

    public static TopoDS_Shape makeEllipticCylinder(double h, double r1, double r2) {
        GP_Elips ellipse = r1 < r2 ? new GP_Elips(new double[]{0.0, -h * 0.5, 0.0, 0.0, 1.0, 0.0}, r2, r1) : new GP_Elips(new double[]{0.0, -h * 0.5, 0.0, 0.0, 1.0, 0.0}, r1, r2);
        BRepBuilderAPI_MakeEdge edge = new BRepBuilderAPI_MakeEdge(ellipse);
        TopoDS_Edge ed = (TopoDS_Edge)edge.shape();
        BRepBuilderAPI_MakeWire wire = new BRepBuilderAPI_MakeWire(ed);
        TopoDS_Wire w = (TopoDS_Wire)wire.shape();
        BRepBuilderAPI_MakeFace face = new BRepBuilderAPI_MakeFace(w);
        TopoDS_Face F = (TopoDS_Face)face.shape();
        BRepPrimAPI_MakePrism prism = new BRepPrimAPI_MakePrism((TopoDS_Shape)F, new double[]{0.0, h, 0.0});
        TopoDS_Shape shape = prism.shape();
        ellipse.delete();
        edge.delete();
        wire.delete();
        face.delete();
        ed.delete();
        w.delete();
        F.delete();
        prism.delete();
        return shape;
    }

    public static TopoDS_Shape makeReqularPrism(double h, double r, int n) {
        if (n < 3) {
            n = 3;
        }
        Vector2d[] vertices = new Vector2d[n];
        int i = 0;
        while (i < n) {
            vertices[i] = new Vector2d(Math.sin(Math.PI * 2 * (double)i / (double)n) * r, Math.cos(Math.PI * 2 * (double)i / (double)n) * r);
            ++i;
        }
        BRepBuilderAPI_MakeWire wire = new BRepBuilderAPI_MakeWire();
        int i2 = 0;
        while (i2 < n) {
            Vector2d v1 = vertices[i2];
            Vector2d v2 = vertices[(i2 + 1) % n];
            BRepBuilderAPI_MakeEdge edge = new BRepBuilderAPI_MakeEdge(new double[]{v1.x, -h * 0.5, v1.y}, new double[]{v2.x, -h * 0.5, v2.y});
            wire.add((TopoDS_Edge)edge.shape());
            edge.delete();
            ++i2;
        }
        TopoDS_Wire w = (TopoDS_Wire)wire.shape();
        BRepBuilderAPI_MakeFace face = new BRepBuilderAPI_MakeFace(w);
        TopoDS_Face F = (TopoDS_Face)face.shape();
        face.delete();
        BRepPrimAPI_MakePrism prism = new BRepPrimAPI_MakePrism((TopoDS_Shape)F, new double[]{0.0, h, 0.0});
        TopoDS_Shape shape = prism.shape();
        prism.delete();
        wire.delete();
        w.delete();
        F.delete();
        return shape;
    }

    public static TopoDS_Shape makeFillet(TopoDS_Shape shape, double r) {
        BRepFilletAPI_MakeFillet fillet = new BRepFilletAPI_MakeFillet(shape);
        TopExp_Explorer exp = new TopExp_Explorer(shape, TopAbs_ShapeEnum.EDGE);
        while (exp.more()) {
            TopoDS_Edge e = (TopoDS_Edge)exp.current();
            fillet.add(r, e);
            e.delete();
            exp.next();
        }
        TopoDS_Shape result = fillet.shape();
        exp.delete();
        shape.delete();
        fillet.delete();
        return result;
    }

    public static TopoDS_Shape makeChamfer(TopoDS_Shape shape, double d) {
        BRepFilletAPI_MakeChamfer fillet = new BRepFilletAPI_MakeChamfer(shape);
        TopExp_Explorer exp = new TopExp_Explorer(shape, TopAbs_ShapeEnum.FACE);
        while (exp.more()) {
            TopoDS_Face f = (TopoDS_Face)exp.current();
            TopExp_Explorer exp2 = new TopExp_Explorer((TopoDS_Shape)f, TopAbs_ShapeEnum.EDGE);
            while (exp2.more()) {
                TopoDS_Edge e = (TopoDS_Edge)exp2.current();
                fillet.add(d, e, f);
                exp2.next();
                e.delete();
            }
            exp2.delete();
            f.delete();
            exp.next();
        }
        TopoDS_Shape result = fillet.shape();
        exp.delete();
        shape.delete();
        fillet.delete();
        return result;
    }

    public static void exportBREP(TopoDS_Shape shape, String filename) {
        BRepTools.write((TopoDS_Shape)shape, (String)filename);
    }
}

