/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.structural.schema;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.graph.annotations.GraphType;
import org.simantics.objmap.graph.annotations.HasCollectionAdder;
import org.simantics.objmap.graph.annotations.HasCollectionRemover;
import org.simantics.objmap.graph.annotations.HasSetter;
import org.simantics.objmap.graph.annotations.OptionalRelatedElements;
import org.simantics.objmap.graph.annotations.OrderedSetType;
import org.simantics.objmap.graph.annotations.RelatedElements;
import org.simantics.objmap.graph.annotations.RelatedElementsGet;
import org.simantics.objmap.graph.annotations.RelatedGetObj;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedOrderedSetElements;
import org.simantics.objmap.graph.annotations.RelatedValue;
import org.simantics.objmap.graph.annotations.UpdateMethod;
import org.simantics.objmap.graph.annotations.meta.IsClassRule;
import org.simantics.objmap.graph.annotations.meta.IsCollectionRule;
import org.simantics.objmap.graph.annotations.meta.IsFieldRule;
import org.simantics.objmap.graph.annotations.meta.IsGetSetRule;
import org.simantics.objmap.graph.annotations.meta.IsMethodRule;
import org.simantics.objmap.graph.rules.factory.IClassRuleFactory;
import org.simantics.objmap.graph.rules.factory.ICollectionRuleFactory;
import org.simantics.objmap.graph.rules.factory.IFieldRuleFactory;
import org.simantics.objmap.graph.rules.factory.IGetSetRuleFactory;
import org.simantics.objmap.graph.rules.factory.IMethodRuleFactory;
import org.simantics.objmap.structural.IStructuralObject;
import org.simantics.objmap.structural.StructuralResource;
import org.simantics.objmap.structural.annotations.StructuralRelatedElementsGet;
import org.simantics.objmap.structural.annotations.StructuralRelatedGetObj;
import org.simantics.objmap.structural.annotations.TypeRelatedElementsGet;
import org.simantics.objmap.structural.annotations.TypeRelatedGetObj;
import org.simantics.objmap.structural.annotations.TypeRelatedGetValue;
import org.simantics.objmap.structural.annotations.factories.OptionalRelatedElementsRuleFactory;
import org.simantics.objmap.structural.annotations.factories.RelatedElementsRuleFactory;
import org.simantics.objmap.structural.annotations.factories.RelatedElementsRuleFactory2;
import org.simantics.objmap.structural.annotations.factories.RelatedGetSetObjRuleFactory;
import org.simantics.objmap.structural.annotations.factories.RelatedGetSetValueRuleFactory;
import org.simantics.objmap.structural.annotations.factories.RelatedOrderedSetElementsRuleFactory;
import org.simantics.objmap.structural.annotations.factories.RelatedValueRuleFactory;
import org.simantics.objmap.structural.annotations.factories.StructuralRelatedElementsRuleFactory2;
import org.simantics.objmap.structural.annotations.factories.StructuralRelatedGetSetObjRuleFactory;
import org.simantics.objmap.structural.annotations.factories.TypeRelatedElementsRuleFactory2;
import org.simantics.objmap.structural.annotations.factories.TypeRelatedGetSetObjRuleFactory;
import org.simantics.objmap.structural.annotations.factories.TypeRelatedGetSetValueRuleFactory;
import org.simantics.objmap.structural.annotations.factories.UpdateMethodFactory;
import org.simantics.objmap.structural.schema.AdaptedLinkType;
import org.simantics.objmap.structural.schema.OrderedSetSimpleLinkType;
import org.simantics.objmap.structural.schema.SimpleLinkType;

public class MappingSchemas {
    public static SimpleLinkType fromAnnotations(ReadGraph g, Class<?> clazz) throws DatabaseException, InstantiationException, IllegalAccessException {
        GraphType graphType = clazz.getAnnotation(GraphType.class);
        if (graphType != null) {
            ArrayList<IBidirectionalMappingRule<StructuralResource, IStructuralObject>> rules = new ArrayList<IBidirectionalMappingRule<StructuralResource, IStructuralObject>>();
            MappingSchemas.collectRulesFromAnnotations(g, clazz, rules);
            return new SimpleLinkType(g.getResource(graphType.value()), clazz, rules);
        }
        OrderedSetType orderedSetType = clazz.getAnnotation(OrderedSetType.class);
        if (orderedSetType != null) {
            ArrayList<IBidirectionalMappingRule<StructuralResource, IStructuralObject>> rules = new ArrayList<IBidirectionalMappingRule<StructuralResource, IStructuralObject>>();
            MappingSchemas.collectRulesFromAnnotations(g, clazz, rules);
            return new OrderedSetSimpleLinkType(g.getResource(orderedSetType.value()), clazz, rules);
        }
        throw new IllegalArgumentException("Class " + clazz.toString() + " does not contain annotations.");
    }

    public static void collectRulesFromAnnotations(ReadGraph g, Class<?> clazz, Collection<IBidirectionalMappingRule<StructuralResource, IStructuralObject>> rules) throws DatabaseException, InstantiationException, IllegalAccessException {
        Annotation tag;
        Class<? extends Annotation> annotationType;
        Object m;
        Annotation tag2;
        Annotation annotation;
        int n;
        int n2;
        Annotation[] annotationArray;
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            MappingSchemas.collectRulesFromAnnotations(g, superclass, rules);
        }
        Object[] objectArray = clazz.getAnnotations();
        int n3 = objectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Annotation annotation2 = objectArray[n4];
            IsClassRule tag3 = annotation2.annotationType().getAnnotation(IsClassRule.class);
            if (tag3 != null) {
                rules.add(MappingSchemas.createClassRule(g, annotation2, clazz).create(g, annotation2, clazz));
            }
            ++n4;
        }
        objectArray = clazz.getDeclaredFields();
        n3 = objectArray.length;
        n4 = 0;
        while (n4 < n3) {
            Object f = objectArray[n4];
            ((Field)f).setAccessible(true);
            annotationArray = ((AccessibleObject)f).getAnnotations();
            n2 = annotationArray.length;
            n = 0;
            while (n < n2) {
                annotation = annotationArray[n];
                tag2 = annotation.annotationType().getAnnotation(IsFieldRule.class);
                if (tag2 != null) {
                    rules.add(MappingSchemas.createFieldRule(g, annotation, (Field)f).create(g, annotation, (Field)f));
                }
                ++n;
            }
            ++n4;
        }
        objectArray = clazz.getDeclaredMethods();
        n3 = objectArray.length;
        n4 = 0;
        while (n4 < n3) {
            m = objectArray[n4];
            ((Method)m).setAccessible(true);
            annotationArray = ((AccessibleObject)m).getAnnotations();
            n2 = annotationArray.length;
            n = 0;
            while (n < n2) {
                annotation = annotationArray[n];
                tag2 = annotation.annotationType().getAnnotation(IsMethodRule.class);
                if (tag2 != null) {
                    rules.add(MappingSchemas.createMethodRule(g, annotation, (Method)m).create(g, annotation, (Method)m));
                }
                ++n;
            }
            ++n4;
        }
        objectArray = clazz.getDeclaredMethods();
        n3 = objectArray.length;
        n4 = 0;
        while (n4 < n3) {
            m = objectArray[n4];
            ((Method)m).setAccessible(true);
            annotationArray = ((AccessibleObject)m).getAnnotations();
            n2 = annotationArray.length;
            n = 0;
            while (n < n2) {
                annotation = annotationArray[n];
                annotationType = annotation.annotationType();
                tag = annotationType.getAnnotation(IsGetSetRule.class);
                if (tag != null) {
                    HasSetter setterAnnType = annotationType.getAnnotation(HasSetter.class);
                    Class<? extends Annotation> setterAnn = setterAnnType.value();
                    Object getter = m;
                    IGetSetRuleFactory<StructuralResource, IStructuralObject> ruleFactory = MappingSchemas.createGetSetRuleFactory(g, annotation, (Method)getter);
                    Method setter = null;
                    Method[] methodArray = clazz.getDeclaredMethods();
                    int n5 = methodArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Method m2 = methodArray[n6];
                        Annotation set = m2.getAnnotation(setterAnn);
                        if (set != null && ruleFactory.isSetter(annotation, set)) {
                            setter = m2;
                        }
                        ++n6;
                    }
                    rules.add(ruleFactory.create(g, annotation, (Method)getter, setter));
                }
                ++n;
            }
            ++n4;
        }
        objectArray = clazz.getDeclaredMethods();
        n3 = objectArray.length;
        n4 = 0;
        while (n4 < n3) {
            m = objectArray[n4];
            ((Method)m).setAccessible(true);
            annotationArray = ((AccessibleObject)m).getAnnotations();
            n2 = annotationArray.length;
            n = 0;
            while (n < n2) {
                annotation = annotationArray[n];
                annotationType = annotation.annotationType();
                tag = annotationType.getAnnotation(IsCollectionRule.class);
                if (tag != null) {
                    HasCollectionAdder adderAnnType = annotationType.getAnnotation(HasCollectionAdder.class);
                    HasCollectionRemover removerAnnType = annotationType.getAnnotation(HasCollectionRemover.class);
                    Class<? extends Annotation> adderAnn = adderAnnType.value();
                    Class<? extends Annotation> removerAnn = removerAnnType.value();
                    Object getter = m;
                    ICollectionRuleFactory<StructuralResource, IStructuralObject> ruleFactory = MappingSchemas.createCollectionRuleFactory(g, annotation, (Method)getter);
                    Method adder = null;
                    Method remover = null;
                    Method[] methodArray = clazz.getDeclaredMethods();
                    int n7 = methodArray.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        Method m2 = methodArray[n8];
                        Annotation add = m2.getAnnotation(adderAnn);
                        Annotation rem = m2.getAnnotation(removerAnn);
                        if (add != null && ruleFactory.isAdder(annotation, add)) {
                            adder = m2;
                        }
                        if (rem != null && ruleFactory.isRemover(annotation, rem)) {
                            remover = m2;
                        }
                        ++n8;
                    }
                    rules.add(ruleFactory.create(g, annotation, (Method)getter, adder, remover));
                }
                ++n;
            }
            ++n4;
        }
    }

    public static IClassRuleFactory<StructuralResource, IStructuralObject> createClassRule(ReadGraph g, Annotation annotation, Class<?> clazz) {
        return null;
    }

    public static IFieldRuleFactory<StructuralResource, IStructuralObject> createFieldRule(ReadGraph g, Annotation annotation, Field field) {
        if (annotation.annotationType().equals(RelatedElements.class)) {
            return new RelatedElementsRuleFactory<IStructuralObject>();
        }
        if (annotation.annotationType().equals(RelatedValue.class)) {
            return new RelatedValueRuleFactory<IStructuralObject>();
        }
        if (annotation.annotationType().equals(OptionalRelatedElements.class)) {
            return new OptionalRelatedElementsRuleFactory<IStructuralObject>();
        }
        if (annotation.annotationType().equals(RelatedOrderedSetElements.class)) {
            return new RelatedOrderedSetElementsRuleFactory<IStructuralObject>();
        }
        return null;
    }

    public static IMethodRuleFactory<StructuralResource, IStructuralObject> createMethodRule(ReadGraph g, Annotation annotation, Method m) {
        if (annotation.annotationType().equals(UpdateMethod.class)) {
            return new UpdateMethodFactory<StructuralResource, IStructuralObject>();
        }
        return null;
    }

    public static IGetSetRuleFactory<StructuralResource, IStructuralObject> createGetSetRuleFactory(ReadGraph g, Annotation annotation, Method getter) {
        if (annotation.annotationType().equals(RelatedGetValue.class)) {
            return new RelatedGetSetValueRuleFactory<IStructuralObject>();
        }
        if (annotation.annotationType().equals(RelatedGetObj.class)) {
            return new RelatedGetSetObjRuleFactory<IStructuralObject>();
        }
        if (annotation.annotationType().equals(TypeRelatedGetValue.class)) {
            return new TypeRelatedGetSetValueRuleFactory<IStructuralObject>();
        }
        if (annotation.annotationType().equals(TypeRelatedGetObj.class)) {
            return new TypeRelatedGetSetObjRuleFactory<IStructuralObject>();
        }
        if (annotation.annotationType().equals(StructuralRelatedGetObj.class)) {
            return new StructuralRelatedGetSetObjRuleFactory<IStructuralObject>();
        }
        return null;
    }

    public static ICollectionRuleFactory<StructuralResource, IStructuralObject> createCollectionRuleFactory(ReadGraph g, Annotation annotation, Method getter) {
        if (annotation.annotationType().equals(RelatedElementsGet.class)) {
            return new RelatedElementsRuleFactory2<IStructuralObject>();
        }
        if (annotation.annotationType().equals(TypeRelatedElementsGet.class)) {
            return new TypeRelatedElementsRuleFactory2<IStructuralObject>();
        }
        if (annotation.annotationType().equals(StructuralRelatedElementsGet.class)) {
            return new StructuralRelatedElementsRuleFactory2<IStructuralObject>();
        }
        return null;
    }

    public static AdaptedLinkType fromAdaptable(ReadGraph g, String type, Class<?> clazz) throws DatabaseException, InstantiationException, IllegalAccessException {
        return new AdaptedLinkType(g.getResource(type), clazz);
    }
}

