/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.structural.schema;

import org.eclipse.core.runtime.IAdaptable;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.backward.IBackwardMapping;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.forward.IForwardMapping;
import org.simantics.objmap.graph.schema.ILinkType;
import org.simantics.objmap.structural.IStructuralObject;
import org.simantics.objmap.structural.StructuralResource;

public class AdaptedLinkType
implements ILinkType<StructuralResource, IStructuralObject> {
    Resource domainType;
    Class<?> rangeType;

    public AdaptedLinkType(Resource domainType, Class<?> rangeType) {
        this.domainType = domainType;
        this.rangeType = rangeType;
    }

    @Override
    public StructuralResource createDomainElement(WriteGraph g, IStructuralObject rangeElement) throws MappingException {
        try {
            IAdaptable adaptable = (IAdaptable)rangeElement;
            Resource res = (Resource)adaptable.getAdapter(Resource.class);
            if (res == null) {
                throw new NullPointerException();
            }
            return new StructuralResource((ReadGraph)g, res, new Resource[0]);
        }
        catch (Exception e) {
            throw new MappingException("Adapted object must implement IAdaptable interface to return the source Resource.", e);
        }
    }

    @Override
    public IStructuralObject createRangeElement(ReadGraph g, StructuralResource domainElement) throws MappingException {
        try {
            return (IStructuralObject)g.adapt(domainElement.getResource(), this.rangeType);
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public void createDomain(WriteGraph graph, IBackwardMapping<StructuralResource, IStructuralObject> mapping, StructuralResource domainElement, IStructuralObject rangeElement) throws MappingException {
    }

    @Override
    public void createRange(ReadGraph graph, IForwardMapping<StructuralResource, IStructuralObject> mapping, StructuralResource domainElement, IStructuralObject rangeElement) throws MappingException {
    }

    @Override
    public boolean checkChanges(ReadGraph graph, IForwardMapping<StructuralResource, IStructuralObject> mapping, StructuralResource domainElement, IStructuralObject rangeElement) throws MappingException {
        return false;
    }

    @Override
    public boolean updateDomain(WriteGraph g, IBackwardMapping<StructuralResource, IStructuralObject> map, StructuralResource domainElement, IStructuralObject rangeElement) throws MappingException {
        return false;
    }

    @Override
    public boolean updateRange(ReadGraph g, IForwardMapping<StructuralResource, IStructuralObject> map, StructuralResource domainElement, IStructuralObject rangeElement) throws MappingException {
        return false;
    }
}

