/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.ui;

import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ViewPart;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.ui.ScenegraphOutlinePage;
import org.simantics.objmap.graph.IMapping;
import org.simantics.objmap.structural.IStructuralObject;

public class SceneGraphDebugger
extends ViewPart {
    private TreeViewer viewer;
    private boolean linkToPart = true;
    IWorkbenchPart lastPart;
    private IMapping<Object, Object> mapping;
    IPartListener2 partListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            IWorkbenchPart part;
            if (SceneGraphDebugger.this.linkToPart && (part = partRef.getPart(false)) != null) {
                SceneGraphDebugger.this.refresh(null);
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart part;
            if (SceneGraphDebugger.this.linkToPart && (part = partRef.getPart(false)) != null && part != SceneGraphDebugger.this.lastPart) {
                SceneGraphDebugger.this.refresh(part);
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 65540);
        TreeColumnLayout layout = new TreeColumnLayout();
        parent.setLayout((Layout)layout);
        this.viewer.setContentProvider((IContentProvider)new ScenegraphOutlinePage.ScenegraphContentProvider());
        this.viewer.getTree().setHeaderVisible(true);
        TreeViewerColumn nameColumn = new TreeViewerColumn(this.viewer, 16384);
        nameColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(cell.getElement().toString());
            }
        });
        TreeViewerColumn typeColumn = new TreeViewerColumn(this.viewer, 16384);
        typeColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(cell.getElement().getClass().getSimpleName());
            }
        });
        TreeViewerColumn contextColumn = new TreeViewerColumn(this.viewer, 16384);
        contextColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                if (!(cell.getElement() instanceof IStructuralObject)) {
                    cell.setText("N/A");
                } else {
                    IStructuralObject o = (IStructuralObject)cell.getElement();
                    if (o.getContext() != null) {
                        cell.setText(o.getContext().toString());
                    } else {
                        cell.setText("none");
                    }
                }
            }
        });
        TreeViewerColumn mappingColumn = new TreeViewerColumn(this.viewer, 16384);
        mappingColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                if (SceneGraphDebugger.this.mapping == null) {
                    cell.setText("N/A");
                } else {
                    Object o = SceneGraphDebugger.this.mapping.inverseGet(cell.getElement());
                    if (o != null) {
                        cell.setText(o.toString());
                    } else {
                        cell.setText("none");
                    }
                }
            }
        });
        nameColumn.getColumn().setText("Name");
        typeColumn.getColumn().setText("Type");
        contextColumn.getColumn().setText("Context");
        mappingColumn.getColumn().setText("Mapping");
        layout.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, true));
        layout.setColumnData((Widget)typeColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, true));
        layout.setColumnData((Widget)contextColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, true));
        layout.setColumnData((Widget)mappingColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, true));
        IPartService partService = (IPartService)this.getSite().getService(IPartService.class);
        partService.addPartListener(this.partListener);
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    protected void refresh() {
        IEditorPart part = null;
        try {
            IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
            if (window == null) {
                return;
            }
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return;
            }
            part = page.getActiveEditor();
            if (part == null) {
                return;
            }
        }
        finally {
            if (part == null) {
                this.setContentDescription("No scene graph nodes available.");
            }
        }
        this.refresh((IWorkbenchPart)part);
    }

    protected boolean refresh(IWorkbenchPart part) {
        if (this.viewer.getTree().isDisposed()) {
            IPartService partService = (IPartService)this.getSite().getService(IPartService.class);
            partService.removePartListener(this.partListener);
            return false;
        }
        boolean foundInput = false;
        try {
            Object obj = null;
            if (part != null) {
                obj = part.getAdapter(INode.class);
            }
            if (obj != null) {
                this.mapping = (IMapping)part.getAdapter(IMapping.class);
                if (!this.viewer.getTree().isDisposed()) {
                    this.viewer.setInput(obj);
                }
                foundInput = true;
            }
            this.lastPart = part;
            boolean bl = foundInput;
            return bl;
        }
        finally {
            if (!foundInput) {
                this.setContentDescription("No scene graph nodes available.");
            }
        }
    }
}

