/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.tools;

import java.util.ArrayList;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.shape.Color4d;
import org.simantics.g3d.tools.Constraint;

public abstract class ConstraintDetector {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    private IG3DNode constraintReference = null;
    private ArrayList<Point3d> constraintPoints = new ArrayList();
    private ArrayList<Vector3d> constraintDirections = new ArrayList();
    protected Color4d xColor = new Color4d(1.0, 0.0, 0.0, 1.0);
    protected Color4d yColor = new Color4d(0.0, 1.0, 0.0, 1.0);
    protected Color4d zColor = new Color4d(0.0, 0.0, 1.0, 1.0);
    private double snapAngle = 0.1;
    private String snapString = "";

    public void clearConstraints() {
        this.constraintPoints.clear();
        this.constraintDirections.clear();
    }

    private void updateConstraints() {
        this.clearConstraints();
        if (this.constraintReference == null) {
            return;
        }
        Constraint c = (Constraint)this.constraintReference.getAdapter(Constraint.class);
        if (c == null) {
            return;
        }
        this.constraintPoints.addAll(c.points);
        this.constraintDirections.addAll(c.dirs);
    }

    public ArrayList<Point3d> getConstraintPoints() {
        return this.constraintPoints;
    }

    public ArrayList<Vector3d> getConstraintDirections() {
        return this.constraintDirections;
    }

    public void updateConstraintReference(IG3DNode node) {
        if (this.constraintReference != null && !this.constraintReference.equals(node)) {
            this.constraintReference = node;
            this.updateConstraints();
        } else if (node != null) {
            this.constraintReference = node;
            this.updateConstraints();
        }
    }

    public void addContraintPoint(Point3d p) {
        this.constraintPoints.add(p);
    }

    public void addContraintDirection(Vector3d v) {
        this.constraintDirections.add(v);
    }

    protected void clearSnapString() {
        this.snapString = "";
    }

    public Point3d getSnappedPoint(Vector3d pickPoint, Vector3d pickDir, Vector3d requestedPoint) {
        Point3d currentPoint;
        block10: {
            Vector3d t;
            Vector3d snappedPoint;
            block9: {
                snappedPoint = new Vector3d();
                t = new Vector3d();
                currentPoint = null;
                for (Vector3d constraintDir : this.constraintDirections) {
                    MathTools.intersectStraightStraight((Tuple3d)pickPoint, pickDir, (Tuple3d)requestedPoint, constraintDir, (Tuple3d)t, (Tuple3d)snappedPoint);
                    t.sub((Tuple3d)snappedPoint);
                    if (!(t.lengthSquared() < this.snapAngle)) continue;
                    this.snapString = String.valueOf(this.snapString) + "Angle snap ";
                    currentPoint = new Point3d((Tuple3d)snappedPoint);
                    break;
                }
                if (currentPoint == null) break block9;
                Vector3d dir = new Vector3d(currentPoint);
                dir.sub((Tuple3d)requestedPoint);
                Point3d p = this.getPointSnap(requestedPoint, dir);
                if (p == null) break block10;
                currentPoint = p;
                break block10;
            }
            ArrayList<Double> distances = new ArrayList<Double>();
            ArrayList<Point3d> snapPoints = new ArrayList<Point3d>();
            ArrayList<String> snapStrings = new ArrayList<String>();
            ArrayList<Color4d> snapColors = new ArrayList<Color4d>();
            for (Point3d constraintPoint : this.constraintPoints) {
                distances.clear();
                snapPoints.clear();
                snapStrings.clear();
                MathTools.intersectStraightStraight((Tuple3d)new Vector3d((Tuple3d)constraintPoint), new Vector3d(1.0, 0.0, 0.0), (Tuple3d)pickPoint, pickDir, (Tuple3d)snappedPoint, (Tuple3d)t);
                t.sub((Tuple3d)snappedPoint);
                double distance = t.lengthSquared();
                if (distance < this.snapAngle) {
                    distances.add(distance);
                    snapPoints.add(new Point3d((Tuple3d)snappedPoint));
                    snapStrings.add("Point x-snap ");
                    snapColors.add(this.xColor);
                }
                MathTools.intersectStraightStraight((Tuple3d)new Vector3d((Tuple3d)constraintPoint), new Vector3d(0.0, 1.0, 0.0), (Tuple3d)pickPoint, pickDir, (Tuple3d)snappedPoint, (Tuple3d)t);
                t.sub((Tuple3d)snappedPoint);
                distance = t.lengthSquared();
                if (distance < this.snapAngle) {
                    distances.add(distance);
                    snapPoints.add(new Point3d((Tuple3d)snappedPoint));
                    snapStrings.add("Point y-snap ");
                    snapColors.add(this.yColor);
                }
                MathTools.intersectStraightStraight((Tuple3d)new Vector3d((Tuple3d)constraintPoint), new Vector3d(0.0, 0.0, 1.0), (Tuple3d)pickPoint, pickDir, (Tuple3d)snappedPoint, (Tuple3d)t);
                t.sub((Tuple3d)snappedPoint);
                distance = t.lengthSquared();
                if (distance < this.snapAngle) {
                    distances.add(distance);
                    snapPoints.add(new Point3d((Tuple3d)snappedPoint));
                    snapStrings.add("Point z-snap ");
                    snapColors.add(this.zColor);
                }
                if (distances.size() <= 0) continue;
                if (distances.size() > 1) {
                    Vector3d ref = MathTools.closestPointOnStraight((Tuple3d)constraintPoint, (Tuple3d)new Point3d((Tuple3d)pickPoint), pickDir);
                    ref.sub((Tuple3d)constraintPoint);
                    distance = ref.lengthSquared();
                    if (distance < this.snapAngle) {
                        currentPoint = new Point3d(constraintPoint);
                        this.snapString = String.valueOf(this.snapString) + "Point snap ";
                        break;
                    }
                    int min = 0;
                    int i = 1;
                    while (i < distances.size()) {
                        if ((Double)distances.get(i) < (Double)distances.get(min)) {
                            min = i;
                        }
                        ++i;
                    }
                    currentPoint = (Point3d)snapPoints.get(min);
                    this.addConstrainLineHighlight(currentPoint, constraintPoint, (Color4d)((Object)snapColors.get(min)));
                    this.snapString = String.valueOf(this.snapString) + (String)snapStrings.get(min);
                    break;
                }
                currentPoint = (Point3d)snapPoints.get(0);
                this.addConstrainLineHighlight(currentPoint, constraintPoint, (Color4d)((Object)snapColors.get(0)));
                this.snapString = String.valueOf(this.snapString) + (String)snapStrings.get(0);
                break;
            }
        }
        return currentPoint;
    }

    public abstract void clearConstraintHighlights();

    protected abstract void addConstrainLineHighlight(Point3d var1, Point3d var2, Color4d var3);

    protected abstract void addConstrainPlaneHighlight(Point3d var1, Point3d var2, int var3);

    public Point3d getPointSnap(Vector3d requestedPoint, Vector3d requestedDir) {
        Vector3d snappedPoint = new Vector3d();
        Point3d currentPoint = null;
        double[] u = new double[1];
        ArrayList<Point3d> p1s = new ArrayList<Point3d>();
        ArrayList<Point3d> p2s = new ArrayList<Point3d>();
        ArrayList<Integer> axes = new ArrayList<Integer>();
        for (Point3d constraintPoint : this.constraintPoints) {
            boolean snap = false;
            if (MathTools.intersectStraightPlane((Tuple3d)requestedPoint, requestedDir, (Tuple3d)new Vector3d((Tuple3d)constraintPoint), this.getAxialVector(0), snappedPoint, u) && Math.abs(1.0 - u[0]) < this.snapAngle) {
                currentPoint = new Point3d((Tuple3d)snappedPoint);
                snap = true;
                p1s.add(constraintPoint);
                p2s.add(currentPoint);
                axes.add(0);
            }
            if (MathTools.intersectStraightPlane((Tuple3d)requestedPoint, requestedDir, (Tuple3d)new Vector3d((Tuple3d)constraintPoint), this.getAxialVector(1), snappedPoint, u) && Math.abs(1.0 - u[0]) < this.snapAngle) {
                currentPoint = new Point3d((Tuple3d)snappedPoint);
                snap = true;
                p1s.add(constraintPoint);
                p2s.add(currentPoint);
                axes.add(1);
            }
            if (MathTools.intersectStraightPlane((Tuple3d)requestedPoint, requestedDir, (Tuple3d)new Vector3d((Tuple3d)constraintPoint), this.getAxialVector(2), snappedPoint, u) && Math.abs(1.0 - u[0]) < this.snapAngle) {
                currentPoint = new Point3d((Tuple3d)snappedPoint);
                snap = true;
                p1s.add(constraintPoint);
                p2s.add(currentPoint);
                axes.add(2);
            }
            if (snap) break;
        }
        if (p1s.size() == 0) {
            return null;
        }
        if (p1s.size() == 1) {
            this.snapString = String.valueOf(this.snapString) + "Point/Plane ";
            switch ((Integer)axes.get(0)) {
                case 0: {
                    this.snapString = String.valueOf(this.snapString) + "x";
                    break;
                }
                case 1: {
                    this.snapString = String.valueOf(this.snapString) + "y";
                    break;
                }
                case 2: {
                    this.snapString = String.valueOf(this.snapString) + "z";
                }
            }
            this.snapString = String.valueOf(this.snapString) + "-snap ";
            this.addConstrainPlaneHighlight((Point3d)p1s.get(0), (Point3d)p2s.get(0), (Integer)axes.get(0));
            return currentPoint;
        }
        if (p1s.size() == 3) {
            this.snapString = String.valueOf(this.snapString) + "Point/Point ";
            return (Point3d)p1s.get(0);
        }
        Vector3d dir = new Vector3d();
        dir.cross(this.getAxialVector((Integer)axes.get(0)), this.getAxialVector((Integer)axes.get(1)));
        currentPoint = new Point3d((Tuple3d)MathTools.closestPointOnStraight((Tuple3d)currentPoint, (Tuple3d)p1s.get(0), dir));
        this.addConstrainLineHighlight((Point3d)p1s.get(0), currentPoint, this.xColor);
        this.snapString = String.valueOf(this.snapString) + "Point/Line ";
        return currentPoint;
    }

    private Vector3d getAxialVector(int axis) {
        switch (axis) {
            case 0: {
                return new Vector3d(1.0, 0.0, 0.0);
            }
            case 1: {
                return new Vector3d(0.0, 1.0, 0.0);
            }
            case 2: {
                return new Vector3d(0.0, 0.0, 1.0);
            }
        }
        throw new RuntimeException("Unknown axis " + axis);
    }

    public Point3d getPointSnap2(Vector3d requestedPoint, Vector3d requestedDir) {
        Vector3d snappedPoint = new Vector3d();
        Point3d currentPoint = null;
        double[] u = new double[1];
        for (Point3d constraintPoint : this.constraintPoints) {
            boolean snap = false;
            if (MathTools.intersectStraightPlane((Tuple3d)requestedPoint, requestedDir, (Tuple3d)new Vector3d((Tuple3d)constraintPoint), new Vector3d(1.0, 0.0, 0.0), snappedPoint, u) && Math.abs(u[0]) < this.snapAngle) {
                currentPoint = new Point3d((Tuple3d)snappedPoint);
                this.snapString = String.valueOf(this.snapString) + "Point/Plane x-snap ";
                snap = true;
                this.addConstrainPlaneHighlight(constraintPoint, currentPoint, 0);
            }
            if (MathTools.intersectStraightPlane((Tuple3d)requestedPoint, requestedDir, (Tuple3d)new Vector3d((Tuple3d)constraintPoint), new Vector3d(0.0, 1.0, 0.0), snappedPoint, u) && Math.abs(u[0]) < this.snapAngle) {
                currentPoint = new Point3d((Tuple3d)snappedPoint);
                this.snapString = String.valueOf(this.snapString) + "Point/Plane y-snap ";
                snap = true;
                this.addConstrainPlaneHighlight(constraintPoint, currentPoint, 1);
            }
            if (MathTools.intersectStraightPlane((Tuple3d)requestedPoint, requestedDir, (Tuple3d)new Vector3d((Tuple3d)constraintPoint), new Vector3d(0.0, 0.0, 1.0), snappedPoint, u) && Math.abs(u[0]) < this.snapAngle) {
                currentPoint = new Point3d((Tuple3d)snappedPoint);
                this.snapString = String.valueOf(this.snapString) + "Point/Plane z-snap ";
                snap = true;
                this.addConstrainPlaneHighlight(constraintPoint, currentPoint, 2);
            }
            if (snap) break;
        }
        return currentPoint;
    }

    public String getSnapString() {
        return this.snapString;
    }
}

