/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.shape;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.shape.Color4d;
import org.simantics.g3d.shape.Mesh;

public class Tube {
    List<Tuple3d> vertices;
    List<Vector3d> tangents;
    List<Color4d> colors;
    List<Double> radiis;
    Double radius = 1.0;
    int resolution = 8;
    boolean cap = false;

    public void setResolution(int resolution) {
        if (resolution > 2) {
            this.resolution = resolution;
        }
    }

    public void setVertices(List<Tuple3d> vertices) {
        this.vertices = vertices;
    }

    public void setTangents(List<Vector3d> tangents) {
        this.tangents = tangents;
    }

    public void setColors(List<Color4d> colors) {
        this.colors = colors;
    }

    public void setRadiis(List<Double> radiis) {
        this.radiis = radiis;
    }

    public void setRadius(Double radius) {
        this.radius = radius;
    }

    public void setCap(boolean cap) {
        this.cap = cap;
    }

    public Mesh create() {
        if (this.vertices.size() < 2) {
            throw new IllegalArgumentException("Tube must have at least two vertices");
        }
        Vector3d t = new Vector3d();
        if (this.tangents == null) {
            int i = 0;
            while (i < this.vertices.size() - 1) {
                t.set(this.vertices.get(i + 1));
                t.sub(this.vertices.get(i));
                if (t.lengthSquared() < MathTools.NEAR_ZERO) {
                    throw new IllegalArgumentException("vertices at index " + i + " are too close to each other");
                }
                ++i;
            }
        }
        int vcount = this.vertices.size() * this.resolution;
        int icount = (this.vertices.size() - 1) * this.resolution * 6;
        if (this.cap) {
            vcount += 2;
            icount += this.resolution * 6;
        }
        ArrayList<Vector3d> points = new ArrayList<Vector3d>(vcount);
        ArrayList<Vector3d> normals = new ArrayList<Vector3d>(vcount);
        int i = 0;
        while (i < this.vertices.size()) {
            this.createCircle(i, points, normals);
            ++i;
        }
        if (this.cap) {
            int l = this.vertices.size() - 1;
            points.add(new Vector3d(this.vertices.get(0)));
            points.add(new Vector3d(this.vertices.get(l)));
            Vector3d n1 = new Vector3d(this.vertices.get(1));
            n1.sub(this.vertices.get(0));
            n1.normalize();
            normals.add(n1);
            Vector3d n2 = new Vector3d(this.vertices.get(l - 1));
            n2.sub(this.vertices.get(l));
            n2.normalize();
            normals.add(n2);
        }
        int[] index = new int[icount];
        this.createIndices(index);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < index.length) {
            indices.add(index[i2]);
            ++i2;
        }
        this.vertices.clear();
        if (this.colors != null) {
            this.colors.clear();
        }
        if (this.radiis != null) {
            this.radiis.clear();
        }
        return Mesh.create(points, normals, indices);
    }

    private void createCircle(int i, List<Vector3d> points, List<Vector3d> normals) {
        Vector3d up = new Vector3d(0.0, 1.0, 0.0);
        Vector3d up2 = new Vector3d(0.0, 0.0, 1.0);
        Tuple3d p = this.vertices.get(i);
        Vector3d t = this.getTangent(i);
        Vector3d n = new Vector3d();
        if (Math.abs(up.dot(t)) < 0.99) {
            n.cross(up, t);
        } else {
            n.cross(up2, t);
        }
        n.normalize();
        if (this.radiis != null) {
            n.scale(this.radiis.get(i).doubleValue());
        } else {
            n.scale(this.radius.doubleValue());
        }
        int index = 0;
        while (index < this.resolution) {
            Vector3d v;
            if (index == 0) {
                v = new Vector3d(n);
            } else {
                AxisAngle4d aa = new AxisAngle4d(t, Math.PI * 2 * (double)index / (double)this.resolution);
                v = new Vector3d();
                MathTools.rotate(MathTools.getQuat(aa), (Tuple3d)n, (Tuple3d)v);
            }
            Vector3d pt = new Vector3d(p);
            pt.add((Tuple3d)v);
            points.add(pt);
            v.normalize();
            normals.add(v);
            ++index;
        }
    }

    private Vector3d getTangent(int i) {
        Tuple3d n;
        Tuple3d p;
        if (this.tangents != null) {
            return this.tangents.get(i);
        }
        if (i == 0) {
            p = this.vertices.get(0);
            n = this.vertices.get(1);
        } else if (i == this.vertices.size() - 1) {
            p = this.vertices.get(i - 1);
            n = this.vertices.get(i);
        } else {
            p = this.vertices.get(i - 1);
            n = this.vertices.get(i + 1);
        }
        Vector3d nn = new Vector3d(n);
        nn.sub(p);
        nn.normalize();
        return nn;
    }

    private void createIndices(int[] index) {
        int c = 0;
        while (c < this.vertices.size() - 1) {
            int s = 0;
            while (s < this.resolution) {
                int ii = (c * this.resolution + s) * 6;
                int iv = c * this.resolution + s;
                if (s < this.resolution - 1) {
                    index[ii + 2] = iv;
                    index[ii + 1] = iv + this.resolution;
                    index[ii + 0] = iv + this.resolution + 1;
                    index[ii + 5] = iv;
                    index[ii + 4] = iv + this.resolution + 1;
                    index[ii + 3] = iv + 1;
                } else {
                    index[ii + 2] = iv;
                    index[ii + 1] = iv + this.resolution;
                    index[ii + 0] = iv + 1;
                    index[ii + 5] = iv;
                    index[ii + 4] = iv + 1;
                    index[ii + 3] = iv + 1 - this.resolution;
                }
                ++s;
            }
            ++c;
        }
        if (this.cap) {
            int iv;
            int ii;
            c = 0;
            int isi = (this.vertices.size() - 1) * this.resolution * 6;
            int ivi = this.vertices.size() * this.resolution;
            int s = 0;
            while (s < this.resolution) {
                ii = isi + s * 3;
                iv = c * this.resolution + s;
                if (s < this.resolution - 1) {
                    index[ii + 2] = iv;
                    index[ii + 1] = iv + 1;
                    index[ii + 0] = ivi;
                } else {
                    index[ii + 2] = iv;
                    index[ii + 1] = iv + 1 - this.resolution;
                    index[ii + 0] = ivi;
                }
                ++s;
            }
            isi += this.resolution * 3;
            c = this.vertices.size() - 1;
            s = 0;
            while (s < this.resolution) {
                ii = isi + s * 3;
                iv = c * this.resolution + s;
                if (s < this.resolution - 1) {
                    index[ii + 2] = iv;
                    index[ii + 1] = iv + 1;
                    index[ii + 0] = ivi + 1;
                } else {
                    index[ii + 2] = iv;
                    index[ii + 1] = iv + 1 - this.resolution;
                    index[ii + 0] = ivi + 1;
                }
                ++s;
            }
        }
    }
}

