/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.scl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.ListenerList;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.g3d.scenegraph.NodeMap;
import org.simantics.g3d.scenegraph.NodeMapListener;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.NodeListener;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.IMapping;
import org.simantics.objmap.graph.IMappingListener;
import org.simantics.utils.datastructures.MapSet;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScriptNodeMap<DBObject, E extends INode>
implements NodeMap<DBObject, Object, E>,
IMappingListener,
NodeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptNodeMap.class);
    protected RequestProcessor session;
    protected IMapping<DBObject, INode> mapping;
    protected ParentNode<E> rootNode;
    protected Set<E> nodes = new HashSet();
    private boolean dirty = false;
    private boolean changeTracking = true;
    protected Object syncMutex = new Object();
    private List<Pair<E, String>> added = new ArrayList<Pair<E, String>>();
    private List<Pair<E, String>> removed = new ArrayList<Pair<E, String>>();
    private MapSet<E, String> updated = new MapSet.Hash();
    private boolean rangeModified = false;
    private boolean graphUpdates = false;
    private Set<E> graphModified = new HashSet();
    private boolean requestCommit = false;
    private String commitMessage = null;
    List<Pair<E, String>> rem = new ArrayList<Pair<E, String>>();
    List<Pair<E, String>> add = new ArrayList<Pair<E, String>>();
    MapSet<E, String> mod = new MapSet.Hash();
    Set<E> propagation = new HashSet();
    Stack<E> stack = new Stack();
    Set<E> delete = Collections.synchronizedSet(new HashSet());
    Set<E> deleteUC = new HashSet();
    private ListenerList<NodeListener> nodeListeners = new ListenerList();
    private ListenerList<NodeMapListener> nodeMaplisteners = new ListenerList();

    public ScriptNodeMap(RequestProcessor session, IMapping<DBObject, INode> mapping, ParentNode<E> rootNode) {
        this.session = session;
        this.mapping = mapping;
        this.rootNode = rootNode;
        mapping.addMappingListener((IMappingListener)this);
        rootNode.addListener(this);
    }

    protected abstract void addActor(E var1);

    protected abstract void removeActor(E var1);

    protected abstract void updateActor(E var1, Set<String> var2);

    public void repaint() {
        this.dirty = true;
    }

    public void populate() {
        for (INode node : this.rootNode.getNodes()) {
            this.receiveAdd(node, node.getParentRel(), true);
        }
        this.repaint();
    }

    @Override
    public E getNode(Object o) {
        return null;
    }

    @Override
    public Collection<Object> getRenderObjects(INode node) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public ParentNode<E> getRootNode() {
        return this.rootNode;
    }

    @Override
    public boolean isChangeTracking() {
        return this.changeTracking;
    }

    @Override
    public void setChangeTracking(boolean enabled) {
        this.changeTracking = enabled;
    }

    @Override
    public void updateRenderObjectsFor(E node) {
        this.nodes.add(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveAdd(E node, String id, boolean db) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("receiveAdd " + this.debugString(node) + " " + id + " " + db);
        }
        Object object = this.syncMutex;
        synchronized (object) {
            for (Pair<E, String> n : this.added) {
                if (!((INode)n.first).equals(node)) continue;
                return;
            }
            if (this.changeTracking) {
                this.mapping.rangeModified(node.getParent());
            }
            this.added.add(new Pair(node, (Object)id));
            this.rangeModified = true;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveRemove(E node, String id, boolean db) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("receiveRemove " + this.debugString(node) + " " + id + " " + db);
        }
        Object object = this.syncMutex;
        synchronized (object) {
            for (Pair<E, String> n : this.removed) {
                if (!((INode)n.first).equals(node)) continue;
                return;
            }
            if (this.changeTracking && !db) {
                this.mapping.rangeModified(node.getParent());
            }
            this.removed.add(new Pair(node, (Object)id));
            this.rangeModified = true;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveUpdate(E node, String id, boolean db) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("receiveUpdate " + this.debugString(node) + " " + id + " " + db);
        }
        Object object = this.syncMutex;
        synchronized (object) {
            if (this.changeTracking && !db) {
                this.mapping.rangeModified(node);
            }
            this.updated.add(node, (Object)id);
            this.rangeModified = true;
        }
        this.repaint();
    }

    @Override
    public void commit(String message) {
        this.requestCommit = true;
        this.commitMessage = message;
    }

    protected void doCommit() throws DatabaseException {
        this.session.syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Commit " + ScriptNodeMap.this.commitMessage);
                }
                if (ScriptNodeMap.this.commitMessage != null) {
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)ScriptNodeMap.this.commitMessage);
                    graph.markUndoPoint();
                    ScriptNodeMap.this.commitMessage = null;
                }
                ScriptNodeMap.this.commit(graph);
                ScriptNodeMap.this.fireCommit(graph);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit(WriteGraph graph) throws DatabaseException {
        Object object = this.syncMutex;
        synchronized (object) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Commit");
            }
            this.graphUpdates = true;
            this.mapping.updateDomain(graph);
            this.graphUpdates = false;
            this.clearDeletes();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Commit done");
            }
        }
    }

    public void domainModified() {
        if (this.graphUpdates) {
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("domainModified");
        }
        this.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset(ReadGraph graph) throws MappingException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Reset");
        }
        Object object = this.syncMutex;
        synchronized (object) {
            this.graphUpdates = true;
            this.mapping.getRangeModified().clear();
            for (Object o : this.mapping.getDomain()) {
                this.mapping.domainModified(o);
            }
            this.mapping.updateRange(graph);
            this.graphModified.clear();
            this.graphUpdates = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(ReadGraph graph) throws DatabaseException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Graph update start");
        }
        Object object = this.syncMutex;
        synchronized (object) {
            this.graphUpdates = true;
            for (Object domainObject : this.mapping.getDomainModified()) {
                INode rangeObject = (INode)this.mapping.get(domainObject);
                if (rangeObject == null) continue;
                this.graphModified.add(rangeObject);
            }
            this.mapping.updateRange(graph);
            this.graphModified.clear();
            this.syncDeletes();
            this.clearDeletes();
            this.graphUpdates = false;
        }
        if (this.mapping.isRangeModified()) {
            this.commit((String)null);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Graph update done");
        }
    }

    public void rangeModified() {
    }

    public void update() throws DatabaseException {
        while (this.dirty) {
            this.dirty = false;
            this.updateCycle();
            if (this.requestCommit && !this.rangeModified) {
                this.requestCommit = false;
                this.doCommit();
            }
            this.session.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    ScriptNodeMap.this.update(graph);
                }
            });
        }
    }

    protected void syncDeletes() {
        this.deleteUC.clear();
        for (Object n : this.removed) {
            this.deleteUC.add((INode)n.first);
        }
        for (Object n : this.added) {
            this.deleteUC.remove(n.first);
        }
        if (LOGGER.isTraceEnabled() && this.deleteUC.size() > 0) {
            LOGGER.trace("Delete sync");
            for (Object n : this.delete) {
                LOGGER.trace(this.debugString(n));
            }
        }
        this.delete.addAll(this.deleteUC);
        this.deleteUC.clear();
    }

    protected void clearDeletes() {
        if (LOGGER.isTraceEnabled() && this.delete.size() > 0) {
            LOGGER.trace("Delete");
        }
        for (INode n : this.delete) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(this.debugString(n));
            }
            this.mapping.getRange().remove(n);
        }
        this.delete.clear();
    }

    protected String debugString(E n) {
        return String.valueOf(n) + "@" + Integer.toHexString(n.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCycle() {
        Object ids;
        this.rem.clear();
        this.add.clear();
        this.mod.clear();
        this.propagation.clear();
        Object object = this.syncMutex;
        synchronized (object) {
            Iterator<Object> stack = new ArrayDeque<INode>();
            for (Object n : this.added) {
                stack.add((INode)n.first);
            }
            while (!stack.isEmpty()) {
                Object n;
                n = (INode)stack.pop();
                int i = this.removed.size() - 1;
                while (i >= 0) {
                    if (this.removed.get((int)i).first == n) {
                        this.removed.remove(i);
                        break;
                    }
                    --i;
                }
                if (!(n instanceof ParentNode)) continue;
                ParentNode pn = (ParentNode)n;
                for (INode cn : pn.getNodes()) {
                    stack.push(cn);
                }
            }
            this.rem.addAll(this.removed);
            this.add.addAll(this.added);
            for (INode e : this.updated.getKeys()) {
                for (String s : this.updated.getValues((Object)e)) {
                    this.mod.add((Object)e, (Object)s);
                }
            }
            this.syncDeletes();
            this.removed.clear();
            this.added.clear();
            this.updated.clear();
        }
        for (Pair pair : this.rem) {
            this.stopListening((INode)pair.first);
            this.removeActor((INode)pair.first);
        }
        for (Pair<E, String> pair : this.add) {
            this.addActor((INode)pair.first);
            this.listen((INode)pair.first);
        }
        for (INode iNode : this.mod.getKeys()) {
            ids = this.mod.getValues((Object)iNode);
            if (!ids.contains("http://www.simantics.org/G3D-0.1/hasPosition") && !ids.contains("http://www.simantics.org/G3D-0.1/hasOrientation") || this.propagation.contains(iNode)) continue;
            this.propagation.add(iNode);
        }
        if (this.propagation.size() > 0) {
            this.stack.clear();
            this.stack.addAll(this.propagation);
            this.propagation.clear();
            while (!this.stack.isEmpty()) {
                INode iNode = (INode)this.stack.pop();
                if (this.propagation.contains(iNode)) continue;
                this.propagation.add(iNode);
                for (NodeListener l : iNode.getListeners()) {
                    if (l == this) continue;
                    l.propertyChanged(iNode, "http://www.simantics.org/G3D-0.1/hasWorldPosition");
                }
                if (!(iNode instanceof ParentNode)) continue;
                this.stack.addAll(((ParentNode)iNode).getNodes());
            }
        }
        for (INode iNode : this.mod.getKeys()) {
            ids = this.mod.getValues((Object)iNode);
            this.updateActor(iNode, (Set<String>)ids);
        }
        for (Pair pair : this.rem) {
            for (NodeListener l : this.nodeListeners) {
                l.nodeRemoved(null, (INode)pair.first, (String)pair.second);
            }
        }
        for (Pair pair : this.add) {
            for (NodeListener l : this.nodeListeners) {
                l.nodeAdded(((INode)pair.first).getParent(), (INode)pair.first, (String)pair.second);
            }
        }
        for (INode iNode : this.mod.getKeys()) {
            for (NodeListener l : this.nodeListeners) {
                for (String s : this.mod.getValues((Object)iNode)) {
                    l.propertyChanged(iNode, s);
                }
            }
        }
        Object object2 = this.syncMutex;
        synchronized (object2) {
            if (this.added.isEmpty() && this.removed.isEmpty() && this.updated.getKeys().size() == 0) {
                this.rangeModified = false;
            }
        }
    }

    private void listen(INode node) {
        node.addListener(this);
        if (node instanceof ParentNode) {
            ParentNode parentNode = (ParentNode)node;
            for (INode n : parentNode.getNodes()) {
                this.listen(n);
            }
        }
    }

    private void stopListening(INode node) {
        node.removeListener(this);
        if (node instanceof ParentNode) {
            ParentNode parentNode = (ParentNode)node;
            for (INode n : parentNode.getNodes()) {
                this.stopListening(n);
            }
        }
    }

    @Override
    public void propertyChanged(INode node, String id) {
        this.receiveUpdate(node, id, this.graphModified.contains(node));
    }

    @Override
    public <T extends INode> void nodeAdded(ParentNode<T> node, INode child, String rel) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Node added " + String.valueOf(child) + " parent " + String.valueOf(node));
        }
        this.receiveAdd(child, rel, this.graphModified.contains(node));
    }

    @Override
    public <T extends INode> void nodeRemoved(ParentNode<T> node, INode child, String rel) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Node removed " + String.valueOf(child) + " parent " + String.valueOf(node));
        }
        this.receiveRemove(child, rel, this.graphModified.contains(node));
        this.stopListening(child);
    }

    @Override
    public void delete() {
        this.changeTracking = false;
        this.mapping.removeMappingListener((IMappingListener)this);
        for (INode node : this.nodes) {
            node.removeListener(this);
            this.removeActor(node);
            node.cleanup();
        }
        this.nodes.clear();
    }

    @Override
    public void addListener(NodeListener listener) {
        this.nodeListeners.add((Object)listener);
    }

    @Override
    public void removeListener(NodeListener listener) {
        this.nodeListeners.remove((Object)listener);
    }

    @Override
    public IMapping<DBObject, INode> getMapping() {
        return this.mapping;
    }

    private void fireCommit(WriteGraph graph) {
        for (NodeMapListener l : this.nodeMaplisteners) {
            l.commit(graph);
        }
    }

    @Override
    public void addListener(NodeMapListener listener) {
        this.nodeMaplisteners.add((Object)listener);
    }

    @Override
    public void removeListener(NodeMapListener listener) {
        this.nodeMaplisteners.remove((Object)listener);
    }
}

