/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.property;

import java.util.Arrays;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.property.PropertyManipulator;
import org.simantics.g3d.property.ValueProvider;

public class DoubleArrayPropertyManipulator
implements PropertyManipulator {
    ValueProvider provider;
    Object input;
    boolean editMode;
    double[] editValue = null;

    public DoubleArrayPropertyManipulator(ValueProvider provider, Object input) {
        this.provider = provider;
        this.input = input;
    }

    @Override
    public int getValueCount() {
        return 1;
    }

    @Override
    public String getDescription(int i) {
        return "Value";
    }

    private double[] getValue() {
        try {
            return (double[])this.provider.getValue(this.input);
        }
        catch (Exception e) {
            return new double[0];
        }
    }

    @Override
    public String getValue(int i) {
        double[] val;
        block4: {
            if (this.editMode) {
                return Arrays.toString(this.editValue);
            }
            try {
                val = this.getValue();
                if (val != null) break block4;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return Double.toString(MathTools.round(val[i], 10));
    }

    @Override
    public String setValue(String value, int i) {
        block4: {
            try {
                value = value.trim();
                if (value.startsWith("[") && value.endsWith("]")) {
                    value = value.substring(1, value.length() - 1);
                    String[] vals = value.split(",");
                    double[] val = new double[vals.length];
                    int j = 0;
                    while (j < vals.length) {
                        val[j] = Double.parseDouble(vals[j]);
                        ++j;
                    }
                    this.provider.setValue(this.input, val);
                    break block4;
                }
                return "Input must be values between [] characters separated with ,";
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        return null;
    }

    @Override
    public boolean getEditMode() {
        return this.editMode;
    }

    @Override
    public void setEditMode(boolean b) {
        this.editMode = b;
        if (this.editMode) {
            try {
                this.editValue = this.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

