/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.math;

import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.math.TriTriIntersection;
import org.simantics.g3d.shape.Mesh;
import org.simantics.utils.datastructures.Pair;

public class MeshMeshDistance {
    public static double distance(Mesh mesh1, Mesh mesh2) {
        double distance = Double.MAX_VALUE;
        int i = 0;
        while (i < mesh1.getIndices().size()) {
            Vector3d v00 = new Vector3d(mesh1.getVertices().get(mesh1.getIndices().get(i)));
            Vector3d v01 = new Vector3d(mesh1.getVertices().get(mesh1.getIndices().get(i + 1)));
            Vector3d v02 = new Vector3d(mesh1.getVertices().get(mesh1.getIndices().get(i + 2)));
            int j = 0;
            while (j < mesh2.getIndices().size()) {
                Vector3d v12;
                Vector3d v11;
                Vector3d v10 = new Vector3d(mesh2.getVertices().get(mesh2.getIndices().get(j)));
                if (TriTriIntersection.triTriIntesect(v00, v01, v02, v10, v11 = new Vector3d(mesh2.getVertices().get(mesh2.getIndices().get(j + 1))), v12 = new Vector3d(mesh2.getVertices().get(mesh2.getIndices().get(j + 2)))) != null) {
                    distance = 0.0;
                    return distance;
                }
                double d = MeshMeshDistance.distance(v00, v01, v02, v10, v11, v12);
                if (d < distance) {
                    distance = d;
                }
                j += 3;
            }
            i += 3;
        }
        return distance;
    }

    public static Pair<Double, Integer> distance(Mesh mesh1, Mesh mesh2, double delta) {
        double distance = Double.MAX_VALUE;
        double ddistance = Double.MAX_VALUE;
        int count = 0;
        int i = 0;
        while (i < mesh1.getIndices().size()) {
            Vector3d v00 = new Vector3d(mesh1.getVertices().get(mesh1.getIndices().get(i)));
            Vector3d v01 = new Vector3d(mesh1.getVertices().get(mesh1.getIndices().get(i + 1)));
            Vector3d v02 = new Vector3d(mesh1.getVertices().get(mesh1.getIndices().get(i + 2)));
            int j = 0;
            while (j < mesh2.getIndices().size()) {
                Vector3d v12;
                Vector3d v11;
                Vector3d v10 = new Vector3d(mesh2.getVertices().get(mesh2.getIndices().get(j)));
                double d = TriTriIntersection.triTriIntesect(v00, v01, v02, v10, v11 = new Vector3d(mesh2.getVertices().get(mesh2.getIndices().get(j + 1))), v12 = new Vector3d(mesh2.getVertices().get(mesh2.getIndices().get(j + 2)))) != null ? 0.0 : MeshMeshDistance.distance(v00, v01, v02, v10, v11, v12);
                if (Math.abs(distance - d) < delta) {
                    if (d < ddistance) {
                        ddistance = d;
                    }
                    ++count;
                } else if (d < distance) {
                    distance = d;
                    ddistance = d;
                    count = 1;
                }
                j += 3;
            }
            i += 3;
        }
        return new Pair((Object)ddistance, (Object)count);
    }

    public static double distancePtTriangle(Vector3d v0, Vector3d v1, Vector3d v2, Vector3d p) {
        Vector3d e02 = new Vector3d();
        Vector3d e12 = new Vector3d();
        Vector3d ep2 = new Vector3d();
        e02.sub((Tuple3d)v0, (Tuple3d)v2);
        e12.sub((Tuple3d)v1, (Tuple3d)v2);
        ep2.sub((Tuple3d)p, (Tuple3d)v2);
        double m02 = e02.lengthSquared();
        double m12 = e12.lengthSquared();
        double d = e02.dot(e12);
        double id = 1.0 / Math.max(m02 * m12 - MathTools.square(d), MathTools.NEAR_ZERO);
        double a = e02.dot(ep2);
        double b = e12.dot(ep2);
        double w12 = id * (m12 * a - d * b);
        double w20 = id * (m02 * b - d * a);
        double w01 = 1.0 - w12 - w20;
        if (w01 >= 0.0 && w12 >= 0.0 && w20 >= 0.0) {
            Vector3d i = new Vector3d();
            MathTools.mad((Tuple3d)i, (Tuple3d)v0, w12);
            MathTools.mad((Tuple3d)i, (Tuple3d)v1, w20);
            MathTools.mad((Tuple3d)i, (Tuple3d)v2, w01);
            return MathTools.distance((Tuple3d)p, (Tuple3d)i);
        }
        if (w12 > 0.0) {
            return Math.min(MathTools.distancePointEdge(p, v0, v1), MathTools.distancePointEdge(p, v0, v2));
        }
        if (w20 > 0.0) {
            return Math.min(MathTools.distancePointEdge(p, v0, v1), MathTools.distancePointEdge(p, v1, v2));
        }
        return Math.min(MathTools.distancePointEdge(p, v0, v2), MathTools.distancePointEdge(p, v1, v2));
    }

    public static double distancePtTriangle(Vector3d v0, Vector3d v1, Vector3d v2, Vector3d ... ps) {
        Vector3d e02 = new Vector3d();
        Vector3d e12 = new Vector3d();
        e02.sub((Tuple3d)v0, (Tuple3d)v2);
        e12.sub((Tuple3d)v1, (Tuple3d)v2);
        double m02 = e02.lengthSquared();
        double m12 = e12.lengthSquared();
        double d = e02.dot(e12);
        double id = 1.0 / Math.max(m02 * m12 - MathTools.square(d), MathTools.NEAR_ZERO);
        Vector3d ep2 = new Vector3d();
        double distance = Double.MAX_VALUE;
        Vector3d[] vector3dArray = ps;
        int n = ps.length;
        int n2 = 0;
        while (n2 < n) {
            Vector3d p = vector3dArray[n2];
            ep2.sub((Tuple3d)p, (Tuple3d)v2);
            double a = e02.dot(ep2);
            double b = e12.dot(ep2);
            double w12 = id * (m12 * a - d * b);
            double w20 = id * (m02 * b - d * a);
            double w01 = 1.0 - w12 - w20;
            if (w01 >= 0.0 && w12 >= 0.0 && w20 >= 0.0) {
                Vector3d i = new Vector3d();
                MathTools.mad((Tuple3d)i, (Tuple3d)v0, w12);
                MathTools.mad((Tuple3d)i, (Tuple3d)v1, w20);
                MathTools.mad((Tuple3d)i, (Tuple3d)v2, w01);
                distance = Math.min(distance, MathTools.distance((Tuple3d)p, (Tuple3d)i));
            } else {
                distance = w12 > 0.0 ? Math.min(distance, Math.min(MathTools.distancePointEdge(p, v0, v1), MathTools.distancePointEdge(p, v0, v2))) : (w20 > 0.0 ? Math.min(distance, Math.min(MathTools.distancePointEdge(p, v0, v1), MathTools.distancePointEdge(p, v1, v2))) : Math.min(distance, Math.min(MathTools.distancePointEdge(p, v0, v2), MathTools.distancePointEdge(p, v1, v2))));
            }
            ++n2;
        }
        return distance;
    }

    public static double distance(Vector3d v00, Vector3d v01, Vector3d v02, Vector3d v10, Vector3d v11, Vector3d v12) {
        double d1 = MeshMeshDistance.distancePtTriangle(v00, v01, v02, v10, v11, v12);
        double d2 = MeshMeshDistance.distancePtTriangle(v10, v11, v12, v00, v01, v02);
        return Math.min(d1, d2);
    }
}

