/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.math.Ray;
import org.simantics.g3d.scenegraph.RenderListener;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.g3d.vtk.shape.vtkShape;
import org.simantics.g3d.vtk.utils.vtkUtil;
import org.simantics.utils.datastructures.Triple;
import vtk.vtkActor;
import vtk.vtkCamera;
import vtk.vtkObjectBase;
import vtk.vtkProp;

public class GridDisplay
implements RenderListener {
    private VtkView panel;
    private List<GridLayer> gridLayers = new ArrayList<GridLayer>();
    double[] color1;
    double[] color2;
    Vector3d normal;
    int axis;
    int last;

    public GridDisplay(VtkView panel, int axis) {
        this.panel = panel;
        this.axis = axis;
        if (axis == 1) {
            this.normal = MathTools.X_AXIS;
        } else if (axis == 2) {
            this.normal = MathTools.Y_AXIS;
        } else if (axis == 4) {
            this.normal = MathTools.Z_AXIS;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void show() {
        Function<Double, double[]> colorFunc = c -> {
            double d = Math.round(c);
            double r = Math.abs(Math.IEEEremainder(d, 10.0));
            if (r < 0.1) {
                return new double[]{0.5, 0.5, 0.5};
            }
            return new double[]{0.7, 0.7, 0.7};
        };
        Function<Double, double[]> colorFunc2 = c -> {
            double d = Math.round(c);
            double r = Math.abs(Math.IEEEremainder(d, 100.0));
            double r2 = Math.abs(Math.IEEEremainder(d, 10.0));
            if (r < 0.1) {
                return new double[]{0.0, 0.0, 0.0};
            }
            if (r2 < 0.1) {
                return new double[]{0.5, 0.5, 0.5};
            }
            return new double[]{0.7, 0.7, 0.7};
        };
        int lines = 128;
        this.gridLayers.add(new GridLayer(100.0, 10.0, vtkShape.createGridActor(lines, 1.0, this.axis, colorFunc)));
        this.gridLayers.add(new GridLayer(200.0, 10.0, vtkShape.createGridActor(lines, 2.5, this.axis, colorFunc)));
        this.gridLayers.add(new GridLayer(400.0, 10.0, vtkShape.createGridActor(lines, 5.0, this.axis, colorFunc)));
        this.gridLayers.add(new GridLayer(2000.0, 100.0, vtkShape.createGridActor(lines, 10.0, this.axis, colorFunc2)));
        this.gridLayers.add(new GridLayer(8000.0, 100.0, vtkShape.createGridActor(lines, 50.0, this.axis, colorFunc2)));
        this.gridLayers.add(new GridLayer(24000.0, 100.0, vtkShape.createGridActor(lines, 100.0, this.axis, colorFunc2)));
        this.last = this.gridLayers.size() - 1;
        for (GridLayer l : this.gridLayers) {
            l.actor.SetPickable(0);
            this.panel.getRenderer().AddActor((vtkProp)l.actor);
            l.setVisible(false);
            this.panel.addDeletable((vtkObjectBase)l.actor);
        }
        this.panel.addListener(this);
        this.color1 = this.panel.getRenderer().GetBackground();
        this.color2 = new double[]{0.0, 0.0, 0.0};
    }

    public void preRender() {
        Point3d result;
        vtkCamera cam = this.panel.getRenderer().GetActiveCamera();
        double[] pos = cam.GetPosition();
        double[] focal = cam.GetFocalPoint();
        Point3d position = new Point3d(pos);
        Point3d focus = new Point3d(focal);
        Vector3d direction = new Vector3d((Tuple3d)focus);
        direction.sub((Tuple3d)position);
        if (direction.lengthSquared() > 0.001) {
            direction.normalize();
        }
        Ray centerRay = new Ray(position, direction);
        int[] size = this.panel.getRenderer().GetSize();
        Ray topRay = vtkUtil.createMouseRay(this.panel.getRenderer(), size[0] / 2, 0.0);
        Ray bottomRay = vtkUtil.createMouseRay(this.panel.getRenderer(), size[0] / 2, size[1]);
        ArrayList<Ray> rays = new ArrayList<Ray>(3);
        rays.add(centerRay);
        rays.add(topRay);
        rays.add(bottomRay);
        List<Object> results = new ArrayList<Triple>();
        for (Ray r : rays) {
            result = new Point3d();
            if (!MathTools.intersectStraightPlane((Tuple3d)r.pos, (Vector3d)r.dir, (Tuple3d)MathTools.ORIGIN, (Vector3d)this.normal, (Tuple3d)result)) continue;
            double cd = MathTools.distanceFromPlane((Vector3d)new Vector3d((Tuple3d)result), (Vector3d)direction, (Tuple3d)position);
            results.add(new Triple((Object)cd, (Object)result, (Object)r));
        }
        Triple resultTriple = null;
        if (results.size() > 0) {
            if ((Double)((Triple)results.get((int)0)).first < 0.0 || (Double)((Triple)results.get((int)0)).first > position.distance(focus) * 2.0) {
                Comparator<Triple<Double, Point3d, Ray>> comp = new Comparator<Triple<Double, Point3d, Ray>>(){

                    @Override
                    public int compare(Triple<Double, Point3d, Ray> o1, Triple<Double, Point3d, Ray> o2) {
                        if ((Double)o1.first > (Double)o2.first) {
                            return 1;
                        }
                        if ((Double)o1.first < (Double)o2.first) {
                            return -1;
                        }
                        return 0;
                    }
                };
                results = results.stream().filter(t -> (Double)t.first >= 0.0).sorted((Comparator<Triple>)comp).collect(Collectors.toList());
            }
            if (results.size() > 0) {
                resultTriple = (Triple)results.get(0);
            }
        }
        if (resultTriple != null) {
            Vector3d dir = ((Ray)resultTriple.third).dir;
            result = (Point3d)resultTriple.second;
            double angleFactor = Math.abs(dir.dot(this.normal));
            angleFactor = Math.sqrt(angleFactor);
            double dist = position.distance(result);
            if (angleFactor > 1.0E-8) {
                dist /= angleFactor;
            }
            int active = -1;
            int i = 0;
            while (i < this.gridLayers.size()) {
                GridLayer l = this.gridLayers.get(i);
                l.updatePosition(result);
                if (active < 0 && dist < l.dist) {
                    active = i;
                }
                ++i;
            }
            if (active < 0) {
                active = this.last;
            }
            i = 0;
            while (i < this.gridLayers.size()) {
                this.gridLayers.get(i).setVisible(i == active);
                ++i;
            }
            if (active == this.last) {
                double pd = this.gridLayers.get((int)(this.last - 1)).dist;
                double nd = this.gridLayers.get((int)this.last).dist;
                double scale = 1.0;
                if (dist > nd) {
                    scale = 0.0;
                } else {
                    double r = nd - pd;
                    scale = ((nd -= pd) - (dist -= pd)) / r;
                }
                if (scale < angleFactor) {
                    angleFactor = scale;
                }
            }
            this.gridLayers.get((int)active).actor.GetProperty().SetOpacity(angleFactor);
            this.gridLayers.get((int)active).actor.GetProperty().Delete();
        }
    }

    public void postRender() {
    }

    private class GridLayer {
        double dist;
        vtkActor actor;
        double roundFactor;

        public GridLayer(double dist, double roundFactor, vtkActor actor) {
            this.dist = dist;
            this.actor = actor;
            this.roundFactor = roundFactor;
        }

        public void setVisible(boolean visible) {
            this.actor.SetVisibility(visible ? 1 : 0);
        }

        public void updatePosition(Point3d result) {
            double x = (double)Math.round(result.x / this.roundFactor) * this.roundFactor;
            double y = (double)Math.round(result.y / this.roundFactor) * this.roundFactor;
            double z = (double)Math.round(result.z / this.roundFactor) * this.roundFactor;
            this.actor.SetPosition(x, y, z);
        }
    }
}

