/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.swt;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.math.BigDecimal;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.math.Ray;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.structural.IStructuralNode;
import org.simantics.g3d.toolbar.ToolComposite;
import org.simantics.g3d.vtk.Activator;
import org.simantics.g3d.vtk.common.VTKNodeMap;
import org.simantics.g3d.vtk.gizmo.TranslateAxisGizmo;
import org.simantics.g3d.vtk.swt.InteractiveVtkComposite;
import org.simantics.g3d.vtk.swt.vtkSwtAction;
import org.simantics.g3d.vtk.utils.vtkUtil;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import vtk.vtkProp;

public class TranslateAction
extends vtkSwtAction {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int XY = 3;
    public static final int XZ = 4;
    public static final int YZ = 5;
    public static final int P = 6;
    private VTKNodeMap<?, ? extends INode> nodeMap;
    private TranslateAxisGizmo gizmo = new TranslateAxisGizmo();
    protected IG3DNode node;
    private Cursor activeCursor;
    private Cursor dragCursor;
    protected ToolComposite toolComposite;
    protected Combo axisCombo;
    int index = 6;
    protected boolean valid = false;
    private boolean worldCoord = true;
    private AxisAngle4d aa = null;
    private Quat4d q = null;
    protected Vector3d prevTranslate = null;
    private double istep = 10.0;
    private int decimals = 2;

    public void setNode(IG3DNode node) {
        this.node = node;
        if (node instanceof IStructuralNode && ((IStructuralNode)node).isPartOfInstantiatedModel() && !((IStructuralNode)node).isInstantiatedModelRoot()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public IG3DNode getNode() {
        return this.node;
    }

    public TranslateAction(InteractiveVtkComposite panel, VTKNodeMap<?, ? extends INode> nodeMap, ToolComposite toolComposite) {
        super(panel);
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/arrow_out.png"));
        this.setText("Translate");
        this.nodeMap = nodeMap;
        this.activeCursor = Display.getCurrent().getSystemCursor(21);
        this.dragCursor = Display.getCurrent().getSystemCursor(5);
        this.toolComposite = toolComposite;
    }

    protected void createTools(ToolComposite toolComposite) {
        this.createMessage(toolComposite);
        this.createAxisSelection(toolComposite);
        this.createCloseButton(toolComposite);
        toolComposite.relayout();
    }

    protected void createMessage(ToolComposite toolComposite) {
        new Label((Composite)toolComposite, 8).setText("Press ESC to close translation. ");
    }

    protected void createAxisSelection(ToolComposite toolComposite) {
        Label label = new Label((Composite)toolComposite, 8);
        label.setText("Translate direction:");
        this.axisCombo = new Combo((Composite)toolComposite, 8);
        this.axisCombo.add("X");
        this.axisCombo.add("Y");
        this.axisCombo.add("Z");
        this.axisCombo.add("XY");
        this.axisCombo.add("XZ");
        this.axisCombo.add("YZ");
        this.axisCombo.add("Camera");
        this.axisCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Combo c = (Combo)e.getSource();
                TranslateAction.this.index = c.getSelectionIndex();
                TranslateAction.this.updateLock();
                TranslateAction.this.panel.getComponent().setFocus();
            }
        });
        this.axisCombo.select(this.index);
    }

    protected void createCloseButton(ToolComposite toolComposite) {
        Button close = new Button((Composite)toolComposite, 8);
        close.setText("Close");
        close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TranslateAction.this.panel.useDefaultAction();
            }
        });
    }

    @Override
    public void attach() {
        if (this.node == null) {
            return;
        }
        if (this.toolComposite != null) {
            this.createTools(this.toolComposite);
        }
        this.setDBUndo(false);
        super.attach();
        ThreadUtils.asyncExec((IThreadWorkQueue)this.panel.getThreadQueue(), (Runnable)new Runnable(){

            @Override
            public void run() {
                TranslateAction.this.attachUI();
                TranslateAction.this.update();
            }
        });
    }

    @Override
    public void deattach() {
        if (this.toolComposite != null) {
            this.toolComposite.clear();
            this.axisCombo = null;
        }
        this.setDBUndo(true);
        this.node = null;
        this.nodeMap.commit("Translate");
        this.deattachUI();
        super.deattach();
        this.panel.refresh();
    }

    private void attachUI() {
        this.panel.getComponent().setCursor(this.activeCursor);
        this.gizmo.attach(this.panel);
    }

    private void deattachUI() {
        this.panel.getComponent().setCursor(Display.getCurrent().getSystemCursor(0));
        this.gizmo.deattach();
    }

    @Override
    public boolean keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.panel.useDefaultAction();
        }
        if (this.valid) {
            return true;
        }
        if (e.getKeyCode() == 88) {
            this.index = this.index != 0 ? 0 : 6;
        }
        if (e.getKeyCode() == 89) {
            this.index = this.index != 1 ? 1 : 6;
        }
        if (e.getKeyCode() == 90) {
            this.index = this.index != 2 ? 2 : 6;
        }
        if (e.getKeyCode() == 71) {
            this.worldCoord = !this.worldCoord;
        }
        this.updateLock();
        this.update();
        return true;
    }

    private void updateLock() {
        this.gizmo.setType(this.index);
        if (this.axisCombo != null) {
            this.axisCombo.select(this.index);
        }
        this.panel.refresh();
    }

    @Override
    public boolean mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            if (this.isOverNode(e)) {
                return true;
            }
            this.panel.useDefaultAction();
            return true;
        }
        return false;
    }

    private boolean isOverNode(MouseEvent e) {
        vtkProp[] picked = this.panel.pick(e.getX(), e.getY());
        if (picked != null) {
            int i = 0;
            while (i < picked.length) {
                if (this.node.equals(this.nodeMap.getNode(picked[i]))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void setWorldCoord(boolean b) {
        if (this.worldCoord == b) {
            return;
        }
        this.worldCoord = b;
        this.update();
    }

    protected void update() {
        if (this.node == null) {
            return;
        }
        if (this.worldCoord) {
            this.gizmo.setRotation(new AxisAngle4d());
            this.aa = null;
            this.q = null;
        } else {
            this.aa = new AxisAngle4d();
            this.aa.set(((IG3DNode)this.node.getParent()).getWorldOrientation());
            this.gizmo.setRotation(this.aa);
            this.q = new Quat4d();
            MathTools.getQuat((AxisAngle4d)this.aa, (Quat4d)this.q);
        }
        Vector3d nodePos = this.node.getWorldPosition();
        this.gizmo.setPosition((Tuple3d)nodePos);
        Point3d camPos = new Point3d(this.panel.getRenderer().GetActiveCamera().GetPosition());
        Vector3d p = new Vector3d(nodePos);
        p.sub((Tuple3d)camPos);
        if (this.q != null) {
            Quat4d qi = new Quat4d(this.q);
            qi.inverse();
            MathTools.rotate((Quat4d)this.q, (Tuple3d)p, (Tuple3d)p);
        }
        if (this.panel.getRenderer().GetActiveCamera().GetParallelProjection() == 0) {
            double distance = p.length();
            p.negate();
            double fov = this.panel.getRenderer().GetActiveCamera().GetViewAngle();
            float s = (float)(Math.sin(fov) * distance * 0.1);
            Vector3d scale = new Vector3d(1.0, 1.0, 1.0);
            scale.scale((double)s);
            this.gizmo.setScale((Tuple3d)scale);
        } else {
            Vector3d scale = new Vector3d(1.0, 1.0, 1.0);
            double s = this.panel.getRenderer().GetActiveCamera().GetParallelScale() / 5.0;
            scale.scale(s);
            this.gizmo.setScale((Tuple3d)scale);
        }
        this.panel.refresh();
    }

    @Override
    public boolean mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            if (this.isOverNode(e)) {
                this.prevTranslate = this.getTranslate(e.getX(), e.getY());
                this.valid = true;
                this.panel.getComponent().setCursor(this.dragCursor);
            } else {
                this.valid = false;
                this.getDefaultAction().mousePressed(e);
                this.panel.getComponent().setCursor(this.activeCursor);
            }
        } else {
            this.getDefaultAction().mousePressed(e);
        }
        return true;
    }

    @Override
    public boolean mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            this.valid = false;
            this.prevTranslate = null;
            this.panel.getComponent().setCursor(this.activeCursor);
        } else {
            this.getDefaultAction().mouseReleased(e);
        }
        return true;
    }

    @Override
    public boolean mouseDragged(MouseEvent e) {
        if (e.getButton() == 1 && this.valid) {
            boolean step;
            Vector3d translate = this.getTranslate(e.getX(), e.getY(), this.prevTranslate);
            if (translate == null) {
                return true;
            }
            boolean bl = step = (e.getModifiers() & 2) > 0;
            if (this.worldCoord) {
                Vector3d pos = new Vector3d(this.node.getWorldPosition());
                pos.add((Tuple3d)translate);
                pos = this.constaints(pos, step);
                this.setWorldPos(pos);
            } else {
                Vector3d pos = new Vector3d(this.node.getPosition());
                pos.add((Tuple3d)translate);
                pos = this.constaints(pos, step);
                this.setPos(pos);
            }
            this.update();
        } else {
            this.getDefaultAction().mouseDragged(e);
            this.update();
        }
        return true;
    }

    @Override
    public boolean mouseWheelMoved(MouseWheelEvent e) {
        return this.getDefaultAction().mouseWheelMoved(e);
    }

    protected void setPos(Vector3d pos) {
        this.node.setPosition(pos);
    }

    protected void setWorldPos(Vector3d pos) {
        this.node.setWorldPosition(pos);
    }

    protected Vector3d constaints(Vector3d p, boolean step) {
        if (!step) {
            return p;
        }
        switch (this.index) {
            case 0: {
                p.x = (double)Math.round(this.istep * p.x) / this.istep;
                BigDecimal bx = new BigDecimal(p.x);
                bx.setScale(this.decimals, 4);
                p.x = bx.doubleValue();
                break;
            }
            case 1: {
                p.y = (double)Math.round(this.istep * p.y) / this.istep;
                BigDecimal by = new BigDecimal(p.y);
                by.setScale(this.decimals, 4);
                p.y = by.doubleValue();
                break;
            }
            case 2: {
                p.z = (double)Math.round(this.istep * p.z) / this.istep;
                BigDecimal bz = new BigDecimal(p.z);
                bz.setScale(this.decimals, 4);
                p.z = bz.doubleValue();
            }
        }
        return p;
    }

    @Override
    public boolean mouseMoved(MouseEvent e) {
        this.getDefaultAction().mouseMoved(e);
        return true;
    }

    protected Vector3d getTranslate(double x, double y) {
        return this.getTranslate(x, y, new Vector3d());
    }

    protected Vector3d getTranslate(double x, double y, Vector3d offset) {
        Vector3d translate = new Vector3d();
        Ray ray = vtkUtil.createMouseRay(this.panel.getRenderer(), x, y);
        Vector3d p = this.node.getWorldPosition();
        Vector3d dir = null;
        switch (this.index) {
            case 6: {
                Vector3d normal = new Vector3d(this.panel.getRenderer().GetActiveCamera().GetDirectionOfProjection());
                if (!this.worldCoord) {
                    MathTools.rotate((Quat4d)this.q, (Tuple3d)normal, (Tuple3d)normal);
                }
                normal.normalize();
                double[] s = new double[1];
                Vector3d r = new Vector3d();
                if (!MathTools.intersectStraightPlane((Tuple3d)ray.pos, (Vector3d)ray.dir, (Tuple3d)p, (Vector3d)normal, (Tuple3d)r)) break;
                r.sub((Tuple3d)p);
                translate.x = r.x;
                translate.y = r.y;
                translate.z = r.z;
                break;
            }
            case 0: {
                dir = new Vector3d(1.0, 0.0, 0.0);
                if (!this.worldCoord) {
                    MathTools.rotate((Quat4d)this.q, (Tuple3d)dir, (Tuple3d)dir);
                }
                Vector3d i1 = new Vector3d();
                Vector3d i2 = new Vector3d();
                double[] s = new double[2];
                MathTools.intersectStraightStraight((Tuple3d)p, (Vector3d)dir, (Tuple3d)ray.pos, (Vector3d)ray.dir, (Tuple3d)i2, (Tuple3d)i1, (double[])s);
                translate.x = s[0];
                break;
            }
            case 1: {
                dir = new Vector3d(0.0, 1.0, 0.0);
                if (!this.worldCoord) {
                    MathTools.rotate((Quat4d)this.q, (Tuple3d)dir, (Tuple3d)dir);
                }
                Vector3d i1 = new Vector3d();
                Vector3d i2 = new Vector3d();
                double[] s = new double[2];
                MathTools.intersectStraightStraight((Tuple3d)p, (Vector3d)dir, (Tuple3d)ray.pos, (Vector3d)ray.dir, (Tuple3d)i2, (Tuple3d)i1, (double[])s);
                translate.y = s[0];
                break;
            }
            case 2: {
                dir = new Vector3d(0.0, 0.0, 1.0);
                if (!this.worldCoord) {
                    MathTools.rotate((Quat4d)this.q, (Tuple3d)dir, (Tuple3d)dir);
                }
                Vector3d i1 = new Vector3d();
                Vector3d i2 = new Vector3d();
                double[] s = new double[2];
                MathTools.intersectStraightStraight((Tuple3d)p, (Vector3d)dir, (Tuple3d)ray.pos, (Vector3d)ray.dir, (Tuple3d)i2, (Tuple3d)i1, (double[])s);
                translate.z = s[0];
                break;
            }
            case 3: {
                Vector3d r;
                Vector3d normal = new Vector3d(0.0, 0.0, 1.0);
                if (!this.worldCoord) {
                    MathTools.rotate((Quat4d)this.q, (Tuple3d)normal, (Tuple3d)normal);
                }
                if (!MathTools.intersectStraightPlane((Tuple3d)ray.pos, (Vector3d)ray.dir, (Tuple3d)p, (Vector3d)normal, (Tuple3d)(r = new Vector3d()))) break;
                r.sub((Tuple3d)p);
                translate.x = r.x;
                translate.y = r.y;
                break;
            }
            case 4: {
                Vector3d r;
                Vector3d normal = new Vector3d(0.0, 1.0, 0.0);
                if (!this.worldCoord) {
                    MathTools.rotate((Quat4d)this.q, (Tuple3d)normal, (Tuple3d)normal);
                }
                if (!MathTools.intersectStraightPlane((Tuple3d)ray.pos, (Vector3d)ray.dir, (Tuple3d)p, (Vector3d)normal, (Tuple3d)(r = new Vector3d()))) break;
                r.sub((Tuple3d)p);
                translate.x = r.x;
                translate.z = r.z;
                break;
            }
            case 5: {
                Vector3d r;
                Vector3d normal = new Vector3d(1.0, 0.0, 0.0);
                if (!this.worldCoord) {
                    MathTools.rotate((Quat4d)this.q, (Tuple3d)normal, (Tuple3d)normal);
                }
                if (!MathTools.intersectStraightPlane((Tuple3d)ray.pos, (Vector3d)ray.dir, (Tuple3d)p, (Vector3d)normal, (Tuple3d)(r = new Vector3d()))) break;
                r.sub((Tuple3d)p);
                translate.y = r.y;
                translate.z = r.z;
                break;
            }
            default: {
                return null;
            }
        }
        translate.sub((Tuple3d)offset);
        return translate;
    }
}

