/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.shape;

import java.util.ArrayList;
import java.util.List;
import org.simantics.g3d.shape.Mesh;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.g3d.vtk.shape.MeshActor;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import vtk.vtkActor;
import vtk.vtkDataObject;
import vtk.vtkMapper;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkPolyDataNormals;
import vtk.vtkProp;
import vtk.vtkProp3D;
import vtk.vtkRenderer;

public class vtkMeshObject2 {
    private VtkView panel;
    private Mesh mesh;
    private vtkActor meshActor;
    private vtkActor edgesActor;

    public vtkMeshObject2(VtkView panel, Mesh mesh) {
        this.mesh = mesh;
        this.panel = panel;
    }

    public void visualizeMesh(boolean faces, boolean edges) {
        vtkPolyDataMapper mapper;
        this.clearActorsVTK();
        if (!faces && !edges) {
            return;
        }
        vtkPolyData polyData = MeshActor.createPolyData(this.mesh);
        if (faces) {
            this.meshActor = new vtkActor();
            mapper = new vtkPolyDataMapper();
            if (this.mesh.getNormals() == null) {
                vtkPolyDataNormals normals = new vtkPolyDataNormals();
                normals.SetInputData((vtkDataObject)polyData);
                normals.ComputePointNormalsOn();
                mapper.SetInputConnection(normals.GetOutputPort());
                normals.GetOutputPort().Delete();
                normals.Delete();
            } else {
                mapper.SetInputData(polyData);
            }
            if (this.mesh.getColors() != null) {
                mapper.ScalarVisibilityOn();
                mapper.SetScalarModeToUsePointFieldData();
                mapper.SelectColorArray("Colors");
            }
            this.meshActor.SetMapper((vtkMapper)mapper);
            mapper.Delete();
        }
        if (edges) {
            this.edgesActor = new vtkActor();
            mapper = new vtkPolyDataMapper();
            mapper.SetInputData(polyData);
            this.edgesActor.SetMapper((vtkMapper)mapper);
            this.edgesActor.GetProperty().SetRepresentationToWireframe();
            this.edgesActor.GetProperty().SetLighting(false);
            this.edgesActor.GetProperty().Delete();
            mapper.Delete();
        }
        polyData.GetPointData().Delete();
        polyData.Delete();
        this.showActorsVTK();
    }

    public vtkActor getMeshActor() {
        return this.meshActor;
    }

    public vtkActor getEdgesActor() {
        return this.edgesActor;
    }

    public List<vtkProp3D> getActors() {
        assert (Thread.currentThread() == this.panel.getThreadQueue().getThread());
        ArrayList<vtkProp3D> list = new ArrayList<vtkProp3D>(2);
        if (this.meshActor != null) {
            list.add((vtkProp3D)this.meshActor);
        }
        if (this.edgesActor != null) {
            list.add((vtkProp3D)this.edgesActor);
        }
        return list;
    }

    public void showActorsVTK() {
        assert (Thread.currentThread() == this.panel.getThreadQueue().getThread());
        this.panel.lock();
        vtkRenderer ren = this.panel.getRenderer();
        if (this.meshActor != null) {
            ren.AddActor((vtkProp)this.meshActor);
        }
        if (this.edgesActor != null) {
            ren.AddActor((vtkProp)this.edgesActor);
        }
        this.panel.unlock();
    }

    public void showActors() {
        ThreadUtils.asyncExec((IThreadWorkQueue)this.panel.getThreadQueue(), (Runnable)new Runnable(){

            @Override
            public void run() {
                vtkMeshObject2.this.showActorsVTK();
            }
        });
    }

    public void clearActorsVTK() {
        assert (Thread.currentThread() == this.panel.getThreadQueue().getThread());
        if (this.meshActor == null && this.edgesActor == null) {
            return;
        }
        vtkRenderer ren = this.panel.getRenderer();
        if (ren == null) {
            return;
        }
        this.panel.lock();
        if (this.meshActor != null) {
            if (this.meshActor.GetVTKId() != 0L) {
                ren.RemoveActor((vtkProp)this.meshActor);
                this.meshActor.Delete();
            }
            this.meshActor = null;
        }
        if (this.edgesActor != null) {
            if (this.edgesActor.GetVTKId() != 0L) {
                ren.RemoveActor((vtkProp)this.edgesActor);
                this.edgesActor.Delete();
            }
            this.edgesActor = null;
        }
        this.panel.unlock();
    }

    public void clearActors() {
        if (this.meshActor == null) {
            return;
        }
        ThreadUtils.asyncExec((IThreadWorkQueue)this.panel.getThreadQueue(), (Runnable)new Runnable(){

            @Override
            public void run() {
                vtkMeshObject2.this.clearActorsVTK();
            }
        });
    }

    public void dispose() {
        this.mesh = null;
        this.clearActors();
    }

    public void delete() {
        this.mesh = null;
        this.clearActorsVTK();
    }
}

