/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.g3d.tools.AdaptationUtils;
import org.simantics.g3d.ui.ScenegraphOutlinePage;
import org.simantics.g3d.vtk.common.NodeSelectionProvider2;
import org.simantics.g3d.vtk.common.VTKSelectionItem;

public class VTKContentOutlinePage<DBObject, JavaObject extends INode>
extends ScenegraphOutlinePage {
    private NodeSelectionProvider2<DBObject, JavaObject> provider;
    private boolean outsideSelection = false;
    List<INode> selectedNodes = new ArrayList<INode>();

    public VTKContentOutlinePage(ParentNode<? extends JavaObject> rootNode, NodeSelectionProvider2<DBObject, JavaObject> selectionProvider) {
        super(rootNode);
        this.provider = selectionProvider;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.provider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object source = event.getSource();
                if (source == VTKContentOutlinePage.this) {
                    return;
                }
                ISelection s = event.getSelection();
                Collection nodes = AdaptationUtils.adaptToCollection((Object)s, INode.class);
                VTKContentOutlinePage.this.outsideSelection = true;
                VTKContentOutlinePage.this.getTreeViewer().setSelection((ISelection)new StructuredSelection(nodes.toArray()), true);
                VTKContentOutlinePage.this.outsideSelection = false;
            }
        });
    }

    protected void fireSelectionChanged(ISelection selection) {
        if (this.outsideSelection) {
            return;
        }
        Collection selectedUnsortedNodes = AdaptationUtils.adaptToCollection((Object)selection, INode.class);
        ArrayList<INode> toRemove = new ArrayList<INode>();
        for (INode node : this.selectedNodes) {
            if (selectedUnsortedNodes.contains(node)) continue;
            toRemove.add(node);
        }
        for (INode node : toRemove) {
            this.selectedNodes.remove(node);
        }
        for (INode node : selectedUnsortedNodes) {
            if (this.selectedNodes.contains(node)) continue;
            this.selectedNodes.add(node);
        }
        ArrayList<VTKSelectionItem<Object>> selectedItems = new ArrayList<VTKSelectionItem<Object>>();
        for (INode node : this.selectedNodes) {
            Object r = this.provider.mapping.inverseGet((Object)node);
            selectedItems.add(new VTKSelectionItem<Object>(null, (INode)((IG3DNode)node), r));
        }
        super.fireSelectionChanged((ISelection)new StructuredSelection(selectedItems));
    }
}

