/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.awt;

import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.math.Ray;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.structural.IStructuralNode;
import org.simantics.g3d.vtk.Activator;
import org.simantics.g3d.vtk.awt.InteractiveVtkPanel;
import org.simantics.g3d.vtk.awt.vtkAwtAction;
import org.simantics.g3d.vtk.common.VTKNodeMap;
import org.simantics.g3d.vtk.gizmo.TranslateAxisGizmo;
import org.simantics.g3d.vtk.utils.vtkUtil;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import vtk.vtkProp;

public class TranslateAction
extends vtkAwtAction {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int XY = 3;
    public static final int XZ = 4;
    public static final int YZ = 5;
    public static final int P = 6;
    private VTKNodeMap<?, ? extends INode> nodeMap;
    private TranslateAxisGizmo gizmo = new TranslateAxisGizmo();
    protected IG3DNode node;
    private Cursor activeCursor = Cursor.getPredefinedCursor(12);
    private Cursor dragCursor = Cursor.getPredefinedCursor(13);
    int index = 6;
    protected boolean valid = false;
    private boolean worldCoord = true;
    private AxisAngle4d aa = null;
    private Quat4d q = null;
    protected Vector3d prevTranslate = null;
    private double istep = 10.0;
    private int decimals = 2;

    public void setNode(IG3DNode node) {
        this.node = node;
        if (node instanceof IStructuralNode && ((IStructuralNode)node).isPartOfInstantiatedModel() && !((IStructuralNode)node).isInstantiatedModelRoot()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public IG3DNode getNode() {
        return this.node;
    }

    public TranslateAction(InteractiveVtkPanel panel, VTKNodeMap<?, ? extends INode> nodeMap) {
        super(panel);
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/arrow_out.png"));
        this.setText("Translate");
        this.nodeMap = nodeMap;
    }

    @Override
    public void attach() {
        if (this.node == null) {
            return;
        }
        super.attach();
        ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                TranslateAction.this.attachUI();
                TranslateAction.this.update();
            }
        });
    }

    @Override
    public void deattach() {
        this.node = null;
        this.nodeMap.commit("Translate");
        this.deattachUI();
        super.deattach();
        this.panel.repaint();
    }

    private void attachUI() {
        this.panel.setCursor(this.activeCursor);
        this.gizmo.attach(this.panel);
    }

    private void deattachUI() {
        this.panel.setCursor(Cursor.getPredefinedCursor(0));
        this.gizmo.deattach();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.panel.useDefaultAction();
        }
        if (this.valid) {
            return;
        }
        if (e.getKeyCode() == 88) {
            this.index = this.index != 0 ? 0 : 6;
        }
        if (e.getKeyCode() == 89) {
            this.index = this.index != 1 ? 1 : 6;
        }
        if (e.getKeyCode() == 90) {
            this.index = this.index != 2 ? 2 : 6;
        }
        if (e.getKeyCode() == 71) {
            this.worldCoord = !this.worldCoord;
        }
        this.gizmo.setType(this.index);
        this.update();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            if (this.isOverNode(e)) {
                return;
            }
            this.panel.useDefaultAction();
        }
    }

    private boolean isOverNode(MouseEvent e) {
        vtkProp[] picked = this.panel.pick(e.getX(), e.getY());
        if (picked != null) {
            int i = 0;
            while (i < picked.length) {
                if (this.node.equals(this.nodeMap.getNode(picked[i]))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void setWorldCoord(boolean b) {
        if (this.worldCoord == b) {
            return;
        }
        this.worldCoord = b;
        this.update();
    }

    protected void update() {
        if (this.node == null) {
            return;
        }
        if (this.worldCoord) {
            this.gizmo.setRotation(new AxisAngle4d());
            this.aa = null;
            this.q = null;
        } else {
            this.aa = new AxisAngle4d();
            this.aa.set(((IG3DNode)this.node.getParent()).getWorldOrientation());
            this.gizmo.setRotation(this.aa);
            this.q = new Quat4d();
            MathTools.getQuat((AxisAngle4d)this.aa, (Quat4d)this.q);
        }
        Vector3d nodePos = this.node.getWorldPosition();
        this.gizmo.setPosition((Tuple3d)nodePos);
        Point3d camPos = new Point3d(this.panel.GetRenderer().GetActiveCamera().GetPosition());
        Vector3d p = new Vector3d(nodePos);
        p.sub((Tuple3d)camPos);
        if (this.q != null) {
            Quat4d qi = new Quat4d(this.q);
            qi.inverse();
            MathTools.rotate((Quat4d)this.q, (Tuple3d)p, (Tuple3d)p);
        }
        if (this.panel.GetRenderer().GetActiveCamera().GetParallelProjection() == 0) {
            double distance = p.length();
            p.negate();
            double fov = this.panel.GetRenderer().GetActiveCamera().GetViewAngle();
            float s = (float)(Math.sin(fov) * distance * 0.1);
            Vector3d scale = new Vector3d(1.0, 1.0, 1.0);
            scale.scale((double)s);
            this.gizmo.setScale((Tuple3d)scale);
        } else {
            Vector3d scale = new Vector3d(1.0, 1.0, 1.0);
            double s = this.panel.GetRenderer().GetActiveCamera().GetParallelScale() / 5.0;
            scale.scale(s);
            this.gizmo.setScale((Tuple3d)scale);
        }
        this.panel.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            if (this.isOverNode(e)) {
                this.prevTranslate = this.getTranslate(e.getX(), e.getY());
                this.valid = true;
                this.panel.setCursor(this.dragCursor);
            } else {
                this.valid = false;
                this.getDefaultAction().mousePressed(e);
                this.panel.setCursor(this.activeCursor);
            }
        } else {
            this.getDefaultAction().mousePressed(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            this.valid = false;
            this.prevTranslate = null;
            this.panel.setCursor(this.activeCursor);
        } else {
            this.getDefaultAction().mouseReleased(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if ((e.getModifiersEx() & 0x400) > 0 && this.valid) {
            boolean step;
            Vector3d translate = this.getTranslate(e.getX(), e.getY(), this.prevTranslate);
            if (translate == null) {
                return;
            }
            boolean bl = step = (e.getModifiers() & 2) > 0;
            if (this.worldCoord) {
                Vector3d pos = new Vector3d(this.node.getWorldPosition());
                pos.add((Tuple3d)translate);
                pos = this.constaints(pos, step);
                this.setWorldPos(pos);
            } else {
                Vector3d pos = new Vector3d(this.node.getPosition());
                pos.add((Tuple3d)translate);
                pos = this.constaints(pos, step);
                this.setPos(pos);
            }
            this.update();
        } else {
            this.getDefaultAction().mouseDragged(e);
            this.update();
        }
    }

    protected void setPos(Vector3d pos) {
        this.node.setPosition(pos);
    }

    protected void setWorldPos(Vector3d pos) {
        this.node.setWorldPosition(pos);
    }

    protected Vector3d constaints(Vector3d p, boolean step) {
        if (!step) {
            return p;
        }
        switch (this.index) {
            case 0: {
                p.x = (double)Math.round(this.istep * p.x) / this.istep;
                BigDecimal bx = new BigDecimal(p.x);
                bx.setScale(this.decimals, 4);
                p.x = bx.doubleValue();
                break;
            }
            case 1: {
                p.y = (double)Math.round(this.istep * p.y) / this.istep;
                BigDecimal by = new BigDecimal(p.y);
                by.setScale(this.decimals, 4);
                p.y = by.doubleValue();
                break;
            }
            case 2: {
                p.z = (double)Math.round(this.istep * p.z) / this.istep;
                BigDecimal bz = new BigDecimal(p.z);
                bz.setScale(this.decimals, 4);
                p.z = bz.doubleValue();
            }
        }
        return p;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.getDefaultAction().mouseMoved(e);
    }

    protected Vector3d getTranslate(double x, double y) {
        return this.getTranslate(x, y, new Vector3d());
    }

    protected Vector3d getTranslate(double x, double y, Vector3d offset) {
        Vector3d translate = new Vector3d();
        Ray ray = vtkUtil.createMouseRay(this.panel.GetRenderer(), x, y);
        Vector3d p = this.node.getWorldPosition();
        Vector3d dir = null;
        switch (this.index) {
            case 6: {
                Vector3d normal = new Vector3d(this.panel.GetRenderer().GetActiveCamera().GetDirectionOfProjection());
                if (!this.worldCoord) {
                    MathTools.rotate((Quat4d)this.q, (Tuple3d)normal, (Tuple3d)normal);
                }
                normal.normalize();
                double[] s = new double[1];
                Vector3d r = new Vector3d();
                if (!MathTools.intersectStraightPlane((Tuple3d)ray.pos, (Vector3d)ray.dir, (Tuple3d)p, (Vector3d)normal, (Tuple3d)r)) break;
                r.sub((Tuple3d)p);
                translate.x = r.x;
                translate.y = r.y;
                translate.z = r.z;
                break;
            }
            case 0: {
                dir = new Vector3d(1.0, 0.0, 0.0);
                if (!this.worldCoord) {
                    MathTools.rotate((Quat4d)this.q, (Tuple3d)dir, (Tuple3d)dir);
                }
                Vector3d i1 = new Vector3d();
                Vector3d i2 = new Vector3d();
                double[] s = new double[2];
                MathTools.intersectStraightStraight((Tuple3d)p, (Vector3d)dir, (Tuple3d)ray.pos, (Vector3d)ray.dir, (Tuple3d)i2, (Tuple3d)i1, (double[])s);
                translate.x = s[0];
                break;
            }
            case 1: {
                dir = new Vector3d(0.0, 1.0, 0.0);
                if (!this.worldCoord) {
                    MathTools.rotate((Quat4d)this.q, (Tuple3d)dir, (Tuple3d)dir);
                }
                Vector3d i1 = new Vector3d();
                Vector3d i2 = new Vector3d();
                double[] s = new double[2];
                MathTools.intersectStraightStraight((Tuple3d)p, (Vector3d)dir, (Tuple3d)ray.pos, (Vector3d)ray.dir, (Tuple3d)i2, (Tuple3d)i1, (double[])s);
                translate.y = s[0];
                break;
            }
            case 2: {
                dir = new Vector3d(0.0, 0.0, 1.0);
                if (!this.worldCoord) {
                    MathTools.rotate((Quat4d)this.q, (Tuple3d)dir, (Tuple3d)dir);
                }
                Vector3d i1 = new Vector3d();
                Vector3d i2 = new Vector3d();
                double[] s = new double[2];
                MathTools.intersectStraightStraight((Tuple3d)p, (Vector3d)dir, (Tuple3d)ray.pos, (Vector3d)ray.dir, (Tuple3d)i2, (Tuple3d)i1, (double[])s);
                translate.z = s[0];
                break;
            }
            case 3: {
                Vector3d r;
                Vector3d normal = new Vector3d(0.0, 0.0, 1.0);
                if (!this.worldCoord) {
                    MathTools.rotate((Quat4d)this.q, (Tuple3d)normal, (Tuple3d)normal);
                }
                if (!MathTools.intersectStraightPlane((Tuple3d)ray.pos, (Vector3d)ray.dir, (Tuple3d)p, (Vector3d)normal, (Tuple3d)(r = new Vector3d()))) break;
                r.sub((Tuple3d)p);
                translate.x = r.x;
                translate.y = r.y;
                break;
            }
            case 4: {
                Vector3d r;
                Vector3d normal = new Vector3d(0.0, 1.0, 0.0);
                if (!this.worldCoord) {
                    MathTools.rotate((Quat4d)this.q, (Tuple3d)normal, (Tuple3d)normal);
                }
                if (!MathTools.intersectStraightPlane((Tuple3d)ray.pos, (Vector3d)ray.dir, (Tuple3d)p, (Vector3d)normal, (Tuple3d)(r = new Vector3d()))) break;
                r.sub((Tuple3d)p);
                translate.x = r.x;
                translate.z = r.z;
                break;
            }
            case 5: {
                Vector3d r;
                Vector3d normal = new Vector3d(1.0, 0.0, 0.0);
                if (!this.worldCoord) {
                    MathTools.rotate((Quat4d)this.q, (Tuple3d)normal, (Tuple3d)normal);
                }
                if (!MathTools.intersectStraightPlane((Tuple3d)ray.pos, (Vector3d)ray.dir, (Tuple3d)p, (Vector3d)normal, (Tuple3d)(r = new Vector3d()))) break;
                r.sub((Tuple3d)p);
                translate.y = r.y;
                translate.z = r.z;
                break;
            }
            default: {
                return null;
            }
        }
        translate.sub((Tuple3d)offset);
        return translate;
    }
}

