/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.ir;

import com.strobel.assembler.ir.ExceptionHandler;
import com.strobel.assembler.ir.Frame;
import com.strobel.assembler.ir.FrameType;
import com.strobel.assembler.ir.FrameValue;
import com.strobel.assembler.ir.Instruction;
import com.strobel.assembler.ir.InstructionBlock;
import com.strobel.assembler.ir.InstructionCollection;
import com.strobel.assembler.ir.InstructionVisitor;
import com.strobel.assembler.ir.OpCode;
import com.strobel.assembler.ir.OperandType;
import com.strobel.assembler.ir.StackMapFrame;
import com.strobel.assembler.ir.StackMappingVisitor;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.MethodBody;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.SwitchInfo;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.VariableDefinition;
import com.strobel.assembler.metadata.VariableDefinitionCollection;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.VerifyArgument;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public final class StackMapAnalyzer {
    public static List<StackMapFrame> computeStackMapTable(MethodBody body) {
        boolean hasThis;
        VerifyArgument.notNull((Object)((Object)body), (String)"body");
        InstructionCollection instructions = body.getInstructions();
        List<ExceptionHandler> exceptionHandlers = body.getExceptionHandlers();
        if (instructions.isEmpty()) {
            return Collections.emptyList();
        }
        StackMappingVisitor stackMappingVisitor = new StackMappingVisitor();
        InstructionVisitor executor = stackMappingVisitor.visitBody(body);
        LinkedHashSet<Instruction> agenda = new LinkedHashSet<Instruction>();
        IdentityHashMap<Instruction, Frame> frames = new IdentityHashMap<Instruction, Frame>();
        LinkedHashSet<Instruction> branchTargets = new LinkedHashSet<Instruction>();
        IMetadataResolver resolver = body.getResolver();
        TypeReference throwableType = resolver.lookupType("java/lang/Throwable");
        for (ExceptionHandler handler : exceptionHandlers) {
            Instruction handlerStart = handler.getHandlerBlock().getFirstInstruction();
            branchTargets.add(handlerStart);
            frames.put(handlerStart, new Frame(FrameType.New, FrameValue.EMPTY_VALUES, new FrameValue[]{FrameValue.makeReference(handler.isCatch() ? handler.getCatchType() : throwableType)}));
        }
        ParameterDefinition thisParameter = body.getThisParameter();
        boolean bl = hasThis = thisParameter != null;
        if (hasThis) {
            stackMappingVisitor.set(0, thisParameter.getParameterType());
        }
        for (ParameterDefinition parameter : body.getMethod().getParameters()) {
            stackMappingVisitor.set(parameter.getSlot(), parameter.getParameterType());
        }
        Instruction firstInstruction = (Instruction)instructions.get(0);
        Frame initialFrame = stackMappingVisitor.buildFrame();
        agenda.add(firstInstruction);
        frames.put(firstInstruction, initialFrame);
        while (!agenda.isEmpty()) {
            ExceptionHandler handler;
            boolean changed;
            boolean changed2;
            Instruction nextInstruction;
            Instruction instruction = (Instruction)agenda.iterator().next();
            Frame inputFrame = (Frame)frames.get(instruction);
            assert (inputFrame != null);
            agenda.remove(instruction);
            stackMappingVisitor.visitFrame(inputFrame);
            executor.visit(instruction);
            Frame outputFrame = stackMappingVisitor.buildFrame();
            OpCode opCode = instruction.getOpCode();
            OperandType operandType = opCode.getOperandType();
            if (!opCode.isUnconditionalBranch() && (nextInstruction = instruction.getNext()) != null) {
                StackMapAnalyzer.pruneLocals(stackMappingVisitor, nextInstruction, body.getVariables());
                changed2 = StackMapAnalyzer.updateFrame(nextInstruction, inputFrame, stackMappingVisitor.buildFrame(), stackMappingVisitor.getInitializations(), frames);
                if (changed2) {
                    agenda.add(nextInstruction);
                }
                stackMappingVisitor.visitFrame(outputFrame);
            }
            if (operandType == OperandType.BranchTarget || operandType == OperandType.BranchTargetWide) {
                Instruction branchTarget = (Instruction)instruction.getOperand(0);
                assert (branchTarget != null);
                StackMapAnalyzer.pruneLocals(stackMappingVisitor, branchTarget, body.getVariables());
                changed2 = StackMapAnalyzer.updateFrame(branchTarget, inputFrame, stackMappingVisitor.buildFrame(), stackMappingVisitor.getInitializations(), frames);
                if (changed2) {
                    agenda.add(branchTarget);
                }
                branchTargets.add(branchTarget);
                stackMappingVisitor.visitFrame(outputFrame);
            } else if (operandType == OperandType.Switch) {
                SwitchInfo switchInfo = (SwitchInfo)instruction.getOperand(0);
                Instruction defaultTarget = switchInfo.getDefaultTarget();
                assert (defaultTarget != null);
                StackMapAnalyzer.pruneLocals(stackMappingVisitor, defaultTarget, body.getVariables());
                changed = StackMapAnalyzer.updateFrame(defaultTarget, inputFrame, stackMappingVisitor.buildFrame(), stackMappingVisitor.getInitializations(), frames);
                if (changed) {
                    agenda.add(defaultTarget);
                }
                branchTargets.add(defaultTarget);
                stackMappingVisitor.visitFrame(outputFrame);
                for (Instruction branchTarget : switchInfo.getTargets()) {
                    assert (branchTarget != null);
                    StackMapAnalyzer.pruneLocals(stackMappingVisitor, branchTarget, body.getVariables());
                    changed = StackMapAnalyzer.updateFrame(branchTarget, inputFrame, stackMappingVisitor.buildFrame(), stackMappingVisitor.getInitializations(), frames);
                    if (changed) {
                        agenda.add(branchTarget);
                    }
                    branchTargets.add(branchTarget);
                    stackMappingVisitor.visitFrame(outputFrame);
                }
            }
            if (!opCode.canThrow() || (handler = StackMapAnalyzer.findInnermostExceptionHandler(exceptionHandlers, instruction.getOffset())) == null) continue;
            Instruction handlerStart = handler.getHandlerBlock().getFirstInstruction();
            while (stackMappingVisitor.getStackSize() > 0) {
                stackMappingVisitor.pop();
            }
            if (handler.isCatch()) {
                stackMappingVisitor.push(handler.getCatchType());
            } else {
                stackMappingVisitor.push(throwableType);
            }
            StackMapAnalyzer.pruneLocals(stackMappingVisitor, handlerStart, body.getVariables());
            changed = StackMapAnalyzer.updateFrame(handlerStart, inputFrame, stackMappingVisitor.buildFrame(), stackMappingVisitor.getInitializations(), frames);
            if (!changed) continue;
            agenda.add(handlerStart);
        }
        Object[] framesInStackMap = new StackMapFrame[branchTargets.size()];
        int i = 0;
        for (Instruction branchTarget : branchTargets) {
            framesInStackMap[i++] = new StackMapFrame((Frame)frames.get(branchTarget), branchTarget);
        }
        Arrays.sort(framesInStackMap, new Comparator<StackMapFrame>(){

            @Override
            public int compare(StackMapFrame o1, StackMapFrame o2) {
                return Integer.compare(o1.getStartInstruction().getOffset(), o2.getStartInstruction().getOffset());
            }
        });
        Frame lastFrame = initialFrame;
        for (i = 0; i < framesInStackMap.length; ++i) {
            Object frame = framesInStackMap[i];
            Frame deltaFrame = Frame.computeDelta(lastFrame, ((StackMapFrame)frame).getFrame());
            framesInStackMap[i] = new StackMapFrame(deltaFrame, ((StackMapFrame)frame).getStartInstruction());
            lastFrame = ((StackMapFrame)frame).getFrame();
        }
        return ArrayUtilities.asUnmodifiableList((Object[])framesInStackMap);
    }

    private static boolean pruneLocals(StackMappingVisitor stackMappingVisitor, Instruction target, VariableDefinitionCollection variables) {
        boolean changed = false;
        int n = stackMappingVisitor.getLocalCount();
        for (int i = 0; i < n; ++i) {
            VariableDefinition v = variables.tryFind(i, target.getOffset());
            if (v != null) continue;
            stackMappingVisitor.set(i, FrameValue.OUT_OF_SCOPE);
            changed = true;
        }
        if (changed) {
            stackMappingVisitor.pruneLocals();
            return true;
        }
        return false;
    }

    private static boolean updateFrame(Instruction instruction, Frame inputFrame, Frame outputFrame, Map<Instruction, TypeReference> initializations, Map<Instruction, Frame> frames) {
        Frame oldFrame = frames.get(instruction);
        if (oldFrame != null) {
            assert (oldFrame.getStackValues().size() == outputFrame.getStackValues().size());
            Frame mergedFrame = Frame.merge(inputFrame, outputFrame, oldFrame, initializations);
            frames.put(instruction, mergedFrame);
            return mergedFrame != oldFrame;
        }
        frames.put(instruction, outputFrame);
        return true;
    }

    private static ExceptionHandler findInnermostExceptionHandler(List<ExceptionHandler> exceptionHandlers, int offsetInTryBlock) {
        for (ExceptionHandler handler : exceptionHandlers) {
            InstructionBlock tryBlock = handler.getTryBlock();
            InstructionBlock handlerBlock = handler.getHandlerBlock();
            if (tryBlock.getFirstInstruction().getOffset() > offsetInTryBlock || offsetInTryBlock >= handlerBlock.getFirstInstruction().getOffset()) continue;
            return handler;
        }
        return null;
    }
}

