/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.AutoConvertingBinaryDecoder;
import com.impossibl.postgres.system.procs.AutoConvertingBinaryEncoder;
import com.impossibl.postgres.system.procs.AutoConvertingTextDecoder;
import com.impossibl.postgres.system.procs.AutoConvertingTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.text.ParseException;
import java.util.UUID;

public class UUIDs
extends SimpleProcProvider {
    public UUIDs() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "uuid_");
    }

    static class TxtEncoder
    extends AutoConvertingTextEncoder<UUID> {
        TxtEncoder() {
            super(UUID::fromString);
        }

        @Override
        public Class<UUID> getDefaultClass() {
            return UUID.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, UUID value, Object sourceContext, StringBuilder buffer) throws IOException {
            buffer.append(value);
        }
    }

    static class TxtDecoder
    extends AutoConvertingTextDecoder<UUID> {
        TxtDecoder() {
            super(UUID::toString);
        }

        @Override
        public Class<UUID> getDefaultClass() {
            return UUID.class;
        }

        @Override
        protected UUID decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            return UUID.fromString(buffer.toString());
        }
    }

    static class BinEncoder
    extends AutoConvertingBinaryEncoder<UUID> {
        BinEncoder() {
            super((Integer)16, UUID::fromString);
        }

        @Override
        public Class<UUID> getDefaultClass() {
            return UUID.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, UUID value, Object sourceContext, ByteBuf buffer) throws IOException {
            buffer.writeLong(value.getMostSignificantBits());
            buffer.writeLong(value.getLeastSignificantBits());
        }
    }

    static class BinDecoder
    extends AutoConvertingBinaryDecoder<UUID> {
        BinDecoder() {
            super((Integer)16, UUID::toString);
        }

        @Override
        public Class<UUID> getDefaultClass() {
            return UUID.class;
        }

        @Override
        protected UUID decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class targetClass, Object targetContext) throws IOException {
            return new UUID(buffer.readLong(), buffer.readLong());
        }
    }
}

