/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.FieldFormatRef;
import com.impossibl.postgres.protocol.RequestExecutor;
import com.impossibl.postgres.protocol.ServerConnection;
import com.impossibl.postgres.protocol.ServerObjectType;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.TypeRef;
import com.impossibl.postgres.protocol.v30.CloseRequest;
import com.impossibl.postgres.protocol.v30.CopyInRequest;
import com.impossibl.postgres.protocol.v30.CopyOutRequest;
import com.impossibl.postgres.protocol.v30.ExecutePortalRequest;
import com.impossibl.postgres.protocol.v30.ExecuteQueryRequest;
import com.impossibl.postgres.protocol.v30.ExecuteStatementRequest;
import com.impossibl.postgres.protocol.v30.FunctionCallRequest;
import com.impossibl.postgres.protocol.v30.LazyExecuteRequest;
import com.impossibl.postgres.protocol.v30.MessageDispatchHandler;
import com.impossibl.postgres.protocol.v30.PrepareRequest;
import com.impossibl.postgres.protocol.v30.ProtocolChannel;
import com.impossibl.postgres.protocol.v30.QueryRequest;
import com.impossibl.postgres.protocol.v30.ResumePortalRequest;
import com.impossibl.postgres.protocol.v30.SQLTrace;
import com.impossibl.postgres.protocol.v30.ServerConnectionShared;
import com.impossibl.postgres.protocol.v30.ServerRequest;
import com.impossibl.postgres.protocol.v30.SynchronizeRequest;
import com.impossibl.postgres.system.Configuration;
import com.impossibl.postgres.system.ServerInfo;
import com.impossibl.postgres.system.SystemSettings;
import com.impossibl.postgres.system.Version;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ScheduledExecutorService;

class ServerConnection
implements com.impossibl.postgres.protocol.ServerConnection,
RequestExecutor {
    private Channel channel;
    private ServerInfo serverInfo;
    private Version protocolVersion;
    private ServerConnection.KeyData keyData;
    private ServerConnectionShared.Ref sharedRef;
    private SQLTrace sqlTrace;

    ServerConnection(Configuration config, Channel channel, ServerInfo serverInfo, Version protocolVersion, ServerConnection.KeyData keyData, ServerConnectionShared.Ref sharedRef) {
        this.channel = channel;
        this.serverInfo = serverInfo;
        this.protocolVersion = protocolVersion;
        this.keyData = keyData;
        this.sharedRef = sharedRef;
        if (config.getSetting(SystemSettings.SQL_TRACE).booleanValue()) {
            OutputStream out = System.out;
            String filePath = config.getSetting(SystemSettings.SQL_TRACE_FILE);
            if (filePath != null) {
                try {
                    out = new FileOutputStream(filePath, false);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            this.sqlTrace = new SQLTrace(new OutputStreamWriter(out));
        }
    }

    MessageDispatchHandler getMessageDispatchHandler() {
        return (MessageDispatchHandler)this.channel.pipeline().context(MessageDispatchHandler.class).handler();
    }

    @Override
    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    @Override
    public Version getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public ServerConnection.KeyData getKeyData() {
        return this.keyData;
    }

    @Override
    public ChannelFuture shutdown() {
        if (!this.channel.isActive()) {
            return this.channel.pipeline().newSucceededFuture();
        }
        this.channel.config().setOption(ChannelOption.AUTO_READ, (Object)false);
        try {
            ChannelPromise promise = this.channel.newPromise();
            new ProtocolChannel(this.channel, StandardCharsets.UTF_8).writeTerminate().addListener(terminated -> this.kill().addListener(killed -> {
                if (killed.cause() != null) {
                    promise.setFailure(killed.cause());
                } else {
                    promise.setSuccess();
                }
            }));
            return promise;
        }
        catch (Exception exception) {
            return this.kill();
        }
    }

    @Override
    public ChannelFuture kill() {
        if (this.sharedRef != null) {
            this.sharedRef.release();
            this.sharedRef = null;
        }
        return this.channel.close();
    }

    @Override
    public ByteBufAllocator getAllocator() {
        return this.channel.alloc();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.channel.remoteAddress();
    }

    @Override
    public ScheduledExecutorService getIOExecutor() {
        return this.channel.eventLoop();
    }

    @Override
    public TransactionStatus getTransactionStatus() throws IOException {
        if (!this.channel.isActive()) {
            throw new ClosedChannelException();
        }
        return this.getMessageDispatchHandler().getTransactionStatus();
    }

    @Override
    public boolean isConnected() {
        return this.channel.isActive();
    }

    @Override
    public RequestExecutor getRequestExecutor() {
        return this;
    }

    @Override
    public void sync(RequestExecutor.SynchronizedHandler handler) throws IOException {
        this.submit(new SynchronizeRequest(handler));
    }

    @Override
    public void query(String sql, RequestExecutor.QueryHandler handler) throws IOException {
        if (this.sqlTrace != null) {
            this.sqlTrace.query(sql);
        }
        this.submit(new QueryRequest(sql, handler));
    }

    @Override
    public void query(String sql, String portalName, FieldFormatRef[] parameterFormats, ByteBuf[] parameterBuffers, FieldFormatRef[] resultFieldFormats, int maxRows, RequestExecutor.ExtendedQueryHandler handler) throws IOException {
        if (this.sqlTrace != null) {
            this.sqlTrace.query(sql);
        }
        this.submit(new ExecuteQueryRequest(sql, portalName, parameterFormats, parameterBuffers, resultFieldFormats, maxRows, handler));
    }

    @Override
    public void query(String portalName, int maxRows, RequestExecutor.ExtendedQueryHandler handler) throws IOException {
        if (this.sqlTrace != null) {
            this.sqlTrace.query(portalName);
        }
        this.submit(new ExecutePortalRequest(portalName, maxRows, handler));
    }

    @Override
    public void prepare(String statementName, String sql, TypeRef[] parameterTypes, RequestExecutor.PrepareHandler handler) throws IOException {
        if (this.sqlTrace != null) {
            this.sqlTrace.prepare(statementName, sql);
        }
        this.submit(new PrepareRequest(statementName, sql, parameterTypes, handler));
    }

    @Override
    public void execute(String portalName, String statementName, FieldFormatRef[] parameterFormats, ByteBuf[] parameterBuffers, FieldFormatRef[] resultFieldFormats, int maxRows, RequestExecutor.ExecuteHandler handler) throws IOException {
        if (this.sqlTrace != null) {
            this.sqlTrace.execute(statementName);
        }
        this.submit(new ExecuteStatementRequest(statementName, portalName, parameterFormats, parameterBuffers, resultFieldFormats, maxRows, handler));
    }

    @Override
    public void resume(String portalName, int maxRows, RequestExecutor.ResumeHandler handler) throws IOException {
        this.submit(new ResumePortalRequest(portalName, maxRows, handler));
    }

    @Override
    public void finish(String portalName, RequestExecutor.SynchronizedHandler handler) throws IOException {
        this.submit(new CloseRequest(ServerObjectType.Portal, portalName, handler));
    }

    @Override
    public void lazyExecute(String statementName) throws IOException {
        if (this.sqlTrace != null) {
            this.sqlTrace.query(statementName);
        }
        this.submit(new LazyExecuteRequest(statementName));
    }

    @Override
    public void call(int functionId, FieldFormatRef[] parameterFormats, ByteBuf[] parameterBuffers, RequestExecutor.FunctionCallHandler handler) throws IOException {
        if (this.sqlTrace != null) {
            this.sqlTrace.query("CALL: " + functionId);
        }
        this.submit(new FunctionCallRequest(functionId, parameterFormats, parameterBuffers, handler));
    }

    @Override
    public void copyFrom(String sql, InputStream stream, RequestExecutor.CopyFromHandler handler) throws IOException {
        if (this.sqlTrace != null) {
            this.sqlTrace.query("COPY-IN: " + sql);
        }
        this.submit(new CopyInRequest(sql, stream, handler));
    }

    @Override
    public void copyTo(String sql, OutputStream stream, RequestExecutor.CopyToHandler handler) throws IOException {
        if (this.sqlTrace != null) {
            this.sqlTrace.query("COPY-OUT: " + sql);
        }
        this.submit(new CopyOutRequest(sql, stream, handler));
    }

    @Override
    public void close(ServerObjectType objectType, String objectName) throws IOException {
        this.submit(new CloseRequest(objectType, objectName, null));
    }

    private synchronized void submit(ServerRequest request) throws IOException {
        this.channel.writeAndFlush((Object)request).syncUninterruptibly();
    }
}

