/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.RequestExecutor;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.RowDataSet;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.v30.BufferRowData;
import com.impossibl.postgres.protocol.v30.ProtocolChannel;
import com.impossibl.postgres.protocol.v30.ProtocolHandler;
import com.impossibl.postgres.protocol.v30.ServerRequest;
import com.impossibl.postgres.system.Empty;
import com.impossibl.postgres.system.NoticeException;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class QueryRequest
implements ServerRequest {
    private String query;
    private RequestExecutor.QueryHandler handler;
    private ResultField[] resultFields;
    private RowDataSet rows;
    private List<Notice> notices;

    QueryRequest(String query, RequestExecutor.QueryHandler handler) {
        this.query = query;
        this.handler = handler;
        this.resultFields = Empty.EMPTY_FIELDS;
        this.rows = new RowDataSet();
        this.notices = new ArrayList<Notice>();
    }

    @Override
    public ProtocolHandler createHandler() {
        return new Handler();
    }

    @Override
    public void execute(ProtocolChannel channel) throws IOException {
        channel.writeQuery(this.query).flush();
    }

    static /* synthetic */ ResultField[] access$102(QueryRequest x0, ResultField[] x1) {
        x0.resultFields = x1;
        return x1;
    }

    private class Handler
    implements ProtocolHandler.RowDescription,
    ProtocolHandler.DataRow,
    ProtocolHandler.EmptyQuery,
    ProtocolHandler.CommandComplete,
    ProtocolHandler.CommandError,
    ProtocolHandler.ReportNotice,
    ProtocolHandler.ReadyForQuery {
        private Handler() {
        }

        public String toString() {
            return "Query";
        }

        @Override
        public ProtocolHandler.Action notice(Notice notice) {
            QueryRequest.this.notices.add(notice);
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action rowDescription(ResultField[] fields) {
            QueryRequest.access$102(QueryRequest.this, fields);
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action rowData(ByteBuf data) {
            QueryRequest.this.rows.add(new BufferRowData(data.retain()));
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action emptyQuery() throws IOException {
            return this.commandComplete("", null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ProtocolHandler.Action commandComplete(String command, Long rowsAffected, Long insertedOid) throws IOException {
            try {
                QueryRequest.this.handler.handleComplete(command, rowsAffected, insertedOid, Empty.EMPTY_TYPES, QueryRequest.this.resultFields, QueryRequest.this.rows, QueryRequest.this.notices);
            }
            finally {
                ReferenceCountUtil.release((Object)((Object)QueryRequest.this.rows));
                QueryRequest.this.rows = new RowDataSet();
                QueryRequest.access$102(QueryRequest.this, Empty.EMPTY_FIELDS);
            }
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action error(Notice error) throws IOException {
            try {
                QueryRequest.this.handler.handleError(new NoticeException(error), QueryRequest.this.notices);
            }
            finally {
                ReferenceCountUtil.release((Object)((Object)QueryRequest.this.rows));
                QueryRequest.this.rows = new RowDataSet();
                QueryRequest.access$102(QueryRequest.this, Empty.EMPTY_FIELDS);
            }
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public void exception(Throwable cause) throws IOException {
            try {
                QueryRequest.this.handler.handleError(cause, QueryRequest.this.notices);
            }
            finally {
                ReferenceCountUtil.release((Object)((Object)QueryRequest.this.rows));
                QueryRequest.this.rows = new RowDataSet();
            }
        }

        @Override
        public ProtocolHandler.Action readyForQuery(TransactionStatus txnStatus) throws IOException {
            QueryRequest.this.handler.handleReady(txnStatus);
            return ProtocolHandler.Action.Complete;
        }
    }
}

