/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.PGSavepoint;
import com.impossibl.postgres.jdbc.SQLText;
import com.impossibl.postgres.jdbc.SQLTextTree;
import com.impossibl.postgres.system.Identifier;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

class SQLTextUtils {
    SQLTextUtils() {
    }

    public static boolean isTrue(String value) {
        return "on".equals(value);
    }

    public static boolean isFalse(String value) {
        return "off".equals(value);
    }

    public static String getIsolationLevelText(int level) {
        switch (level) {
            case 1: {
                return "READ UNCOMMITTED";
            }
            case 2: {
                return "READ COMMITTED";
            }
            case 4: {
                return "REPEATABLE READ";
            }
            case 8: {
                return "SERIALIZABLE";
            }
        }
        throw new RuntimeException("unknown isolation level");
    }

    public static int getIsolationLevel(String level) {
        switch (level.toUpperCase()) {
            case "READ UNCOMMITTED": {
                return 1;
            }
            case "READ COMMITTED": {
                return 2;
            }
            case "REPEATABLE READ": {
                return 4;
            }
            case "SERIALIZABLE": {
                return 8;
            }
        }
        throw new RuntimeException("unknown isolation level");
    }

    public static String getGetSessionReadabilityText() {
        return "SHOW default_transaction_read_only";
    }

    public static String getSetSessionReadabilityText(boolean readOnly) {
        return "SET SESSION CHARACTERISTICS AS TRANSACTION " + (readOnly ? "READ ONLY" : "READ WRITE");
    }

    public static String getGetSessionIsolationLevelText() {
        return "SHOW default_transaction_isolation";
    }

    public static String getSetSessionIsolationLevelText(int level) {
        return "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL " + SQLTextUtils.getIsolationLevelText(level);
    }

    public static String getBeginText() {
        return "BEGIN";
    }

    public static String getCommitText() {
        return "COMMIT";
    }

    public static String getRollbackText() {
        return "ROLLBACK";
    }

    public static String getRollbackToText(PGSavepoint savepoint) {
        return "ROLLBACK TO SAVEPOINT " + savepoint.getId();
    }

    public static String getSetSavepointText(PGSavepoint savepoint) {
        return "SAVEPOINT " + savepoint.getId();
    }

    public static String getReleaseSavepointText(PGSavepoint savepoint) {
        return "RELEASE SAVEPOINT " + savepoint.getId();
    }

    public static boolean prependClause(SQLText sqlText, String clause) {
        if (sqlText.getStatementCount() > 1) {
            return false;
        }
        SQLTextTree.StatementNode statement = sqlText.getLastStatement();
        statement.nodes.add(0, new SQLTextTree.GrammarPiece(clause, -1));
        return true;
    }

    public static boolean prependCursorDeclaration(SQLText sqlText, String cursorName, int resultSetType, int resultSetHoldability, boolean autoCommit) {
        if (sqlText.getStatementCount() > 1) {
            return false;
        }
        if (!sqlText.getFirstStatement().getFirstNode().toString().equalsIgnoreCase("SELECT")) {
            return false;
        }
        String preCursor = "DECLARE " + cursorName + " BINARY ";
        preCursor = resultSetType != 1003 ? preCursor + "SCROLL " : preCursor + "NO SCROLL ";
        preCursor = preCursor + "CURSOR ";
        if (resultSetHoldability == 1 || autoCommit) {
            preCursor = preCursor + "WITH HOLD ";
        }
        preCursor = preCursor + "FOR ";
        return SQLTextUtils.prependClause(sqlText, preCursor);
    }

    public static boolean appendClause(SQLText sqlText, String clause) {
        if (sqlText.getStatementCount() > 1) {
            return false;
        }
        SQLTextTree.StatementNode statement = sqlText.getLastStatement();
        statement.add(new SQLTextTree.GrammarPiece(clause, -1));
        return true;
    }

    public static boolean hasReturningClause(SQLTextTree.StatementNode statement) {
        for (SQLTextTree.Node node : statement.nodes) {
            if (!(node instanceof SQLTextTree.UnquotedIdentifierPiece) || !((SQLTextTree.UnquotedIdentifierPiece)node).getText().equals("RETURNING")) continue;
            return true;
        }
        return false;
    }

    public static boolean appendReturningClause(SQLText sqlText, List<String> columns) {
        if (SQLTextUtils.hasReturningClause(sqlText.getLastStatement())) {
            return true;
        }
        return SQLTextUtils.appendClause(sqlText, " RETURNING " + SQLTextUtils.joinColumns(columns, " , "));
    }

    public static boolean appendReturningClause(SQLText sqlText) {
        if (SQLTextUtils.hasReturningClause(sqlText.getLastStatement())) {
            return true;
        }
        return SQLTextUtils.appendClause(sqlText, " RETURNING *");
    }

    public static String joinColumns(List<String> columns, String separator) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> columnIter = columns.iterator();
        while (columnIter.hasNext()) {
            sb.append(Identifier.quoteIfNeeded(columnIter.next()));
            if (!columnIter.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String escapeLiteral(String value, boolean standardConformingStrings) {
        StringBuilder builder = new StringBuilder(value.length() * 2);
        try {
            SQLTextUtils.escapeLiteral(value, standardConformingStrings, builder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return builder.toString();
    }

    private static void escapeLiteral(String value, boolean standardConformingStrings, Appendable out) throws IOException {
        if (standardConformingStrings) {
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (ch == '\'') {
                    out.append('\'');
                }
                out.append(ch);
            }
        } else {
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (ch == '\\' || ch == '\'') {
                    out.append(ch);
                }
                out.append(ch);
            }
        }
    }
}

