/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.DirectQuery;
import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.Housekeeper;
import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.jdbc.PGResultSet;
import com.impossibl.postgres.jdbc.PGSQLSimpleException;
import com.impossibl.postgres.jdbc.Query;
import com.impossibl.postgres.protocol.FieldFormat;
import com.impossibl.postgres.protocol.FieldFormatRef;
import com.impossibl.postgres.protocol.ResultBatch;
import com.impossibl.postgres.protocol.ResultBatches;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.RowDataSet;
import com.impossibl.postgres.protocol.ServerObjectType;
import com.impossibl.postgres.system.Empty;
import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public abstract class PGStatement
implements Statement {
    static final String CACHED_STATEMENT_PREFIX = "cached-";
    static final String NO_CACHE_STATEMENT_PREFIX = "nocache-";
    PGDirectConnection connection;
    String cursorName;
    int resultSetType;
    int resultSetConcurrency;
    int resultSetHoldability;
    int fetchDirection;
    String name;
    boolean processEscapes;
    ResultField[] resultFields;
    Integer maxRows;
    Integer fetchSize;
    Integer maxFieldSize;
    Query query;
    List<ResultBatch> resultBatches;
    boolean autoClose;
    Collection<WeakReference<PGResultSet>> activeResultSets;
    PGResultSet generatedKeysResultSet;
    SQLWarning warningChain;
    int queryTimeout;
    final Housekeeper.Ref housekeeper;
    final Object cleanupKey;

    PGStatement(PGDirectConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String name, ResultField[] resultFields) {
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.fetchDirection = 1000;
        this.name = name;
        this.processEscapes = true;
        this.resultFields = resultFields;
        this.activeResultSets = new ConcurrentLinkedQueue<WeakReference<PGResultSet>>();
        this.generatedKeysResultSet = null;
        this.fetchSize = connection.getDefaultFetchSize();
        this.housekeeper = connection.housekeeper;
        this.cleanupKey = this.housekeeper != null ? this.housekeeper.add(this, new Cleanup(connection, name, this.activeResultSets)) : null;
    }

    void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw Exceptions.CLOSED_STATEMENT;
        }
    }

    static void dispose(PGDirectConnection connection, String statementName) throws SQLException {
        if (statementName == null) {
            return;
        }
        connection.execute((long timeout) -> connection.getRequestExecutor().close(ServerObjectType.Statement, statementName));
    }

    static void closeCursor(PGDirectConnection connection, String cursorName) throws SQLException {
        if (cursorName == null) {
            return;
        }
        connection.execute((long timeout) -> connection.query("CLOSE " + cursorName, timeout));
    }

    private static void closeResultSets(Collection<WeakReference<PGResultSet>> resultSets) {
        for (WeakReference<PGResultSet> resultSetRef : resultSets) {
            PGResultSet resultSet = (PGResultSet)resultSetRef.get();
            if (resultSet == null) continue;
            try {
                resultSet.internalClose();
            }
            catch (SQLException sQLException) {}
        }
        resultSets.clear();
    }

    void closeResultSets() {
        Collection<WeakReference<PGResultSet>> activeResultSets = this.activeResultSets;
        this.activeResultSets = new ArrayList<WeakReference<PGResultSet>>();
        PGStatement.closeResultSets(activeResultSets);
        this.generatedKeysResultSet = null;
    }

    void handleResultSetClosure(PGResultSet resultSet) throws SQLException {
        Iterator<WeakReference<PGResultSet>> resultSetRefIter = this.activeResultSets.iterator();
        while (resultSetRefIter.hasNext()) {
            WeakReference<PGResultSet> resultSetRef = resultSetRefIter.next();
            PGResultSet rs = (PGResultSet)resultSetRef.get();
            if (rs == null) {
                resultSetRefIter.remove();
                continue;
            }
            if (rs != resultSet) continue;
            resultSetRefIter.remove();
            break;
        }
        if (this.autoClose && this.activeResultSets.isEmpty()) {
            this.close();
        }
    }

    void internalClose() throws SQLException {
        this.closeResultSets();
        this.resultBatches = ResultBatches.releaseAll(this.resultBatches);
        if (this.name != null && !this.name.startsWith(CACHED_STATEMENT_PREFIX)) {
            PGStatement.dispose(this.connection, this.name);
        }
        if (this.housekeeper != null) {
            this.housekeeper.remove(this.cleanupKey);
        }
        this.connection = null;
        this.query = null;
        this.resultFields = null;
        this.generatedKeysResultSet = null;
    }

    private boolean hasResults() {
        return !this.resultBatches.isEmpty() && this.resultBatches.get(0).hasRows();
    }

    private boolean hasUpdateCount() {
        return !this.resultBatches.isEmpty() && this.resultBatches.get(0).hasRowsAffected();
    }

    private boolean shouldUseFetchSize() {
        return this.fetchSize != null && this.cursorName == null;
    }

    boolean executeDirect(String sqlText) throws SQLException {
        return this.executeDirect(sqlText, null, null, null);
    }

    boolean executeDirect(String sqlText, FieldFormat[] parameterFormats, ByteBuf[] parameterBuffers, FieldFormatRef[] resultFieldFormats) throws SQLException {
        try {
            this.closeResultSets();
            this.resultBatches = ResultBatches.releaseAll(this.resultBatches);
            DirectQuery query = new DirectQuery(sqlText, parameterFormats, parameterBuffers, resultFieldFormats);
            query.setTimeout(TimeUnit.SECONDS.toMillis(this.queryTimeout));
            if (this.shouldUseFetchSize()) {
                query.setMaxRows(this.fetchSize);
            }
            this.warningChain = query.execute(this.connection);
            this.query = query;
            this.resultBatches = query.getResultBatches();
            return this.hasResults();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SQLException(e);
        }
    }

    boolean executeStatement(String statementName, FieldFormat[] parameterFormats, ByteBuf[] parameterValues) throws SQLException {
        try {
            this.closeResultSets();
            this.resultBatches = ResultBatches.releaseAll(this.resultBatches);
            Query query = Query.create(statementName, parameterFormats, parameterValues, this.resultFields);
            query.setTimeout(TimeUnit.SECONDS.toMillis(this.queryTimeout));
            if (this.shouldUseFetchSize()) {
                query.setMaxRows(this.fetchSize);
            }
            this.warningChain = query.execute(this.connection);
            this.query = query;
            this.resultBatches = query.getResultBatches();
            return this.hasResults();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SQLException(e);
        }
    }

    public PGResultSet createResultSet(ResultField[] resultFields, RowDataSet results, boolean releaseResults, Map<String, Class<?>> typeMap) throws SQLException {
        PGResultSet resultSet = new PGResultSet(this, resultFields, results, releaseResults, typeMap);
        this.activeResultSets.add(new WeakReference<PGResultSet>(resultSet));
        return resultSet;
    }

    private PGResultSet createResultSet(Query query, ResultField[] resultFields, RowDataSet results) throws SQLException {
        PGResultSet resultSet = new PGResultSet(this, query, resultFields, results);
        this.activeResultSets.add(new WeakReference<PGResultSet>(resultSet));
        return resultSet;
    }

    private PGResultSet createResultSet(String cursorName, int resultSetType, int resultSetHoldability, ResultField[] resultFields) throws SQLException {
        PGResultSet resultSet = new PGResultSet(this, cursorName, resultSetType, resultSetHoldability, resultFields);
        this.activeResultSets.add(new WeakReference<PGResultSet>(resultSet));
        return resultSet;
    }

    @Override
    public PGDirectConnection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkClosed();
        return this.resultSetType;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkClosed();
        return this.resultSetHoldability;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkClosed();
        return this.autoClose;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkClosed();
        this.autoClose = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return this.maxFieldSize != null ? this.maxFieldSize : 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw Exceptions.ILLEGAL_ARGUMENT;
        }
        this.maxFieldSize = max == 0 ? null : Integer.valueOf(max);
        for (WeakReference<PGResultSet> resultSetRef : this.activeResultSets) {
            PGResultSet resultSet = (PGResultSet)resultSetRef.get();
            if (resultSet == null) continue;
            resultSet.updateMaxFieldSize(this.maxFieldSize);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows != null ? this.maxRows : 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw Exceptions.ILLEGAL_ARGUMENT;
        }
        this.maxRows = max;
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return this.getMaxRows();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        if (max > Integer.MAX_VALUE) {
            throw new PGSQLSimpleException("Maximum rows too large");
        }
        this.setMaxRows((int)max);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchDirection;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw Exceptions.ILLEGAL_ARGUMENT;
        }
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize != null ? this.fetchSize : 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw Exceptions.ILLEGAL_ARGUMENT;
        }
        this.fetchSize = rows;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
        this.processEscapes = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int queryTimeout) throws SQLException {
        this.checkClosed();
        if (queryTimeout < 0) {
            throw new SQLException("invalid query timeout");
        }
        this.queryTimeout = queryTimeout;
    }

    private String getCursorName() {
        if (this.cursorName == null) {
            return "cursor" + super.hashCode();
        }
        return this.cursorName;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
        this.cursorName = name;
    }

    @Override
    public PGResultSet getResultSet() throws SQLException {
        this.checkClosed();
        if (this.generatedKeysResultSet != null || this.query == null || !this.hasResults()) {
            return null;
        }
        if (this.cursorName != null) {
            ResultBatch resultBatch = this.resultBatches.remove(0);
            resultBatch.release();
            return this.createResultSet(this.getCursorName(), this.resultSetType, this.resultSetHoldability, resultBatch.getFields());
        }
        if (this.query.getStatus() == Query.Status.Completed) {
            ResultBatch resultBatch = this.resultBatches.get(0);
            return this.createResultSet(resultBatch.getFields(), resultBatch.borrowRows(), false, this.connection.getTypeMap());
        }
        try (ResultBatch resultBatch = this.resultBatches.remove(0);){
            PGResultSet rs = this.createResultSet(this.query, resultBatch.getFields(), resultBatch.takeRows());
            this.query = null;
            PGResultSet pGResultSet = rs;
            return pGResultSet;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        long count = this.getLargeUpdateCount();
        return (int)Long.min(count, Integer.MAX_VALUE);
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkClosed();
        if (this.query == null || !this.hasUpdateCount()) {
            return -1L;
        }
        return this.resultBatches.get(0).getRowsAffected();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(3);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkClosed();
        if (this.resultBatches.isEmpty()) {
            return false;
        }
        ResultBatch finishedBatch = this.resultBatches.remove(0);
        finishedBatch.release();
        return this.hasResults();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkClosed();
        if (this.generatedKeysResultSet == null) {
            return this.createResultSet(Empty.EMPTY_FIELDS, new RowDataSet(), false, this.connection.getTypeMap());
        }
        return this.generatedKeysResultSet;
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public boolean isClosed() {
        return this.connection == null;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.connection.handleStatementClosure(this);
        this.internalClose();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warningChain;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warningChain = null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isAssignableFrom(this.getClass())) {
            throw Exceptions.UNWRAP_ERROR;
        }
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    private static class Cleanup
    implements Housekeeper.CleanupRunnable {
        PGDirectConnection connection;
        String name;
        Collection<WeakReference<PGResultSet>> resultSets;
        StackTraceElement[] allocationStackTrace;

        private Cleanup(PGDirectConnection connection, String name, Collection<WeakReference<PGResultSet>> resultSets) {
            this.connection = connection;
            this.name = name;
            this.resultSets = resultSets;
            this.allocationStackTrace = new Exception().getStackTrace();
        }

        @Override
        public String getKind() {
            return "statement";
        }

        @Override
        public StackTraceElement[] getAllocationStackTrace() {
            return this.allocationStackTrace;
        }

        @Override
        public void run() {
            PGStatement.closeResultSets(this.resultSets);
            try {
                PGStatement.dispose(this.connection, this.name);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection.handleStatementClosure(null);
            this.connection = null;
        }
    }
}

