/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.DataSourceSettingsInit;
import com.impossibl.postgres.system.Setting;
import com.impossibl.postgres.system.SystemSettings;

@Setting.Factory
public class DataSourceSettings {
    @Setting.Group.Info(id="jdbc-ds", desc="JDBC DataSource Settings", order=2)
    public static final Setting.Group DS = Setting.Group.declare();
    @Setting.Info(desc="Name of data source.", name="data-source.name", group="jdbc-ds", alternateNames={"dataSourceName"})
    public static final Setting<String> DATASOURCE_NAME = Setting.declare();
    public static final Setting<String> DATABASE_NAME = DS.add(SystemSettings.DATABASE_NAME);
    @Setting.Info(desc="Host name for TCP connections.", def="localhost", name="server.name", group="jdbc-ds", alternateNames={"serverName"})
    public static final Setting<String> SERVER_NAME = Setting.declare();
    @Setting.Info(desc="Port number for TCP connections.", def="5432", min=1, max=65535, name="port.number", group="jdbc-ds", alternateNames={"portNumber"})
    public static final Setting<Integer> PORT_NUMBER = Setting.declare();
    @Setting.Info(desc="Unix socket name for local server connections.", name="server.local-name", group="jdbc-ds", alternateNames={"localServerName"})
    public static final Setting<String> LOCAL_SERVER_NAME = Setting.declare();
    @Setting.Info(desc="Comma separated list of server addresses for which a connection will be attempted in order.\n\nSupports providing DNS, IPv4, IPv6 & Unix socket addresses. DNS & IP addresses are specified in `host[:port]?` format while Unix socket addresses must contain a `/` to valid. Additionally IPv6 host names must be enclosed in `[]`.\n\nNOTE: Specifying a list of addresses takes precedence over `server.name`, `port.number` & `server.local-name' and will cause those settings to be ignored.", name="server.addresses", group="jdbc-ds", alternateNames={"serverAddresses"})
    public static final Setting<String> SERVER_ADDRESSES = Setting.declare();
    @Setting.Info(desc="Maximum time to wait for a connection to be established.", def="0", min=0, name="login.timeout", group="jdbc-ds", alternateNames={"loginTimeout"})
    public static final Setting<Integer> LOGIN_TIMEOUT = Setting.declare();

    static {
        DataSourceSettingsInit.init();
    }
}

