/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.threads.ua;


/**
 *
 * 
 * @author Toni Kalajainen (toni.kalajainen@vtt.fi)
 */
public abstract class AbstractWorkMonitor extends AbstractState<WorkState, RuntimeException> implements WorkMonitor {

	Runnable run;

	public AbstractWorkMonitor(Runnable r) {
		super(WorkState.Ready);
		this.run = r;
	}
	
	// Raise visibility
	@Override
	public void setError(RuntimeException error) 
	{
		super.setError(error);
	}
	
	@Override
	public Runnable getRunnable() {
		return run;
	}

}
