package org.simantics.spreadsheet.resource;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class SpreadsheetResource {
    
    public final Resource Attribute;
    public final Resource Book;
    public final Resource Book_HasDefaultInitialCondition;
    public final Resource BrowseContext;
    public final Resource Cell;
    public final Resource Cell_HasStyle;
    public final Resource Cell_StyleOf;
    public final Resource Cell_align;
    public final Resource Cell_align_Inverse;
    public final Resource Cell_background;
    public final Resource Cell_background_Inverse;
    public final Resource Cell_border;
    public final Resource Cell_border_Inverse;
    public final Resource Cell_columnSpan;
    public final Resource Cell_columnSpan_Inverse;
    public final Resource Cell_content;
    public final Resource Cell_content_Inverse;
    public final Resource Cell_editable;
    public final Resource Cell_editable_Inverse;
    public final Resource Cell_font;
    public final Resource Cell_font_Inverse;
    public final Resource Cell_foreground;
    public final Resource Cell_foreground_Inverse;
    public final Resource Cell_formatIndex;
    public final Resource Cell_formatIndex_Inverse;
    public final Resource Cell_formatString;
    public final Resource Cell_formatString_Inverse;
    public final Resource Cell_label;
    public final Resource Cell_label_Inverse;
    public final Resource Cell_locked;
    public final Resource Cell_locked_Inverse;
    public final Resource Cell_rowSpan;
    public final Resource Cell_rowSpan_Inverse;
    public final Resource Cell_style;
    public final Resource Cell_style_Inverse;
    public final Resource CompositeTemplate;
    public final Resource Dimensions;
    public final Resource Dimensions_columnCount;
    public final Resource Dimensions_columnCount_Inverse;
    public final Resource Dimensions_fitColumns;
    public final Resource Dimensions_fitColumns_Inverse;
    public final Resource Dimensions_fitRows;
    public final Resource Dimensions_fitRows_Inverse;
    public final Resource Dimensions_rowCount;
    public final Resource Dimensions_rowCount_Inverse;
    public final Resource DoubleArrayCell;
    public final Resource DoubleArrayCell_HasDoubleArray;
    public final Resource DoubleArrayCell_HasDoubleArray_Inverse;
    public final Resource DoubleArrayCell_HasWidth;
    public final Resource DoubleArrayCell_HasWidth_Inverse;
    public final Resource DoubleArrayRange;
    public final Resource DoubleArrayRange_array;
    public final Resource DoubleArrayRange_array_Inverse;
    public final Resource Element;
    public final Resource Element_immutable;
    public final Resource Element_immutable_Inverse;
    public final Resource ExcelCell;
    public final Resource Experiment;
    public final Resource ExpressionRange;
    public final Resource ExpressionRange_cells;
    public final Resource ExpressionRange_cells_Inverse;
    public final Resource ForCompositeTemplate;
    public final Resource ForCompositeTemplate_Inverse;
    public final Resource Functions;
    public final Resource Functions_cellLabel;
    public final Resource Functions_contentDisplayValueAccessor;
    public final Resource Functions_contentValueAccessor;
    public final Resource Functions_defaultLineCells;
    public final Resource Functions_defaultSheetCellEditor;
    public final Resource Functions_doubleArrayChildren;
    public final Resource Functions_lineNodeKeys;
    public final Resource Functions_queryRangeChildren;
    public final Resource Functions_sclValue;
    public final Resource Functions_sheetRunDomainChildren;
    public final Resource Functions_spreadsheetChildren;
    public final Resource Functions_spreadsheetInput;
    public final Resource Functions_spreadsheetLinesChildren;
    public final Resource Functions_spreadsheetRunInput;
    public final Resource Functions_spreadsheetSession;
    public final Resource Functions_spreadsheetVariableCellEditor;
    public final Resource Functions_stringArrayChildren;
    public final Resource Functions_textCellEditor;
    public final Resource Functions_variableCellEditor;
    public final Resource HasInitialCondition;
    public final Resource HasInitialCondition_Inverse;
    public final Resource HasLocation;
    public final Resource HasLocation_Inverse;
    public final Resource HasMicrosoftExcelDocumentData;
    public final Resource HasMicrosoftExcelDocumentData_Inverse;
    public final Resource HasRVI;
    public final Resource HasRVI_Inverse;
    public final Resource HasSheet;
    public final Resource Headers;
    public final Resource Headers_columnLabels;
    public final Resource Headers_columnLabels_Inverse;
    public final Resource Headers_columnWidths;
    public final Resource Headers_columnWidths_Inverse;
    public final Resource Headers_rowHeights;
    public final Resource Headers_rowHeights_Inverse;
    public final Resource Headers_rowLabels;
    public final Resource Headers_rowLabels_Inverse;
    public final Resource InitialCondition;
    public final Resource InitialCondition_ConditionOf;
    public final Resource InitialCondition_ConditionOf_Inverse;
    public final Resource InitialCondition_DefaultConditionOf;
    public final Resource InitialCondition_bytes;
    public final Resource InitialCondition_bytes_Inverse;
    public final Resource IsSheetOf;
    public final Resource Line;
    public final Resource LineContent;
    public final Resource LineNode;
    public final Resource LineNode_keys;
    public final Resource LineNode_keys_Inverse;
    public final Resource Line_content;
    public final Resource Line_content_Inverse;
    public final Resource Lines;
    public final Resource MicrosoftExcelDocument;
    public final Resource MicrosoftExcelDocumentData;
    public final Resource ModelSourceContribution;
    public final Resource Range;
    public final Resource Range_heightBound;
    public final Resource Range_heightBound_Inverse;
    public final Resource Range_location;
    public final Resource Range_location_Inverse;
    public final Resource Range_widthBound;
    public final Resource Range_widthBound_Inverse;
    public final Resource Run;
    public final Resource SCLCell;
    public final Resource SCLCell_Expression;
    public final Resource SCLCell_Expression_Inverse;
    public final Resource SCLMain;
    public final Resource SCLValue;
    public final Resource SheetSourceContribution;
    public final Resource SourceContribution;
    public final Resource SourceContribution_function;
    public final Resource SourceContribution_function_Inverse;
    public final Resource SourceContribution_labeler;
    public final Resource SourceContribution_labeler_Inverse;
    public final Resource Spreadsheet;
    public final Resource SpreadsheetElement;
    public final Resource StringArrayCell;
    public final Resource StringArrayCell_HasStringArray;
    public final Resource StringArrayCell_HasStringArray_Inverse;
    public final Resource StringArrayCell_HasWidth;
    public final Resource StringArrayCell_HasWidth_Inverse;
    public final Resource StringArrayRange;
    public final Resource StringArrayRange_array;
    public final Resource StringArrayRange_array_Inverse;
    public final Resource Style;
    public final Resource Style_id;
    public final Resource Style_id_Inverse;
    public final Resource TextCell;
    public final Resource cellEditor;
    public final Resource cellEditor_Inverse;
    public final Resource scl;
    public final Resource sclValue;
    public final Resource session;
    public final Resource session_Inverse;
        
    public static class URIs {
        public static final String Attribute = "http://www.simantics.org/Spreadsheet-1.2/Attribute";
        public static final String Book = "http://www.simantics.org/Spreadsheet-1.2/Book";
        public static final String Book_HasDefaultInitialCondition = "http://www.simantics.org/Spreadsheet-1.2/Book/HasDefaultInitialCondition";
        public static final String BrowseContext = "http://www.simantics.org/Spreadsheet-1.2/BrowseContext";
        public static final String Cell = "http://www.simantics.org/Spreadsheet-1.2/Cell";
        public static final String Cell_HasStyle = "http://www.simantics.org/Spreadsheet-1.2/Cell/HasStyle";
        public static final String Cell_StyleOf = "http://www.simantics.org/Spreadsheet-1.2/Cell/StyleOf";
        public static final String Cell_align = "http://www.simantics.org/Spreadsheet-1.2/Cell/align";
        public static final String Cell_align_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Cell/align/Inverse";
        public static final String Cell_background = "http://www.simantics.org/Spreadsheet-1.2/Cell/background";
        public static final String Cell_background_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Cell/background/Inverse";
        public static final String Cell_border = "http://www.simantics.org/Spreadsheet-1.2/Cell/border";
        public static final String Cell_border_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Cell/border/Inverse";
        public static final String Cell_columnSpan = "http://www.simantics.org/Spreadsheet-1.2/Cell/columnSpan";
        public static final String Cell_columnSpan_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Cell/columnSpan/Inverse";
        public static final String Cell_content = "http://www.simantics.org/Spreadsheet-1.2/Cell/content";
        public static final String Cell_content_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Cell/content/Inverse";
        public static final String Cell_editable = "http://www.simantics.org/Spreadsheet-1.2/Cell/editable";
        public static final String Cell_editable_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Cell/editable/Inverse";
        public static final String Cell_font = "http://www.simantics.org/Spreadsheet-1.2/Cell/font";
        public static final String Cell_font_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Cell/font/Inverse";
        public static final String Cell_foreground = "http://www.simantics.org/Spreadsheet-1.2/Cell/foreground";
        public static final String Cell_foreground_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Cell/foreground/Inverse";
        public static final String Cell_formatIndex = "http://www.simantics.org/Spreadsheet-1.2/Cell/formatIndex";
        public static final String Cell_formatIndex_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Cell/formatIndex/Inverse";
        public static final String Cell_formatString = "http://www.simantics.org/Spreadsheet-1.2/Cell/formatString";
        public static final String Cell_formatString_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Cell/formatString/Inverse";
        public static final String Cell_label = "http://www.simantics.org/Spreadsheet-1.2/Cell/label";
        public static final String Cell_label_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Cell/label/Inverse";
        public static final String Cell_locked = "http://www.simantics.org/Spreadsheet-1.2/Cell/locked";
        public static final String Cell_locked_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Cell/locked/Inverse";
        public static final String Cell_rowSpan = "http://www.simantics.org/Spreadsheet-1.2/Cell/rowSpan";
        public static final String Cell_rowSpan_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Cell/rowSpan/Inverse";
        public static final String Cell_style = "http://www.simantics.org/Spreadsheet-1.2/Cell/style";
        public static final String Cell_style_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Cell/style/Inverse";
        public static final String CompositeTemplate = "http://www.simantics.org/Spreadsheet-1.2/CompositeTemplate";
        public static final String Dimensions = "http://www.simantics.org/Spreadsheet-1.2/Dimensions";
        public static final String Dimensions_columnCount = "http://www.simantics.org/Spreadsheet-1.2/Dimensions/columnCount";
        public static final String Dimensions_columnCount_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Dimensions/columnCount/Inverse";
        public static final String Dimensions_fitColumns = "http://www.simantics.org/Spreadsheet-1.2/Dimensions/fitColumns";
        public static final String Dimensions_fitColumns_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Dimensions/fitColumns/Inverse";
        public static final String Dimensions_fitRows = "http://www.simantics.org/Spreadsheet-1.2/Dimensions/fitRows";
        public static final String Dimensions_fitRows_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Dimensions/fitRows/Inverse";
        public static final String Dimensions_rowCount = "http://www.simantics.org/Spreadsheet-1.2/Dimensions/rowCount";
        public static final String Dimensions_rowCount_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Dimensions/rowCount/Inverse";
        public static final String DoubleArrayCell = "http://www.simantics.org/Spreadsheet-1.2/DoubleArrayCell";
        public static final String DoubleArrayCell_HasDoubleArray = "http://www.simantics.org/Spreadsheet-1.2/DoubleArrayCell/HasDoubleArray";
        public static final String DoubleArrayCell_HasDoubleArray_Inverse = "http://www.simantics.org/Spreadsheet-1.2/DoubleArrayCell/HasDoubleArray/Inverse";
        public static final String DoubleArrayCell_HasWidth = "http://www.simantics.org/Spreadsheet-1.2/DoubleArrayCell/HasWidth";
        public static final String DoubleArrayCell_HasWidth_Inverse = "http://www.simantics.org/Spreadsheet-1.2/DoubleArrayCell/HasWidth/Inverse";
        public static final String DoubleArrayRange = "http://www.simantics.org/Spreadsheet-1.2/DoubleArrayRange";
        public static final String DoubleArrayRange_array = "http://www.simantics.org/Spreadsheet-1.2/DoubleArrayRange/array";
        public static final String DoubleArrayRange_array_Inverse = "http://www.simantics.org/Spreadsheet-1.2/DoubleArrayRange/array/Inverse";
        public static final String Element = "http://www.simantics.org/Spreadsheet-1.2/Element";
        public static final String Element_immutable = "http://www.simantics.org/Spreadsheet-1.2/Element/immutable";
        public static final String Element_immutable_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Element/immutable/Inverse";
        public static final String ExcelCell = "http://www.simantics.org/Spreadsheet-1.2/ExcelCell";
        public static final String Experiment = "http://www.simantics.org/Spreadsheet-1.2/Experiment";
        public static final String ExpressionRange = "http://www.simantics.org/Spreadsheet-1.2/ExpressionRange";
        public static final String ExpressionRange_cells = "http://www.simantics.org/Spreadsheet-1.2/ExpressionRange/cells";
        public static final String ExpressionRange_cells_Inverse = "http://www.simantics.org/Spreadsheet-1.2/ExpressionRange/cells/Inverse";
        public static final String ForCompositeTemplate = "http://www.simantics.org/Spreadsheet-1.2/ForCompositeTemplate";
        public static final String ForCompositeTemplate_Inverse = "http://www.simantics.org/Spreadsheet-1.2/ForCompositeTemplate/Inverse";
        public static final String Functions = "http://www.simantics.org/Spreadsheet-1.2/Functions";
        public static final String Functions_cellLabel = "http://www.simantics.org/Spreadsheet-1.2/Functions/cellLabel";
        public static final String Functions_contentDisplayValueAccessor = "http://www.simantics.org/Spreadsheet-1.2/Functions/contentDisplayValueAccessor";
        public static final String Functions_contentValueAccessor = "http://www.simantics.org/Spreadsheet-1.2/Functions/contentValueAccessor";
        public static final String Functions_defaultLineCells = "http://www.simantics.org/Spreadsheet-1.2/Functions/defaultLineCells";
        public static final String Functions_defaultSheetCellEditor = "http://www.simantics.org/Spreadsheet-1.2/Functions/defaultSheetCellEditor";
        public static final String Functions_doubleArrayChildren = "http://www.simantics.org/Spreadsheet-1.2/Functions/doubleArrayChildren";
        public static final String Functions_lineNodeKeys = "http://www.simantics.org/Spreadsheet-1.2/Functions/lineNodeKeys";
        public static final String Functions_queryRangeChildren = "http://www.simantics.org/Spreadsheet-1.2/Functions/queryRangeChildren";
        public static final String Functions_sclValue = "http://www.simantics.org/Spreadsheet-1.2/Functions/sclValue";
        public static final String Functions_sheetRunDomainChildren = "http://www.simantics.org/Spreadsheet-1.2/Functions/sheetRunDomainChildren";
        public static final String Functions_spreadsheetChildren = "http://www.simantics.org/Spreadsheet-1.2/Functions/spreadsheetChildren";
        public static final String Functions_spreadsheetInput = "http://www.simantics.org/Spreadsheet-1.2/Functions/spreadsheetInput";
        public static final String Functions_spreadsheetLinesChildren = "http://www.simantics.org/Spreadsheet-1.2/Functions/spreadsheetLinesChildren";
        public static final String Functions_spreadsheetRunInput = "http://www.simantics.org/Spreadsheet-1.2/Functions/spreadsheetRunInput";
        public static final String Functions_spreadsheetSession = "http://www.simantics.org/Spreadsheet-1.2/Functions/spreadsheetSession";
        public static final String Functions_spreadsheetVariableCellEditor = "http://www.simantics.org/Spreadsheet-1.2/Functions/spreadsheetVariableCellEditor";
        public static final String Functions_stringArrayChildren = "http://www.simantics.org/Spreadsheet-1.2/Functions/stringArrayChildren";
        public static final String Functions_textCellEditor = "http://www.simantics.org/Spreadsheet-1.2/Functions/textCellEditor";
        public static final String Functions_variableCellEditor = "http://www.simantics.org/Spreadsheet-1.2/Functions/variableCellEditor";
        public static final String HasInitialCondition = "http://www.simantics.org/Spreadsheet-1.2/HasInitialCondition";
        public static final String HasInitialCondition_Inverse = "http://www.simantics.org/Spreadsheet-1.2/HasInitialCondition/Inverse";
        public static final String HasLocation = "http://www.simantics.org/Spreadsheet-1.2/HasLocation";
        public static final String HasLocation_Inverse = "http://www.simantics.org/Spreadsheet-1.2/HasLocation/Inverse";
        public static final String HasMicrosoftExcelDocumentData = "http://www.simantics.org/Spreadsheet-1.2/HasMicrosoftExcelDocumentData";
        public static final String HasMicrosoftExcelDocumentData_Inverse = "http://www.simantics.org/Spreadsheet-1.2/HasMicrosoftExcelDocumentData/Inverse";
        public static final String HasRVI = "http://www.simantics.org/Spreadsheet-1.2/HasRVI";
        public static final String HasRVI_Inverse = "http://www.simantics.org/Spreadsheet-1.2/HasRVI/Inverse";
        public static final String HasSheet = "http://www.simantics.org/Spreadsheet-1.2/HasSheet";
        public static final String Headers = "http://www.simantics.org/Spreadsheet-1.2/Headers";
        public static final String Headers_columnLabels = "http://www.simantics.org/Spreadsheet-1.2/Headers/columnLabels";
        public static final String Headers_columnLabels_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Headers/columnLabels/Inverse";
        public static final String Headers_columnWidths = "http://www.simantics.org/Spreadsheet-1.2/Headers/columnWidths";
        public static final String Headers_columnWidths_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Headers/columnWidths/Inverse";
        public static final String Headers_rowHeights = "http://www.simantics.org/Spreadsheet-1.2/Headers/rowHeights";
        public static final String Headers_rowHeights_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Headers/rowHeights/Inverse";
        public static final String Headers_rowLabels = "http://www.simantics.org/Spreadsheet-1.2/Headers/rowLabels";
        public static final String Headers_rowLabels_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Headers/rowLabels/Inverse";
        public static final String InitialCondition = "http://www.simantics.org/Spreadsheet-1.2/InitialCondition";
        public static final String InitialCondition_ConditionOf = "http://www.simantics.org/Spreadsheet-1.2/InitialCondition/ConditionOf";
        public static final String InitialCondition_ConditionOf_Inverse = "http://www.simantics.org/Spreadsheet-1.2/InitialCondition/ConditionOf/Inverse";
        public static final String InitialCondition_DefaultConditionOf = "http://www.simantics.org/Spreadsheet-1.2/InitialCondition/DefaultConditionOf";
        public static final String InitialCondition_bytes = "http://www.simantics.org/Spreadsheet-1.2/InitialCondition/bytes";
        public static final String InitialCondition_bytes_Inverse = "http://www.simantics.org/Spreadsheet-1.2/InitialCondition/bytes/Inverse";
        public static final String IsSheetOf = "http://www.simantics.org/Spreadsheet-1.2/IsSheetOf";
        public static final String Line = "http://www.simantics.org/Spreadsheet-1.2/Line";
        public static final String LineContent = "http://www.simantics.org/Spreadsheet-1.2/LineContent";
        public static final String LineNode = "http://www.simantics.org/Spreadsheet-1.2/LineNode";
        public static final String LineNode_keys = "http://www.simantics.org/Spreadsheet-1.2/LineNode/keys";
        public static final String LineNode_keys_Inverse = "http://www.simantics.org/Spreadsheet-1.2/LineNode/keys/Inverse";
        public static final String Line_content = "http://www.simantics.org/Spreadsheet-1.2/Line/content";
        public static final String Line_content_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Line/content/Inverse";
        public static final String Lines = "http://www.simantics.org/Spreadsheet-1.2/Lines";
        public static final String MicrosoftExcelDocument = "http://www.simantics.org/Spreadsheet-1.2/MicrosoftExcelDocument";
        public static final String MicrosoftExcelDocumentData = "http://www.simantics.org/Spreadsheet-1.2/MicrosoftExcelDocumentData";
        public static final String ModelSourceContribution = "http://www.simantics.org/Spreadsheet-1.2/ModelSourceContribution";
        public static final String Range = "http://www.simantics.org/Spreadsheet-1.2/Range";
        public static final String Range_heightBound = "http://www.simantics.org/Spreadsheet-1.2/Range/heightBound";
        public static final String Range_heightBound_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Range/heightBound/Inverse";
        public static final String Range_location = "http://www.simantics.org/Spreadsheet-1.2/Range/location";
        public static final String Range_location_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Range/location/Inverse";
        public static final String Range_widthBound = "http://www.simantics.org/Spreadsheet-1.2/Range/widthBound";
        public static final String Range_widthBound_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Range/widthBound/Inverse";
        public static final String Run = "http://www.simantics.org/Spreadsheet-1.2/Run";
        public static final String SCLCell = "http://www.simantics.org/Spreadsheet-1.2/SCLCell";
        public static final String SCLCell_Expression = "http://www.simantics.org/Spreadsheet-1.2/SCLCell/Expression";
        public static final String SCLCell_Expression_Inverse = "http://www.simantics.org/Spreadsheet-1.2/SCLCell/Expression/Inverse";
        public static final String SCLMain = "http://www.simantics.org/Spreadsheet-1.2/SCLMain";
        public static final String SCLValue = "http://www.simantics.org/Spreadsheet-1.2/SCLValue";
        public static final String SheetSourceContribution = "http://www.simantics.org/Spreadsheet-1.2/SheetSourceContribution";
        public static final String SourceContribution = "http://www.simantics.org/Spreadsheet-1.2/SourceContribution";
        public static final String SourceContribution_function = "http://www.simantics.org/Spreadsheet-1.2/SourceContribution/function";
        public static final String SourceContribution_function_Inverse = "http://www.simantics.org/Spreadsheet-1.2/SourceContribution/function/Inverse";
        public static final String SourceContribution_labeler = "http://www.simantics.org/Spreadsheet-1.2/SourceContribution/labeler";
        public static final String SourceContribution_labeler_Inverse = "http://www.simantics.org/Spreadsheet-1.2/SourceContribution/labeler/Inverse";
        public static final String Spreadsheet = "http://www.simantics.org/Spreadsheet-1.2/Spreadsheet";
        public static final String SpreadsheetElement = "http://www.simantics.org/Spreadsheet-1.2/SpreadsheetElement";
        public static final String StringArrayCell = "http://www.simantics.org/Spreadsheet-1.2/StringArrayCell";
        public static final String StringArrayCell_HasStringArray = "http://www.simantics.org/Spreadsheet-1.2/StringArrayCell/HasStringArray";
        public static final String StringArrayCell_HasStringArray_Inverse = "http://www.simantics.org/Spreadsheet-1.2/StringArrayCell/HasStringArray/Inverse";
        public static final String StringArrayCell_HasWidth = "http://www.simantics.org/Spreadsheet-1.2/StringArrayCell/HasWidth";
        public static final String StringArrayCell_HasWidth_Inverse = "http://www.simantics.org/Spreadsheet-1.2/StringArrayCell/HasWidth/Inverse";
        public static final String StringArrayRange = "http://www.simantics.org/Spreadsheet-1.2/StringArrayRange";
        public static final String StringArrayRange_array = "http://www.simantics.org/Spreadsheet-1.2/StringArrayRange/array";
        public static final String StringArrayRange_array_Inverse = "http://www.simantics.org/Spreadsheet-1.2/StringArrayRange/array/Inverse";
        public static final String Style = "http://www.simantics.org/Spreadsheet-1.2/Style";
        public static final String Style_id = "http://www.simantics.org/Spreadsheet-1.2/Style/id";
        public static final String Style_id_Inverse = "http://www.simantics.org/Spreadsheet-1.2/Style/id/Inverse";
        public static final String TextCell = "http://www.simantics.org/Spreadsheet-1.2/TextCell";
        public static final String cellEditor = "http://www.simantics.org/Spreadsheet-1.2/cellEditor";
        public static final String cellEditor_Inverse = "http://www.simantics.org/Spreadsheet-1.2/cellEditor/Inverse";
        public static final String scl = "http://www.simantics.org/Spreadsheet-1.2/scl";
        public static final String sclValue = "http://www.simantics.org/Spreadsheet-1.2/sclValue";
        public static final String session = "http://www.simantics.org/Spreadsheet-1.2/session";
        public static final String session_Inverse = "http://www.simantics.org/Spreadsheet-1.2/session/Inverse";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public SpreadsheetResource(ReadGraph graph) {
        Attribute = getResourceOrNull(graph, URIs.Attribute);
        Book = getResourceOrNull(graph, URIs.Book);
        Book_HasDefaultInitialCondition = getResourceOrNull(graph, URIs.Book_HasDefaultInitialCondition);
        BrowseContext = getResourceOrNull(graph, URIs.BrowseContext);
        Cell = getResourceOrNull(graph, URIs.Cell);
        Cell_HasStyle = getResourceOrNull(graph, URIs.Cell_HasStyle);
        Cell_StyleOf = getResourceOrNull(graph, URIs.Cell_StyleOf);
        Cell_align = getResourceOrNull(graph, URIs.Cell_align);
        Cell_align_Inverse = getResourceOrNull(graph, URIs.Cell_align_Inverse);
        Cell_background = getResourceOrNull(graph, URIs.Cell_background);
        Cell_background_Inverse = getResourceOrNull(graph, URIs.Cell_background_Inverse);
        Cell_border = getResourceOrNull(graph, URIs.Cell_border);
        Cell_border_Inverse = getResourceOrNull(graph, URIs.Cell_border_Inverse);
        Cell_columnSpan = getResourceOrNull(graph, URIs.Cell_columnSpan);
        Cell_columnSpan_Inverse = getResourceOrNull(graph, URIs.Cell_columnSpan_Inverse);
        Cell_content = getResourceOrNull(graph, URIs.Cell_content);
        Cell_content_Inverse = getResourceOrNull(graph, URIs.Cell_content_Inverse);
        Cell_editable = getResourceOrNull(graph, URIs.Cell_editable);
        Cell_editable_Inverse = getResourceOrNull(graph, URIs.Cell_editable_Inverse);
        Cell_font = getResourceOrNull(graph, URIs.Cell_font);
        Cell_font_Inverse = getResourceOrNull(graph, URIs.Cell_font_Inverse);
        Cell_foreground = getResourceOrNull(graph, URIs.Cell_foreground);
        Cell_foreground_Inverse = getResourceOrNull(graph, URIs.Cell_foreground_Inverse);
        Cell_formatIndex = getResourceOrNull(graph, URIs.Cell_formatIndex);
        Cell_formatIndex_Inverse = getResourceOrNull(graph, URIs.Cell_formatIndex_Inverse);
        Cell_formatString = getResourceOrNull(graph, URIs.Cell_formatString);
        Cell_formatString_Inverse = getResourceOrNull(graph, URIs.Cell_formatString_Inverse);
        Cell_label = getResourceOrNull(graph, URIs.Cell_label);
        Cell_label_Inverse = getResourceOrNull(graph, URIs.Cell_label_Inverse);
        Cell_locked = getResourceOrNull(graph, URIs.Cell_locked);
        Cell_locked_Inverse = getResourceOrNull(graph, URIs.Cell_locked_Inverse);
        Cell_rowSpan = getResourceOrNull(graph, URIs.Cell_rowSpan);
        Cell_rowSpan_Inverse = getResourceOrNull(graph, URIs.Cell_rowSpan_Inverse);
        Cell_style = getResourceOrNull(graph, URIs.Cell_style);
        Cell_style_Inverse = getResourceOrNull(graph, URIs.Cell_style_Inverse);
        CompositeTemplate = getResourceOrNull(graph, URIs.CompositeTemplate);
        Dimensions = getResourceOrNull(graph, URIs.Dimensions);
        Dimensions_columnCount = getResourceOrNull(graph, URIs.Dimensions_columnCount);
        Dimensions_columnCount_Inverse = getResourceOrNull(graph, URIs.Dimensions_columnCount_Inverse);
        Dimensions_fitColumns = getResourceOrNull(graph, URIs.Dimensions_fitColumns);
        Dimensions_fitColumns_Inverse = getResourceOrNull(graph, URIs.Dimensions_fitColumns_Inverse);
        Dimensions_fitRows = getResourceOrNull(graph, URIs.Dimensions_fitRows);
        Dimensions_fitRows_Inverse = getResourceOrNull(graph, URIs.Dimensions_fitRows_Inverse);
        Dimensions_rowCount = getResourceOrNull(graph, URIs.Dimensions_rowCount);
        Dimensions_rowCount_Inverse = getResourceOrNull(graph, URIs.Dimensions_rowCount_Inverse);
        DoubleArrayCell = getResourceOrNull(graph, URIs.DoubleArrayCell);
        DoubleArrayCell_HasDoubleArray = getResourceOrNull(graph, URIs.DoubleArrayCell_HasDoubleArray);
        DoubleArrayCell_HasDoubleArray_Inverse = getResourceOrNull(graph, URIs.DoubleArrayCell_HasDoubleArray_Inverse);
        DoubleArrayCell_HasWidth = getResourceOrNull(graph, URIs.DoubleArrayCell_HasWidth);
        DoubleArrayCell_HasWidth_Inverse = getResourceOrNull(graph, URIs.DoubleArrayCell_HasWidth_Inverse);
        DoubleArrayRange = getResourceOrNull(graph, URIs.DoubleArrayRange);
        DoubleArrayRange_array = getResourceOrNull(graph, URIs.DoubleArrayRange_array);
        DoubleArrayRange_array_Inverse = getResourceOrNull(graph, URIs.DoubleArrayRange_array_Inverse);
        Element = getResourceOrNull(graph, URIs.Element);
        Element_immutable = getResourceOrNull(graph, URIs.Element_immutable);
        Element_immutable_Inverse = getResourceOrNull(graph, URIs.Element_immutable_Inverse);
        ExcelCell = getResourceOrNull(graph, URIs.ExcelCell);
        Experiment = getResourceOrNull(graph, URIs.Experiment);
        ExpressionRange = getResourceOrNull(graph, URIs.ExpressionRange);
        ExpressionRange_cells = getResourceOrNull(graph, URIs.ExpressionRange_cells);
        ExpressionRange_cells_Inverse = getResourceOrNull(graph, URIs.ExpressionRange_cells_Inverse);
        ForCompositeTemplate = getResourceOrNull(graph, URIs.ForCompositeTemplate);
        ForCompositeTemplate_Inverse = getResourceOrNull(graph, URIs.ForCompositeTemplate_Inverse);
        Functions = getResourceOrNull(graph, URIs.Functions);
        Functions_cellLabel = getResourceOrNull(graph, URIs.Functions_cellLabel);
        Functions_contentDisplayValueAccessor = getResourceOrNull(graph, URIs.Functions_contentDisplayValueAccessor);
        Functions_contentValueAccessor = getResourceOrNull(graph, URIs.Functions_contentValueAccessor);
        Functions_defaultLineCells = getResourceOrNull(graph, URIs.Functions_defaultLineCells);
        Functions_defaultSheetCellEditor = getResourceOrNull(graph, URIs.Functions_defaultSheetCellEditor);
        Functions_doubleArrayChildren = getResourceOrNull(graph, URIs.Functions_doubleArrayChildren);
        Functions_lineNodeKeys = getResourceOrNull(graph, URIs.Functions_lineNodeKeys);
        Functions_queryRangeChildren = getResourceOrNull(graph, URIs.Functions_queryRangeChildren);
        Functions_sclValue = getResourceOrNull(graph, URIs.Functions_sclValue);
        Functions_sheetRunDomainChildren = getResourceOrNull(graph, URIs.Functions_sheetRunDomainChildren);
        Functions_spreadsheetChildren = getResourceOrNull(graph, URIs.Functions_spreadsheetChildren);
        Functions_spreadsheetInput = getResourceOrNull(graph, URIs.Functions_spreadsheetInput);
        Functions_spreadsheetLinesChildren = getResourceOrNull(graph, URIs.Functions_spreadsheetLinesChildren);
        Functions_spreadsheetRunInput = getResourceOrNull(graph, URIs.Functions_spreadsheetRunInput);
        Functions_spreadsheetSession = getResourceOrNull(graph, URIs.Functions_spreadsheetSession);
        Functions_spreadsheetVariableCellEditor = getResourceOrNull(graph, URIs.Functions_spreadsheetVariableCellEditor);
        Functions_stringArrayChildren = getResourceOrNull(graph, URIs.Functions_stringArrayChildren);
        Functions_textCellEditor = getResourceOrNull(graph, URIs.Functions_textCellEditor);
        Functions_variableCellEditor = getResourceOrNull(graph, URIs.Functions_variableCellEditor);
        HasInitialCondition = getResourceOrNull(graph, URIs.HasInitialCondition);
        HasInitialCondition_Inverse = getResourceOrNull(graph, URIs.HasInitialCondition_Inverse);
        HasLocation = getResourceOrNull(graph, URIs.HasLocation);
        HasLocation_Inverse = getResourceOrNull(graph, URIs.HasLocation_Inverse);
        HasMicrosoftExcelDocumentData = getResourceOrNull(graph, URIs.HasMicrosoftExcelDocumentData);
        HasMicrosoftExcelDocumentData_Inverse = getResourceOrNull(graph, URIs.HasMicrosoftExcelDocumentData_Inverse);
        HasRVI = getResourceOrNull(graph, URIs.HasRVI);
        HasRVI_Inverse = getResourceOrNull(graph, URIs.HasRVI_Inverse);
        HasSheet = getResourceOrNull(graph, URIs.HasSheet);
        Headers = getResourceOrNull(graph, URIs.Headers);
        Headers_columnLabels = getResourceOrNull(graph, URIs.Headers_columnLabels);
        Headers_columnLabels_Inverse = getResourceOrNull(graph, URIs.Headers_columnLabels_Inverse);
        Headers_columnWidths = getResourceOrNull(graph, URIs.Headers_columnWidths);
        Headers_columnWidths_Inverse = getResourceOrNull(graph, URIs.Headers_columnWidths_Inverse);
        Headers_rowHeights = getResourceOrNull(graph, URIs.Headers_rowHeights);
        Headers_rowHeights_Inverse = getResourceOrNull(graph, URIs.Headers_rowHeights_Inverse);
        Headers_rowLabels = getResourceOrNull(graph, URIs.Headers_rowLabels);
        Headers_rowLabels_Inverse = getResourceOrNull(graph, URIs.Headers_rowLabels_Inverse);
        InitialCondition = getResourceOrNull(graph, URIs.InitialCondition);
        InitialCondition_ConditionOf = getResourceOrNull(graph, URIs.InitialCondition_ConditionOf);
        InitialCondition_ConditionOf_Inverse = getResourceOrNull(graph, URIs.InitialCondition_ConditionOf_Inverse);
        InitialCondition_DefaultConditionOf = getResourceOrNull(graph, URIs.InitialCondition_DefaultConditionOf);
        InitialCondition_bytes = getResourceOrNull(graph, URIs.InitialCondition_bytes);
        InitialCondition_bytes_Inverse = getResourceOrNull(graph, URIs.InitialCondition_bytes_Inverse);
        IsSheetOf = getResourceOrNull(graph, URIs.IsSheetOf);
        Line = getResourceOrNull(graph, URIs.Line);
        LineContent = getResourceOrNull(graph, URIs.LineContent);
        LineNode = getResourceOrNull(graph, URIs.LineNode);
        LineNode_keys = getResourceOrNull(graph, URIs.LineNode_keys);
        LineNode_keys_Inverse = getResourceOrNull(graph, URIs.LineNode_keys_Inverse);
        Line_content = getResourceOrNull(graph, URIs.Line_content);
        Line_content_Inverse = getResourceOrNull(graph, URIs.Line_content_Inverse);
        Lines = getResourceOrNull(graph, URIs.Lines);
        MicrosoftExcelDocument = getResourceOrNull(graph, URIs.MicrosoftExcelDocument);
        MicrosoftExcelDocumentData = getResourceOrNull(graph, URIs.MicrosoftExcelDocumentData);
        ModelSourceContribution = getResourceOrNull(graph, URIs.ModelSourceContribution);
        Range = getResourceOrNull(graph, URIs.Range);
        Range_heightBound = getResourceOrNull(graph, URIs.Range_heightBound);
        Range_heightBound_Inverse = getResourceOrNull(graph, URIs.Range_heightBound_Inverse);
        Range_location = getResourceOrNull(graph, URIs.Range_location);
        Range_location_Inverse = getResourceOrNull(graph, URIs.Range_location_Inverse);
        Range_widthBound = getResourceOrNull(graph, URIs.Range_widthBound);
        Range_widthBound_Inverse = getResourceOrNull(graph, URIs.Range_widthBound_Inverse);
        Run = getResourceOrNull(graph, URIs.Run);
        SCLCell = getResourceOrNull(graph, URIs.SCLCell);
        SCLCell_Expression = getResourceOrNull(graph, URIs.SCLCell_Expression);
        SCLCell_Expression_Inverse = getResourceOrNull(graph, URIs.SCLCell_Expression_Inverse);
        SCLMain = getResourceOrNull(graph, URIs.SCLMain);
        SCLValue = getResourceOrNull(graph, URIs.SCLValue);
        SheetSourceContribution = getResourceOrNull(graph, URIs.SheetSourceContribution);
        SourceContribution = getResourceOrNull(graph, URIs.SourceContribution);
        SourceContribution_function = getResourceOrNull(graph, URIs.SourceContribution_function);
        SourceContribution_function_Inverse = getResourceOrNull(graph, URIs.SourceContribution_function_Inverse);
        SourceContribution_labeler = getResourceOrNull(graph, URIs.SourceContribution_labeler);
        SourceContribution_labeler_Inverse = getResourceOrNull(graph, URIs.SourceContribution_labeler_Inverse);
        Spreadsheet = getResourceOrNull(graph, URIs.Spreadsheet);
        SpreadsheetElement = getResourceOrNull(graph, URIs.SpreadsheetElement);
        StringArrayCell = getResourceOrNull(graph, URIs.StringArrayCell);
        StringArrayCell_HasStringArray = getResourceOrNull(graph, URIs.StringArrayCell_HasStringArray);
        StringArrayCell_HasStringArray_Inverse = getResourceOrNull(graph, URIs.StringArrayCell_HasStringArray_Inverse);
        StringArrayCell_HasWidth = getResourceOrNull(graph, URIs.StringArrayCell_HasWidth);
        StringArrayCell_HasWidth_Inverse = getResourceOrNull(graph, URIs.StringArrayCell_HasWidth_Inverse);
        StringArrayRange = getResourceOrNull(graph, URIs.StringArrayRange);
        StringArrayRange_array = getResourceOrNull(graph, URIs.StringArrayRange_array);
        StringArrayRange_array_Inverse = getResourceOrNull(graph, URIs.StringArrayRange_array_Inverse);
        Style = getResourceOrNull(graph, URIs.Style);
        Style_id = getResourceOrNull(graph, URIs.Style_id);
        Style_id_Inverse = getResourceOrNull(graph, URIs.Style_id_Inverse);
        TextCell = getResourceOrNull(graph, URIs.TextCell);
        cellEditor = getResourceOrNull(graph, URIs.cellEditor);
        cellEditor_Inverse = getResourceOrNull(graph, URIs.cellEditor_Inverse);
        scl = getResourceOrNull(graph, URIs.scl);
        sclValue = getResourceOrNull(graph, URIs.sclValue);
        session = getResourceOrNull(graph, URIs.session);
        session_Inverse = getResourceOrNull(graph, URIs.session_Inverse);
    }
    
    public static SpreadsheetResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        SpreadsheetResource ret = session.peekService(SpreadsheetResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new SpreadsheetResource(qc.getIndependentGraph(graph));
            session.registerService(SpreadsheetResource.class, ret);
        }
        return ret;
    }
    
    public static SpreadsheetResource getInstance(RequestProcessor session) throws DatabaseException {
        SpreadsheetResource ret = session.peekService(SpreadsheetResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<SpreadsheetResource>() {
                public SpreadsheetResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new SpreadsheetResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(SpreadsheetResource.class, ret);
        }
        return ret;
    }
    
}

