/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.source;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import org.simantics.scl.compiler.compilation.SCLCompiler;
import org.simantics.scl.compiler.environment.EnvironmentFactoryImpl;
import org.simantics.scl.compiler.errors.CompilationErrorFormatter;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.errors.Failure;
import org.simantics.scl.compiler.errors.Success;
import org.simantics.scl.compiler.internal.codegen.types.JavaReferenceValidator;
import org.simantics.scl.compiler.internal.codegen.types.JavaReferenceValidatorFactory;
import org.simantics.scl.compiler.internal.codegen.types.RuntimeJavaReferenceValidator;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.options.ModuleCompilationOptions;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.ModuleSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TextualModuleSource
implements ModuleSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextualModuleSource.class);
    public static final ImportDeclaration[] DEFAULT_IMPORTS = new ImportDeclaration[]{new ImportDeclaration("Builtin", ""), new ImportDeclaration("Prelude", "")};
    private final String moduleName;
    private final double priority;

    public TextualModuleSource(String moduleName, double priority) {
        this.moduleName = moduleName;
        this.priority = priority;
    }

    public TextualModuleSource(String moduleName) {
        this(moduleName, 0.0);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected Reader getSourceReader(UpdateListener listener) throws IOException {
        return new StringReader(this.getSourceText(listener));
    }

    protected JavaReferenceValidator<?, ?, ?, ?> getJavaReferenceValidator() {
        return new RuntimeJavaReferenceValidator(this.getClassLoader());
    }

    public String getSourceText(UpdateListener listener) throws IOException {
        Reader reader = this.getSourceReader(listener);
        char[] buffer = new char[4096];
        int pos = 0;
        try {
            while (true) {
                int count;
                if ((count = reader.read(buffer, pos, buffer.length - pos)) == -1) {
                    String string = new String(buffer, 0, pos);
                    return string;
                }
                if ((pos += count) != buffer.length) continue;
                buffer = Arrays.copyOf(buffer, 2 * buffer.length);
            }
        }
        finally {
            reader.close();
        }
    }

    public ImportDeclaration[] getBuiltinImports(UpdateListener listener) {
        return DEFAULT_IMPORTS;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public Failable<Module> compileModule(ModuleRepository environment, UpdateListener listener, ModuleCompilationOptions options) {
        SCLCompiler compiler = new SCLCompiler(options, this.getJavaReferenceValidatorFactory());
        try {
            String source = this.getSourceText(listener);
            compiler.addSource(source);
            compiler.compile(new EnvironmentFactoryImpl(environment, this.getBuiltinImports(listener), listener), this.moduleName);
            if (compiler.getErrorLog().hasNoErrors()) {
                return new Success<Module>(compiler.getModule());
            }
            if (options == null || !options.silent) {
                LOGGER.error("While compiling " + this.getModuleName() + ":\n    " + CompilationErrorFormatter.toString(this.getSourceReader(null), compiler.getErrorLog().getErrors()).replaceAll("\n", "\n    "));
            }
            return new Failure(compiler.getErrorLog().getErrors());
        }
        catch (IOException e) {
            if (options == null || !options.silent) {
                LOGGER.error("Compilation of module " + this.moduleName + " failed.", (Throwable)e);
            }
            return new Failure(e);
        }
    }

    public JavaReferenceValidatorFactory getJavaReferenceValidatorFactory() {
        return new JavaReferenceValidatorFactory(){

            @Override
            public JavaReferenceValidator<Object, Object, Object, Object> getJavaReferenceValidator(String context) {
                return TextualModuleSource.this.getJavaReferenceValidator();
            }

            @Override
            public JavaReferenceValidator<Object, Object, Object, Object> getDefaultJavaReferenceValidator() {
                return TextualModuleSource.this.getJavaReferenceValidator();
            }
        };
    }

    @Override
    public double getPriority() {
        return this.priority;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.moduleName + ")";
    }

    @Override
    public boolean isUpdateable() {
        return false;
    }

    public void update(String newSourceText) {
        throw new UnsupportedOperationException();
    }
}

