/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.query;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.QueryTransformer;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.java.Builtins;
import org.simantics.scl.compiler.elaboration.query.QAbstractCombiner;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.QueryVisitor;
import org.simantics.scl.compiler.elaboration.query.compilation.ConstraintCollectionContext;
import org.simantics.scl.compiler.elaboration.query.compilation.DerivateException;
import org.simantics.scl.compiler.elaboration.query.compilation.EnforcingContext;
import org.simantics.scl.compiler.elaboration.query.compilation.UnsolvableQueryException;
import org.simantics.scl.compiler.elaboration.relations.LocalRelation;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.types.Types;

public class QConjunction
extends QAbstractCombiner {
    public QConjunction(Query ... queries) {
        super(queries);
    }

    public QConjunction(Collection<Query> queries) {
        this(queries.toArray(new Query[queries.size()]));
    }

    @Override
    public Expression generateEnforce(EnforcingContext context) {
        Expression result = new EConstant(Builtins.TUPLE_CONSTRUCTORS[0]);
        int i = this.queries.length - 1;
        while (i >= 0) {
            result = new ESimpleLet(new Variable("_", Types.tupleConstructor(0)), this.queries[i].generateEnforce(context), result);
            --i;
        }
        return result;
    }

    @Override
    public void collectConstraints(ConstraintCollectionContext context) throws UnsolvableQueryException {
        Query[] queryArray = this.queries;
        int n = this.queries.length;
        int n2 = 0;
        while (n2 < n) {
            Query query = queryArray[n2];
            query.collectConstraints(context);
            ++n2;
        }
    }

    @Override
    public Query.Diff[] derivate(THashMap<LocalRelation, Query.Diffable> diffables) throws DerivateException {
        ArrayList<Query> cons = new ArrayList<Query>(this.queries.length);
        ArrayList<DerEntry> ders = new ArrayList<DerEntry>(this.queries.length);
        Query[] queryArray = this.queries;
        int n = this.queries.length;
        int n2 = 0;
        while (n2 < n) {
            Query query = queryArray[n2];
            Query.Diff[] diffs = query.derivate(diffables);
            if (diffs.length == 0) {
                cons.add(query);
            } else {
                ders.add(new DerEntry(query, diffs));
            }
            ++n2;
        }
        if (ders.isEmpty()) {
            return NO_DIFF;
        }
        QConjunction base = new QConjunction(cons.toArray(new Query[cons.size()]));
        Query.Diff[] diffs = NO_DIFF;
        for (DerEntry entry : ders) {
            ArrayList<Query.Diff> newDiffs = new ArrayList<Query.Diff>();
            Query.Diff[] diffArray = diffs;
            int n3 = diffs.length;
            int n4 = 0;
            while (n4 < n3) {
                Query.Diff diff = diffArray[n4];
                newDiffs.add(new Query.Diff(diff.id, new QConjunction(diff.query, entry.base)));
                ++n4;
            }
            diffArray = entry.diffs;
            n3 = entry.diffs.length;
            n4 = 0;
            while (n4 < n3) {
                Query.Diff newDiff = diffArray[n4];
                newDiffs.add(new Query.Diff(newDiff.id, new QConjunction(base, newDiff.query)));
                Query.Diff[] diffArray2 = diffs;
                int n5 = diffs.length;
                int n6 = 0;
                while (n6 < n5) {
                    Query.Diff diff = diffArray2[n6];
                    if (diff.id == newDiff.id) {
                        newDiffs.add(new Query.Diff(diff.id, new QConjunction(diff.query, newDiff.query)));
                    }
                    ++n6;
                }
                ++n4;
            }
            base = new QConjunction(base, entry.base);
            diffs = newDiffs.toArray(new Query.Diff[newDiffs.size()]);
        }
        return diffs;
    }

    @Override
    public Query removeRelations(Set<SCLRelation> relations) {
        int i = 0;
        while (i < this.queries.length) {
            Query query = this.queries[i];
            Query newQuery = query.removeRelations(relations);
            if (query != newQuery) {
                if (newQuery == EMPTY_QUERY) {
                    return EMPTY_QUERY;
                }
                Query[] newQueries = new Query[this.queries.length];
                if (i > 0) {
                    System.arraycopy(this.queries, 0, newQueries, 0, i - 1);
                }
                newQueries[i] = newQuery;
                ++i;
                while (i < this.queries.length) {
                    query = this.queries[i];
                    newQuery = query.removeRelations(relations);
                    if (newQuery == EMPTY_QUERY) {
                        return EMPTY_QUERY;
                    }
                    newQueries[i] = query;
                    ++i;
                }
                return new QConjunction(newQueries);
            }
            ++i;
        }
        return this;
    }

    @Override
    public Query replace(ReplaceContext context) {
        Query[] newQueries = new Query[this.queries.length];
        int i = 0;
        while (i < this.queries.length) {
            newQueries[i] = this.queries[i].replace(context);
            ++i;
        }
        return new QConjunction(newQueries);
    }

    @Override
    public void accept(QueryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void splitToPhases(TIntObjectHashMap<ArrayList<Query>> result) {
        Query[] queryArray = this.queries;
        int n = this.queries.length;
        int n2 = 0;
        while (n2 < n) {
            Query query = queryArray[n2];
            query.splitToPhases(result);
            ++n2;
        }
    }

    @Override
    public Query accept(QueryTransformer transformer) {
        return transformer.transform(this);
    }

    private static class DerEntry {
        Query base;
        Query.Diff[] diffs;

        public DerEntry(Query base, Query.Diff[] diffs) {
            this.base = base;
            this.diffs = diffs;
        }
    }
}

