/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.compilation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.elaboration.java.ExternalConstantException;
import org.simantics.scl.compiler.elaboration.java.ExternalConstantReader;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.internal.codegen.effects.EffectConstructor;
import org.simantics.scl.compiler.module.ConcreteModule;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.module.options.ModuleCompilationOptions;
import org.simantics.scl.compiler.module.options.StoredModuleSupport;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.top.ModuleInitializer;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.runtime.SCLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredModule
implements Externalizable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoredModule.class);
    private static final long serialVersionUID = -1512783817837814358L;
    public String moduleName;
    public String classLoaderKey;
    public List<ImportDeclaration> dependencies;
    public Map<String, TypeDescriptor> typeDescriptors;
    public Map<String, TypeClass> typeClasses;
    public Map<TCon, ArrayList<TypeClassInstance>> typeClassInstances;
    public Map<String, EffectConstructor> effectConstructors;
    public Map<String, List<Constant>> fieldAccessors;
    public Collection<SCLValue> values;
    public ModuleInitializer moduleInitializer;
    public Map<String, byte[]> classes;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Classes\n");
        for (String name : this.classes.keySet()) {
            sb.append(name);
            sb.append(": ");
            sb.append(this.classes.get(name).length);
            sb.append("bytes\n");
        }
        return sb.toString();
    }

    public static StoredModule fromModule(StoredModuleSupport classLoaderProvider, ConcreteModule module) {
        StoredModule result = new StoredModule();
        result.moduleName = module.getName();
        result.classLoaderKey = classLoaderProvider.getClassLoaderKey(module.getParentClassLoader());
        result.dependencies = module.getDependencies();
        result.typeDescriptors = module.getTypeDescriptors();
        result.typeClasses = module.getTypeClassMap();
        result.typeClassInstances = module.getTypeInstances();
        result.effectConstructors = module.getEffectConstructors();
        result.values = module.getValues();
        result.fieldAccessors = module.getFieldAccessors();
        result.classes = module.getClasses();
        result.moduleInitializer = module.getModuleInitializer();
        return result;
    }

    public ConcreteModule toModule(StoredModuleSupport classLoaderProvider) {
        List<Constant> list;
        ConcreteModule module = new ConcreteModule(this.moduleName);
        module.setClasses(this.classes);
        module.setParentClassLoader(classLoaderProvider.getClassLoader(this.classLoaderKey));
        for (String name : this.typeClasses.keySet()) {
            module.addTypeClass(name, this.typeClasses.get(name));
        }
        for (String name : this.typeDescriptors.keySet()) {
            module.addTypeDescriptor(name, this.typeDescriptors.get(name));
        }
        for (TCon con : this.typeClassInstances.keySet()) {
            list = (List<Constant>)this.typeClassInstances.get(con);
            for (TypeClassInstance typeClassInstance : list) {
                module.addTypeClassInstance(con, typeClassInstance);
            }
        }
        for (ImportDeclaration dependency : this.dependencies) {
            module.addDependency(dependency);
        }
        for (String name : this.effectConstructors.keySet()) {
            module.addEffectConstructor(name, this.effectConstructors.get(name));
        }
        for (String name : this.fieldAccessors.keySet()) {
            list = this.fieldAccessors.get(name);
            for (Constant constant : list) {
                module.addFieldAccessor(name, constant);
            }
        }
        for (SCLValue value : this.values) {
            module.addValue(value);
        }
        module.setModuleInitializer(this.moduleInitializer);
        return module;
    }

    private static String storeFileName(String moduleName) {
        return moduleName.replace(':', '_').replace('\\', '_').replace('/', '_');
    }

    private static File storeFile(ModuleRepository repository, String moduleName) {
        Path path = repository.getLocation();
        if (path == null) {
            return null;
        }
        File parent = path.toFile();
        File scl = new File(parent, "scl");
        return new File(scl, StoredModule.storeFileName(moduleName));
    }

    public static ConcreteModule read(ModuleRepository repository, ModuleCompilationOptions options, String moduleName) {
        block11: {
            ConcreteModule concreteModule;
            File fp;
            block10: {
                block9: {
                    if (ModuleCompilationOptions.StoreOption.NONE.equals((Object)options.store)) {
                        return null;
                    }
                    fp = StoredModule.storeFile(repository, moduleName);
                    if (fp != null) break block9;
                    return null;
                }
                if (fp.exists()) break block10;
                return null;
            }
            byte[] bytes = Files.readAllBytes(fp.toPath());
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream oi = new ObjectInputStream(bais);
            StoredModule cls = null;
            ExternalConstantReader old = (ExternalConstantReader)SCLContext.getCurrent().get((Object)"ExternalConstantReader");
            try {
                SCLContext.getCurrent().put((Object)"ExternalConstantReader", (Object)options.classLoaderProvider.getExternalConstantReader());
                cls = options.classLoaderProvider.readModule(oi);
                concreteModule = cls.toModule(options.classLoaderProvider);
            }
            catch (Throwable throwable) {
                try {
                    SCLContext.getCurrent().put((Object)"ExternalConstantReader", (Object)old);
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Error while reading SCL module " + moduleName, (Throwable)e);
                    break block11;
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Error while reading SCL module " + moduleName, (Throwable)e);
                }
            }
            SCLContext.getCurrent().put((Object)"ExternalConstantReader", (Object)old);
            return concreteModule;
        }
        return null;
    }

    public static void write(ModuleRepository repository, ModuleCompilationOptions options, ConcreteModule module) {
        if (!ModuleCompilationOptions.StoreOption.WRITE.equals((Object)options.store)) {
            return;
        }
        if (!module.supportsStore()) {
            return;
        }
        try {
            File fp = StoredModule.storeFile(repository, module.getName());
            if (fp == null) {
                return;
            }
            fp.getParentFile().mkdirs();
            StoredModule cls = StoredModule.fromModule(options.classLoaderProvider, module);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oo = new ObjectOutputStream(baos);
            SCLContext.getCurrent().put((Object)"ExternalConstantReader", (Object)options.classLoaderProvider.getExternalConstantReader());
            oo.writeObject(cls);
            Files.write(fp.toPath(), baos.toByteArray(), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            LOGGER.debug("Wrote " + module.getName());
        }
        catch (ExternalConstantException e) {
            LOGGER.info("Module " + module.getName() + " was not written: " + e.getMessage());
        }
        catch (IOException e) {
            LOGGER.debug("Module " + module.getName() + " was not written: " + e.getMessage());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        List<Serializable> list;
        out.writeUTF(this.moduleName);
        out.writeUTF(this.classLoaderKey);
        out.writeObject(this.dependencies);
        out.writeInt(this.typeDescriptors.size());
        for (String string : this.typeDescriptors.keySet()) {
            TypeDescriptor td = this.typeDescriptors.get(string);
            out.writeUTF(string);
            out.writeObject(td);
        }
        out.writeInt(this.typeClasses.size());
        for (String string : this.typeClasses.keySet()) {
            TypeClass tc = this.typeClasses.get(string);
            out.writeUTF(string);
            out.writeObject(tc);
        }
        out.writeInt(this.typeClassInstances.size());
        for (TCon tCon : this.typeClassInstances.keySet()) {
            list = this.typeClassInstances.get(tCon);
            out.writeObject(tCon);
            out.writeObject(list);
        }
        out.writeInt(this.effectConstructors.size());
        for (String string : this.effectConstructors.keySet()) {
            EffectConstructor ec = this.effectConstructors.get(string);
            out.writeUTF(string);
            out.writeObject(ec);
        }
        out.writeInt(this.fieldAccessors.size());
        for (String string : this.fieldAccessors.keySet()) {
            list = this.fieldAccessors.get(string);
            out.writeUTF(string);
            out.writeObject(list);
        }
        out.writeInt(this.values.size());
        for (SCLValue sCLValue : this.values) {
            out.writeObject(sCLValue);
        }
        out.writeObject(this.moduleInitializer);
        out.writeObject(this.classes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ArrayList list;
        String name;
        this.moduleName = in.readUTF();
        this.classLoaderKey = in.readUTF();
        this.dependencies = (List)in.readObject();
        int len = in.readInt();
        this.typeDescriptors = new HashMap<String, TypeDescriptor>(len);
        int i = 0;
        while (i < len) {
            name = in.readUTF();
            TypeDescriptor td = (TypeDescriptor)in.readObject();
            this.typeDescriptors.put(name, td);
            ++i;
        }
        len = in.readInt();
        this.typeClasses = new HashMap<String, TypeClass>(len);
        i = 0;
        while (i < len) {
            name = in.readUTF();
            TypeClass tc = (TypeClass)in.readObject();
            this.typeClasses.put(name, tc);
            ++i;
        }
        len = in.readInt();
        this.typeClassInstances = new HashMap<TCon, ArrayList<TypeClassInstance>>(len);
        i = 0;
        while (i < len) {
            TCon con = Types.con((TCon)in.readObject());
            list = (ArrayList)in.readObject();
            this.typeClassInstances.put(con, list);
            ++i;
        }
        len = in.readInt();
        this.effectConstructors = new HashMap<String, EffectConstructor>(len);
        i = 0;
        while (i < len) {
            name = in.readUTF();
            EffectConstructor ec = (EffectConstructor)in.readObject();
            this.effectConstructors.put(name, ec);
            ++i;
        }
        len = in.readInt();
        this.fieldAccessors = new HashMap<String, List<Constant>>(len);
        i = 0;
        while (i < len) {
            String key = in.readUTF();
            list = (ArrayList)in.readObject();
            this.fieldAccessors.put(key, list);
            ++i;
        }
        len = in.readInt();
        this.values = new ArrayList<SCLValue>();
        i = 0;
        while (i < len) {
            this.values.add((SCLValue)in.readObject());
            ++i;
        }
        this.moduleInitializer = (ModuleInitializer)in.readObject();
        this.classes = (Map)in.readObject();
    }
}

