/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.lang.ref.Reference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.cojen.util.WeakIdentityMap;

public abstract class ReferencedValueHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable {
    static final Object NULL = new Comparable(){

        public int compareTo(Object obj) {
            return obj == this || obj == null ? 0 : 1;
        }
    };
    private transient Entry<K, V>[] table;
    private transient int count;
    private int threshold;
    private final float loadFactor;
    private volatile transient int modCount;
    private transient Set<K> keySet;
    private transient Set<Map.Entry<K, V>> entrySet;
    private transient Collection<V> values;

    public ReferencedValueHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public ReferencedValueHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ReferencedValueHashMap() {
        this(11, 0.75f);
    }

    public ReferencedValueHashMap(Map<? extends K, ? extends V> t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            value = NULL;
        }
        Entry<K, V>[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            Entry<K, V> e = tab[i];
            Entry<K, V> prev = null;
            while (e != null) {
                V entryValue = e.get();
                if (entryValue == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[i] = e.next;
                    }
                    --this.count;
                } else {
                    if (value.equals(entryValue)) {
                        return true;
                    }
                    prev = e;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        Entry<K, V>[] tab = this.table;
        if (key != null) {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry<K, V> e = tab[index];
            Entry<K, V> prev = null;
            while (e != null) {
                if (e.get() == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    --this.count;
                } else {
                    if (e.hash == hash && key.equals(e.key)) {
                        return true;
                    }
                    prev = e;
                }
                e = e.next;
            }
        } else {
            Entry<K, V> e = tab[0];
            Entry<K, V> prev = null;
            while (e != null) {
                if (e.get() == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[0] = e.next;
                    }
                    --this.count;
                } else {
                    if (e.key == null) {
                        return true;
                    }
                    prev = e;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Entry<K, V>[] tab = this.table;
        if (key != null) {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry<K, V> e = tab[index];
            Entry<K, V> prev = null;
            while (e != null) {
                V entryValue = e.get();
                if (entryValue == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    --this.count;
                } else {
                    if (e.hash == hash && key.equals(e.key)) {
                        return entryValue == NULL ? null : (V)entryValue;
                    }
                    prev = e;
                }
                e = e.next;
            }
        } else {
            Entry<K, V> e = tab[0];
            Entry<K, V> prev = null;
            while (e != null) {
                V entryValue = e.get();
                if (entryValue == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[0] = e.next;
                    }
                    --this.count;
                } else {
                    if (e.key == null) {
                        return entryValue == NULL ? null : (V)entryValue;
                    }
                    prev = e;
                }
                e = e.next;
            }
        }
        return null;
    }

    private void cleanup() {
        Entry<K, V>[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            Entry<K, V> e = tab[i];
            Entry<K, V> prev = null;
            while (e != null) {
                if (e.get() == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[i] = e.next;
                    }
                    --this.count;
                } else {
                    prev = e;
                }
                e = e.next;
            }
        }
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry<K, V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry<K, V> old = oldMap[i];
            while (old != null) {
                Entry<K, V> e = old;
                old = old.next;
                if (e.get() == null) {
                    --this.count;
                    continue;
                }
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    @Override
    public V put(K key, V value) {
        Entry<K, V> e;
        int index;
        int hash;
        if (value == null) {
            value = NULL;
        }
        Entry<K, V>[] tab = this.table;
        if (key != null) {
            hash = key.hashCode();
            index = (hash & Integer.MAX_VALUE) % tab.length;
            e = tab[index];
            Entry<K, V> prev = null;
            while (e != null) {
                V entryValue = e.get();
                if (entryValue == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    --this.count;
                } else {
                    if (e.hash == hash && key.equals(e.key)) {
                        e.setValue(value);
                        return entryValue == NULL ? null : (V)entryValue;
                    }
                    prev = e;
                }
                e = e.next;
            }
        } else {
            hash = 0;
            index = 0;
            e = tab[0];
            Entry<K, V> prev = null;
            while (e != null) {
                V entryValue = e.get();
                if (entryValue == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[0] = e.next;
                    }
                    --this.count;
                } else {
                    if (e.key == null) {
                        e.setValue(value);
                        return entryValue == NULL ? null : (V)entryValue;
                    }
                    prev = e;
                }
                e = e.next;
            }
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.cleanup();
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        e = this.newEntry(hash, key, value, tab[index]);
        tab[index] = e;
        ++this.count;
        return null;
    }

    @Override
    public V remove(Object key) {
        Entry<K, V>[] tab = this.table;
        if (key != null) {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry<K, V> e = tab[index];
            Entry<K, V> prev = null;
            while (e != null) {
                V entryValue = e.get();
                if (entryValue == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    --this.count;
                } else {
                    if (e.hash == hash && key.equals(e.key)) {
                        ++this.modCount;
                        if (prev != null) {
                            prev.next = e.next;
                        } else {
                            tab[index] = e.next;
                        }
                        --this.count;
                        e.setValue(null);
                        return entryValue == NULL ? null : (V)entryValue;
                    }
                    prev = e;
                }
                e = e.next;
            }
        } else {
            Entry<K, V> e = tab[0];
            Entry<K, V> prev = null;
            while (e != null) {
                V entryValue = e.get();
                if (entryValue == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[0] = e.next;
                    }
                    --this.count;
                } else {
                    if (e.key == null) {
                        ++this.modCount;
                        if (prev != null) {
                            prev.next = e.next;
                        } else {
                            tab[0] = e.next;
                        }
                        --this.count;
                        e.setValue(null);
                        return entryValue == NULL ? null : (V)entryValue;
                    }
                    prev = e;
                }
                e = e.next;
            }
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        Entry<K, V>[] tab = this.table;
        ++this.modCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    @Override
    public Object clone() {
        try {
            ReferencedValueHashMap t = (ReferencedValueHashMap)super.clone();
            t.table = new Entry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                Entry<K, V> entry = t.table[i] = this.table[i] != null ? (Entry<K, V>)this.table[i].clone() : null;
            }
            t.keySet = null;
            t.entrySet = null;
            t.values = null;
            t.modCount = 0;
            return t;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public Iterator iterator() {
                    return ReferencedValueHashMap.this.createHashIterator(0);
                }

                @Override
                public int size() {
                    return ReferencedValueHashMap.this.count;
                }

                @Override
                public boolean contains(Object o) {
                    return ReferencedValueHashMap.this.containsKey(o);
                }

                @Override
                public boolean remove(Object o) {
                    if (o == null) {
                        if (ReferencedValueHashMap.this.containsKey(null)) {
                            ReferencedValueHashMap.this.remove(null);
                            return true;
                        }
                        return false;
                    }
                    return ReferencedValueHashMap.this.remove(o) != null;
                }

                @Override
                public void clear() {
                    ReferencedValueHashMap.this.clear();
                }

                @Override
                public String toString() {
                    return WeakIdentityMap.toString(this);
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public Iterator iterator() {
                    return ReferencedValueHashMap.this.createHashIterator(1);
                }

                @Override
                public int size() {
                    return ReferencedValueHashMap.this.count;
                }

                @Override
                public boolean contains(Object o) {
                    return ReferencedValueHashMap.this.containsValue(o);
                }

                @Override
                public void clear() {
                    ReferencedValueHashMap.this.clear();
                }

                @Override
                public String toString() {
                    return WeakIdentityMap.toString(this);
                }
            };
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator iterator() {
                    return ReferencedValueHashMap.this.createHashIterator(2);
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Entry<K, V>[] tab = ReferencedValueHashMap.this.table;
                    int hash = key == null ? 0 : key.hashCode();
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e = tab[index];
                    Entry prev = null;
                    while (e != null) {
                        Object entryValue = e.get();
                        if (entryValue == null) {
                            ++ReferencedValueHashMap.this.modCount;
                            if (prev != null) {
                                prev.next = e.next;
                            } else {
                                tab[index] = e.next;
                            }
                            --ReferencedValueHashMap.this.count;
                        } else {
                            if (e.hash == hash && e.equals(entry)) {
                                return true;
                            }
                            prev = e;
                        }
                        e = e.next;
                    }
                    return false;
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Entry<K, V>[] tab = ReferencedValueHashMap.this.table;
                    int hash = key == null ? 0 : key.hashCode();
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e = tab[index];
                    Entry prev = null;
                    while (e != null) {
                        Object entryValue = e.get();
                        if (entryValue == null) {
                            ++ReferencedValueHashMap.this.modCount;
                            if (prev != null) {
                                prev.next = e.next;
                            } else {
                                tab[index] = e.next;
                            }
                            --ReferencedValueHashMap.this.count;
                        } else {
                            if (e.hash == hash && e.equals(entry)) {
                                ++ReferencedValueHashMap.this.modCount;
                                if (prev != null) {
                                    prev.next = e.next;
                                } else {
                                    tab[index] = e.next;
                                }
                                --ReferencedValueHashMap.this.count;
                                e.setValue(null);
                                return true;
                            }
                            prev = e;
                        }
                        e = e.next;
                    }
                    return false;
                }

                @Override
                public int size() {
                    return ReferencedValueHashMap.this.count;
                }

                @Override
                public void clear() {
                    ReferencedValueHashMap.this.clear();
                }

                @Override
                public String toString() {
                    return WeakIdentityMap.toString(this);
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public String toString() {
        this.cleanup();
        return WeakIdentityMap.toString(this);
    }

    abstract Entry<K, V> newEntry(int var1, K var2, V var3, Entry<K, V> var4);

    private Iterator createHashIterator(int type) {
        if (this.count == 0) {
            return Collections.EMPTY_SET.iterator();
        }
        return new HashIterator(type);
    }

    static abstract class Entry<K, V>
    implements Map.Entry<K, V> {
        int hash;
        K key;
        Entry<K, V> next;
        private Reference<V> value;

        Entry(int hash, K key, V value, Entry<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = this.newReference(value);
            this.next = next;
        }

        Entry(int hash, K key, Reference<V> value, Entry<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            V value = this.value.get();
            return value == NULL ? null : (V)value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.getValue();
            this.value = this.newReference(value == null ? NULL : value);
            return oldValue;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            return this.equals((Map.Entry)obj);
        }

        boolean equals(Map.Entry e) {
            V thisValue = this.get();
            if (thisValue == null) {
                return false;
            }
            if (thisValue == NULL) {
                thisValue = null;
            }
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (thisValue == null ? e.getValue() == null : thisValue.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return this.hash ^ this.get().hashCode();
        }

        public String toString() {
            return String.valueOf(this.key) + "=" + String.valueOf(this.getValue());
        }

        protected Object clone() {
            return this.newEntry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        abstract Entry newEntry(int var1, K var2, Reference<V> var3, Entry<K, V> var4);

        abstract Reference<V> newReference(V var1);

        V get() {
            return this.value.get();
        }
    }

    private class HashIterator
    implements Iterator {
        private final int type;
        private final Entry[] table;
        private int index;
        private Object entryValue;
        private Entry entry;
        private Entry last;
        private int expectedModCount;

        HashIterator(int type) {
            this.expectedModCount = ReferencedValueHashMap.this.modCount;
            this.table = ReferencedValueHashMap.this.table;
            this.type = type;
            this.index = this.table.length;
        }

        @Override
        public boolean hasNext() {
            while (this.entry == null || (this.entryValue = this.entry.get()) == null) {
                if (this.entry != null) {
                    this.remove(this.entry);
                    this.entry = this.entry.next;
                }
                if (this.entry != null) continue;
                if (this.index <= 0) {
                    return false;
                }
                this.entry = this.table[--this.index];
            }
            return true;
        }

        public Object next() {
            if (ReferencedValueHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.entry;
            this.entry = this.entry.next;
            return this.type == 0 ? this.last.getKey() : (this.type == 1 ? this.last.getValue() : this.last);
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            if (ReferencedValueHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.remove(this.last);
            this.last = null;
        }

        private void remove(Entry toRemove) {
            Entry[] tab = this.table;
            int index = (toRemove.hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e == toRemove) {
                    ++ReferencedValueHashMap.this.modCount;
                    ++this.expectedModCount;
                    if (prev == null) {
                        tab[index] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                    --ReferencedValueHashMap.this.count;
                    return;
                }
                prev = e;
                e = e.next;
            }
            throw new ConcurrentModificationException();
        }
    }
}

