/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.template2d.ui.function;

import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;

import org.simantics.databoard.Bindings;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.scenegraph.ontology.ScenegraphResources;

public class DrawingTemplateInfo extends ResourceRead<TreeMap<String, FlagTableInfo>> {
    public static final Integer ALIGN_LEFT  = 0;
    public static final Integer ALIGN_RIGHT = 1;
    public static final float BASELINE_VERTICAL_OFFSET = 0.8F; // percent of line height
//	private String digest = "";
//
//Column
//	public String getDigest() {
//		return digest;
//	}

	public DrawingTemplateInfo(Resource template) {
        super(template);
    }

	/**
	 * The byte[] returned by MessageDigest does not have a nice
	 * textual representation, so some form of encoding is usually performed.
	 *
	 * This implementation follows the example of David Flanagan's book
	 * "Java In A Nutshell", and converts a byte array into a String
	 * of hex characters.
	 *
	 * Another popular alternative is to use a "Base64" encoding.
	 */
//	static private String hexEncode( byte[] aInput){
//		StringBuilder result = new StringBuilder();
//		char[] digits = {'0', '1', '2', '3', '4','5','6','7','8','9','a','b','c','d','e','f'};
//		for ( int idx = 0; idx < aInput.length; ++idx) {
//			byte b = aInput[idx];
//			result.append( digits[ (b&0xf0) >> 4 ] );
//			result.append( digits[ b&0x0f] );
//		}
//		return result.toString();
//	}

	@Override
	public TreeMap<String, FlagTableInfo> perform(ReadGraph g) throws DatabaseException {
        TreeMap<String,FlagTableInfo> entries = new TreeMap<String,FlagTableInfo>();
    	try {
        Layer0 L0 = Layer0.getInstance(g);
        Template2dResource TEMPLATE2D = Template2dResource.getInstance(g);
		DiagramResource DIA = DiagramResource.getInstance(g);
		ScenegraphResources SG = ScenegraphResources.getInstance(g);
		//DatatypeResource DTR = DatatypeResource.getInstance(g);

//        MessageDigest sha;
//        sha = MessageDigest.getInstance("SHA-1");
//        byte[] result =  sha.digest(info.serialize());
//        System.err.println(hexEncode(result));


        Collection<Resource> slotTables = g.getObjects(resource, L0.ConsistsOf);
        for (Resource slotTable:slotTables){
        	if (!g.isInstanceOf(slotTable, TEMPLATE2D.FlagTable))
        		continue;
        	
        	String name = g.getPossibleRelatedValue(slotTable, L0.HasName, Bindings.STRING);
            double[] transform = g.getPossibleRelatedValue2(slotTable, DIA.Scenegraph_Composite_transform, Bindings.getBindingUnchecked(double[].class));
        	Resource align = g.getPossibleObject(slotTable, TEMPLATE2D.FlagTable_HasAlignment);
        	Float width = g.getPossibleRelatedValue(slotTable, TEMPLATE2D.FlagTable_HasWidth, Bindings.FLOAT);
        	Float rowHeight = g.getPossibleRelatedValue(slotTable, TEMPLATE2D.FlagTable_HasRowHeigth, Bindings.FLOAT);
        	Integer rowCount = g.getPossibleRelatedValue(slotTable, TEMPLATE2D.FlagTable_HasRowCount, Bindings.INTEGER);
        	if (name == null || width == null || rowCount == null)
        		continue;

        	FlagTableInfo table = new FlagTableInfo();
        	table.setWidth(width);
        	table.setRowCount(rowCount);
        	table.setRowHeight(rowHeight);
        	table.setTransform(transform);
        	table.affineTransform = (transform != null) ? new AffineTransform(transform) : new AffineTransform();
        	if (align != null) {
        	    if (align.equals(TEMPLATE2D.FlagTable_Alignment_Left))
        	        table.setAlignment(ALIGN_LEFT);
        	    if (align.equals(TEMPLATE2D.FlagTable_Alignment_Right))
        	        table.setAlignment(ALIGN_RIGHT);
        	}
        	entries.put(name, table);

        	// Columns information
			Resource res = g.getPossibleObject(slotTable, SG.Node_children);
			if(res == null || !g.isInstanceOf(res, L0.List))
				continue;
			List<Resource> columns = ListUtils.toList(g, res);

			Float weightTotal = 0.0F;
        	for (Resource column:columns){
        		if (!(g.isInstanceOf(column, TEMPLATE2D.FlagTable_Column) || g.isInstanceOf(column, TEMPLATE2D.FlagTable_RowNumberColumn)))
        			continue;

        		Float weight = g.getPossibleRelatedValue(column, TEMPLATE2D.FlagTable_Column_HasWeight, Bindings.FLOAT);
        		if (weight == null)
        			continue;
        		
        		FlagTableColumnInfo col = new FlagTableColumnInfo(weight);
        		table.addColumn(col);
        		if (g.isInstanceOf(column, TEMPLATE2D.FlagTable_RowNumberColumn)) {
        			col.setType(FlagTableColumnInfo.TYPE_ROW_NUMBERING);

        			Integer start = g.getPossibleRelatedValue(column, TEMPLATE2D.FlagTable_RowNumberColumn_start, Bindings.INTEGER);
        			col.setStartOffset(start);
        		}
        		
        		weightTotal = weightTotal + weight; 
				//sha.update(weight.toString().getBytes());
        		
        		// Header and Data information
				Resource res2 = g.getPossibleObject(column, SG.Node_children);
				if(res2 == null || !g.isInstanceOf(res2, L0.List))
					continue;
				List<Resource> columnDatas = ListUtils.toList(g, res2);
	        	for (Resource columnData:columnDatas){
	        		if (g.isInstanceOf(columnData, TEMPLATE2D.FlagTable_Column_Data)){
	            		MonitorInfo monitorInfo = new MonitorInfo();
	        			Font font = g.getPossibleRelatedValue2(columnData, DIA.Scenegraph_AbstractText_font, Bindings.getBindingUnchecked(Font.class));
	        			if (font != null){
	        				monitorInfo.setFont(font);
	        				//sha.update(font.serialize());
	        			}

	        			RGB.Integer color = g.getPossibleRelatedValue2(columnData, DIA.Scenegraph_AbstractText_color, RGB.Integer.BINDING/*Bindings.getBindingUnchecked(RGB.Integer.class)*/);
	        			if (color != null){
	        				monitorInfo.setColor(color);
	        				//sha.update(color.serialize());
	        			}

	        	        String path = g.getRelatedValue(columnData, DIA.Scenegraph_Monitor_reference, Bindings.STRING);
	        	        if (path != null && path.length() > 0){
	        	        	monitorInfo.setText(path);
	        				//sha.update(path.getBytes());
	        	        }
	        	        
	                    double[] dataTransform = g.getPossibleRelatedValue2(columnData, DIA.Scenegraph_AbstractText_transform, Bindings.getBindingUnchecked(double[].class));
	        	        if (dataTransform != null){
	        	        	monitorInfo.setTransform(dataTransform);
	        				//sha.update(path.getBytes());
	        	        }

	        	        monitorInfo.setResource(columnData);
	        	        //col.setColumnData(monitorInfo);
	        	        col.addColumnData(monitorInfo);
	        		}
	        		if (g.isInstanceOf(columnData, TEMPLATE2D.FlagTable_Column_Header)){
	            		MonitorInfo monitorInfo = new MonitorInfo();
	        			Font font = g.getPossibleRelatedValue2(columnData, DIA.Scenegraph_AbstractText_font, Bindings.getBindingUnchecked(Font.class));
	        			if (font != null){
	        				monitorInfo.setFont(font);
	        				//sha.update(font.serialize());
	        			}

	        			RGB.Integer color = g.getPossibleRelatedValue2(columnData, DIA.Scenegraph_AbstractText_color, RGB.Integer.BINDING/*Bindings.getBindingUnchecked(RGB.Integer.class)*/);
	        			if (color != null){
	        				monitorInfo.setColor(color);
	        				//sha.update(color.serialize());
	        			}

	        	        String path = g.getRelatedValue(columnData, DIA.Scenegraph_Monitor_reference, Bindings.STRING);
	        	        if (path != null && path.length() > 0){
	        	        	monitorInfo.setText(path);
	        				//sha.update(path.getBytes());
	        	        }
	        	        
	                    double[] dataTransform = g.getPossibleRelatedValue2(columnData, DIA.Scenegraph_AbstractText_transform, Bindings.getBindingUnchecked(double[].class));
	        	        if (dataTransform != null){
	        	        	monitorInfo.setTransform(dataTransform);
	        				//sha.update(path.getBytes());
	        	        }

	        	        monitorInfo.setResource(columnData);
	        	        //col.setColumnHeader(monitorInfo);
	        	        col.addColumnHeader(monitorInfo);
	        		}
	        	}
        	}
        	table.setWeightTotal(weightTotal);
        }
        //digest = hexEncode(sha.digest());
    	} catch (Throwable e){
    		e.printStackTrace(System.err);
    	}
        return entries;
    }
}
