/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.template2d.ui.actions;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.template2d.ontology.Template2dResource;

/**
 * @author Teemu Matasniemi
 */
public class NewFlagTableRowNumberColumn extends NewFlagTableColumn {

    @Override
    protected void claimColumn(WriteGraph g, Resource column, Resource parent) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(g);
        Template2dResource TEMPLATE2D = Template2dResource.getInstance(g);

        g.claim(column, L0.InstanceOf, null, TEMPLATE2D.FlagTable_RowNumberColumn);
        String name = NameUtils.findFreshName(g, "RowNumberColumn", parent, L0.ConsistsOf);
        g.addLiteral(column, L0.HasName, L0.NameOf, L0.String, name, Bindings.STRING);
    }

}
