/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.template2d.ui.actions;

import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.template2d.ontology.Template2dResource;

public class NewDrawingTemplate implements ActionFactory {

    @Override
    public Runnable create(Object target) {
        if(!(target instanceof Resource))
            return null;
        final Resource parent = (Resource)target;

        return new Runnable() {
            @Override
            public void run() {
                Simantics.getSession().asyncRequest(new WriteRequest() {
                    @Override
                    public void perform(WriteGraph g) throws DatabaseException {
                        g.markUndoPoint();
                        
                    	createDrawingTemplate(g, parent);
                    }
                });
            }
        };
    }
    
    public static Resource createDrawingTemplate (WriteGraph g, Resource parent) throws DatabaseException {
    	
        Layer0 L0 = Layer0.getInstance(g);
        Template2dResource TEMPLATE2D = Template2dResource.getInstance(g);
        G2DResource G2D = G2DResource.getInstance(g);
        
        Resource template = g.newResource();
        String name = NameUtils.findFreshName(g, "Template", parent, L0.ConsistsOf);
        g.claim(template, L0.InstanceOf, null, TEMPLATE2D.DrawingTemplate);
        g.claim(template, L0.InstanceOf, null, TEMPLATE2D.DrawingTemplateUI);
        g.addLiteral(template, L0.HasName, L0.NameOf, L0.String, name, Bindings.STRING);
        g.addLiteral(template, L0.HasLabel, L0.HasLabel_Inverse, L0.String, name, Bindings.STRING);
        g.claim(template, L0.PartOf, parent);

        Resource page = g.newResource();
        name = NameUtils.findFreshName(g, "Page", template, L0.ConsistsOf);
        g.claim(page, L0.InstanceOf, null, TEMPLATE2D.Page);
        g.claim(page, L0.InstanceOf, null, TEMPLATE2D.BrowseNode);
        g.addLiteral(page, L0.HasName, L0.NameOf, L0.String, name, Bindings.STRING);
        g.addLiteral(page, L0.HasLabel, L0.HasLabel_Inverse, L0.String, name, Bindings.STRING);
        g.claim(page, L0.PartOf, template);
        //OrderedSetUtils.add(g, template, page);
        g.claim(template, TEMPLATE2D.HasPage, page);
        
        g.claimLiteral(template, TEMPLATE2D.HasMargin, new float[]{10.0f, 10.0f, 10.0f, 10.0f}, Bindings.FLOAT_ARRAY);

        g.claim(template, TEMPLATE2D.HasPageOrientation, TEMPLATE2D.PageOrientation_Landscape);

        // Border is deprecated.
//        Resource border = g.newResource();
//        name = NameUtils.findFreshName(g, "Border", template, L0.ConsistsOf);
//        g.claim(border, L0.InstanceOf, null, TEMPLATE2D.Border);
//        g.claim(border, L0.InstanceOf, null, TEMPLATE2D.BorderUI);
//        g.addLiteral(border, L0.HasName, L0.NameOf, L0.String, name, Bindings.STRING);
//        g.addLiteral(border, L0.HasLabel, L0.HasLabel_Inverse, L0.String, name, Bindings.STRING);
//        g.claim(border, L0.PartOf, template);
//        g.claim(template, TEMPLATE2D.HasBorder, border);
//        g.claimLiteral(border, TEMPLATE2D.HasSize, new float[]{0.3f, 0.3f, 0.3f, 0.3f}, Bindings.FLOAT_ARRAY);
//
//        Resource color = G2DUtils.createColor(g, new Color(0.0f, 0.0f, 0.0f, 1.0f));
//        g.claim(border, G2D.HasColor, color);//new RGB.Integer(255,255,255), RGB.Integer.BINDING);

//        ViewsResources VIEW = ViewsResources.getInstance(g);
//        Resource sg = g.newResource();
//        g.claim(sg, L0.InstanceOf, null, VIEW.Text);
//        g.addLiteral(sg, L0.HasName, L0.NameOf, L0.String, "SG", Bindings.STRING);
//        g.claimLiteral(sg, VIEW.TextContainer_text, "SG", Bindings.STRING);
//        g.claim(template, TEMPLATE2D.HasScenegraph, sg);
//        g.claim(template, L0.ConsistsOf, sg);
    	
        CommentMetadata cm = g.getMetadata(CommentMetadata.class);
        g.addMetadata(cm.add("Create New Diagram Template."));
        
		return template;
    }
    
    public static Resource getDrawingTemplateLibrary(ReadGraph graph, Resource model) throws DatabaseException {
    	    	
    	Template2dResource TEMPLATE2D = Template2dResource.getInstance(graph);
    	Resource library = graph.getSingleObject(model, TEMPLATE2D.HasDrawingTemplateRoot);
    	return library;
    }
}
