/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.core.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSignatureAppearance;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.Simantics;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.Format;
import org.simantics.export.core.manager.Content;
import org.simantics.export.core.pdf.ServiceBasedPdfExportPageEvent;
import org.simantics.utils.page.MarginUtils;
import org.simantics.utils.page.PageDesc;
import org.simantics.utils.page.PageOrientation;

public class ExportPdfWriter {
    public Document document;
    public PdfCopy pdfCopy;
    public FileOutputStream fos;
    public PdfContentByte cb;
    public Map<String, PdfTemplate> templates = new HashMap<String, PdfTemplate>();
    public List<Page> pages = new ArrayList<Page>();
    public PageDesc defaultPageDesc;
    public Rectangle defaultRectangle;
    public FontMapper fontMapper;
    public File outputFile;
    public Variant options;
    public ExportContext ctx;
    public MarginUtils.Margins margins;
    public int compressionLevel;

    public Page createPage(PageDesc pd) throws ExportException {
        Rectangle rect;
        if (pd == null || pd.isInfinite()) {
            pd = this.defaultPageDesc;
            rect = this.defaultRectangle;
        } else {
            rect = ExportPdfWriter.toRectangle(pd);
        }
        Page page = new Page(pd, rect, this.pages.size());
        this.pages.add(page);
        return page;
    }

    public Template createTemplate(String name, PageDesc pd) throws ExportException {
        Rectangle rect;
        if (pd == null || pd.isInfinite()) {
            pd = this.defaultPageDesc;
            rect = this.defaultRectangle;
        } else {
            rect = ExportPdfWriter.toRectangle(pd);
        }
        int w = (int)pd.getWidth();
        int h = (int)pd.getHeight();
        PdfTemplate tp = this.cb.createTemplate((float)w, (float)h);
        Template canvas = new Template(name, pd, rect, tp);
        canvas.name = name;
        if (name != null) {
            this.templates.put(name, tp);
        }
        return canvas;
    }

    public void sign(File keystoreFile, String keystorePassword, String privateKeyPassword, String signLocation, String signReason) throws ExportException {
        FileInputStream ksfis = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        File signedFile = null;
        try {
            try {
                KeyStore ks = KeyStore.getInstance("pkcs12");
                signedFile = new File(this.outputFile.getCanonicalPath() + ".signed");
                if (signedFile.exists()) {
                    signedFile.delete();
                }
                ksfis = new FileInputStream(keystoreFile);
                fis = new FileInputStream(this.outputFile);
                fos = new FileOutputStream(signedFile);
                ks.load(ksfis, keystorePassword != null ? keystorePassword.toCharArray() : null);
                ArrayList<String> aliases = Collections.list(ks.aliases());
                String alias = (String)aliases.get(0);
                PrivateKey key = (PrivateKey)ks.getKey(alias, privateKeyPassword != null ? privateKeyPassword.toCharArray() : null);
                Certificate[] chain = ks.getCertificateChain(alias);
                PdfReader reader = new PdfReader((InputStream)fis);
                PdfStamper stp = PdfStamper.createSignature((PdfReader)reader, (OutputStream)fos, (char)'\u0000');
                PdfSignatureAppearance sap = stp.getSignatureAppearance();
                String fieldName = "sign";
                AcroFields af = stp.getAcroFields();
                af.getFieldItem(fieldName);
                if (signReason != null) {
                    sap.setReason(signReason);
                }
                if (signLocation != null) {
                    sap.setLocation(signLocation);
                }
                sap.setCrypto(key, chain, null, PdfSignatureAppearance.SELF_SIGNED);
                sap.setCertificationLevel(1);
                sap.setRender(1);
                stp.close();
                reader.close();
                fis.close();
            }
            catch (DocumentException e) {
                throw new ExportException(((Object)((Object)e)).getClass().getName() + ": " + e.getMessage(), e);
            }
            catch (UnrecoverableKeyException e) {
                throw new ExportException(e.getClass().getName() + ": " + e.getMessage(), e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ExportException(e.getClass().getName() + ": " + e.getMessage(), e);
            }
            catch (CertificateException e) {
                throw new ExportException(e.getClass().getName() + ": " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new ExportException(e.getClass().getName() + ": " + e.getMessage(), e);
            }
            catch (KeyStoreException e) {
                throw new ExportException(e.getClass().getName() + ": " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            if (ksfis != null) {
                try {
                    ksfis.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            if (signedFile != null && signedFile.exists() && this.outputFile.exists()) {
                this.outputFile.delete();
                signedFile.renameTo(this.outputFile);
            }
            throw throwable;
        }
        if (ksfis != null) {
            try {
                ksfis.close();
            }
            catch (IOException iOException) {}
        }
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }
        if (signedFile != null && signedFile.exists() && this.outputFile.exists()) {
            this.outputFile.delete();
            signedFile.renameTo(this.outputFile);
        }
    }

    public void addAttachment(Content content) throws ExportException {
        try {
            if (content.tmpFile == null) {
                throw new ExportException("Could not export " + content.filename + ", null file.");
            }
            if (!content.tmpFile.exists()) {
                throw new ExportException("Could not export " + content.filename + ", file not found.");
            }
            Format format = this.ctx.eep.getFormat(content.formatId);
            PdfDictionary fileParameter = new PdfDictionary();
            PdfFileSpecification spec = PdfFileSpecification.fileEmbedded((PdfWriter)this.pdfCopy, (String)content.tmpFile.getAbsolutePath(), (String)content.filename, null, (boolean)true, (String)("application/simantics/" + format.id()), (PdfDictionary)fileParameter);
            this.pdfCopy.addFileAttachment(content.filename, spec);
        }
        catch (IOException e) {
            throw new ExportException(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void close() throws ExportException {
        try {
            try {
                if (this.pages.isEmpty()) {
                    page = this.createPage(null);
                    g2d = page.createGraphics(true);
                    try {
                        g2d.drawString("This page is intentionally left blank.", 100, 100);
                    }
                    finally {
                        g2d.dispose();
                    }
                }
                for (Page page : this.pages) {
                    page.close();
                }
                f = new Font(1, 8.0f);
                totalPages = 0;
                currentPage = 1;
                for (Page page : this.pages) {
                    reader = new PdfReader(page.tmpFile.getAbsolutePath());
                    try {
                        totalPages += reader.getNumberOfPages();
                    }
                    finally {
                        reader.close();
                    }
                }
                for (Page page : this.pages) {
                    reader = new PdfReader(page.tmpFile.getAbsolutePath());
                    try {
                        n = reader.getNumberOfPages();
                        i = 1;
                        while (i <= n) {
                            pageSize = reader.getPageSizeWithRotation(i);
                            imp = this.pdfCopy.getImportedPage(reader, i);
                            ps = this.pdfCopy.createPageStamp(imp);
                            over = ps.getOverContent();
                            ColumnText.showTextAligned((PdfContentByte)over, (int)2, (Phrase)new Phrase(String.format("%d / %d", new Object[]{currentPage++, totalPages}), f), (float)(pageSize.getWidth() - 12.0f), (float)12.0f, (float)0.0f);
                            ps.alterContents();
                            this.pdfCopy.addPage(imp);
                            ++i;
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                throw new ExportException(e);
            }
            catch (ExceptionConverter e) {
                throw new ExportException(e);
            }
            catch (BadPdfFormatException e) {
                throw new ExportException(e);
            }
            catch (Exception e) {
                throw new ExportException(e);
            }
        }
        finally {
            ** for (page : this.pages)
        }
lbl-1000:
        // 1 sources

        {
            if (page.tmpFile == null) continue;
            page.tmpFile.delete();
            page.tmpFile = null;
            continue;
        }
lbl62:
        // 1 sources

        this.pages.clear();
        if (this.document != null) {
            this.document.close();
            this.document = null;
        }
        if (this.pdfCopy != null) {
            this.pdfCopy.close();
            this.pdfCopy = null;
        }
        if (this.fos != null) {
            try {
                this.fos.close();
            }
            catch (IOException e) {
                throw new ExportException(e);
            }
            this.fos = null;
        }
    }

    public static Rectangle toRectangle(PageDesc pageDesc) {
        String arg = PageDesc.toPoints((double)pageDesc.getWidth()) + " " + PageDesc.toPoints((double)pageDesc.getHeight());
        Rectangle r = PageSize.getRectangle((String)arg);
        if (PageOrientation.Landscape == pageDesc.getOrientation()) {
            r = r.rotate();
        }
        r.setBorder(0);
        return r;
    }

    public class Page {
        public PdfWriter pdfWriter;
        public Document document;
        public FileOutputStream fos;
        public PdfContentByte cb;
        public File tmpFile;
        public PageDesc pageDesc;
        public Rectangle rectangle;
        public int pageNumber;

        Page(PageDesc pageDesc, Rectangle rect, int pageNumber) throws ExportException {
            try {
                this.pageDesc = pageDesc;
                this.rectangle = rect;
                this.pageNumber = pageNumber;
                this.tmpFile = Simantics.getTempfile((String)"export.core", (String)"pdf");
                this.fos = new FileOutputStream(this.tmpFile, false);
                this.document = new Document(this.rectangle);
                this.document.setPageSize(rect);
                this.pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)this.fos);
                this.pdfWriter.setPdfVersion(PdfWriter.PDF_VERSION_1_7);
                this.pdfWriter.setCompressionLevel(ExportPdfWriter.this.compressionLevel);
                this.pdfWriter.setPageEvent((PdfPageEvent)new ServiceBasedPdfExportPageEvent());
                this.document.open();
                this.cb = this.pdfWriter.getDirectContent();
                if (!this.document.newPage()) {
                    throw new ExportException("Failed to create new page.");
                }
            }
            catch (IOException e) {
                throw new ExportException(e);
            }
            catch (DocumentException e) {
                throw new ExportException(e);
            }
        }

        public Graphics2D createGraphics(boolean applyMargins) {
            float w = this.rectangle.getWidth();
            float h = this.rectangle.getHeight();
            double pw = this.pageDesc.getOrientedWidth();
            double ph = this.pageDesc.getOrientedHeight();
            Graphics2D g2d = this.cb.createGraphics(w, h, ExportPdfWriter.this.fontMapper);
            if (applyMargins) {
                MarginUtils.Margins m = this.pageDesc.getMargins();
                double mw = pw - m.left.diagramAbsolute - m.right.diagramAbsolute;
                double mh = ph - m.top.diagramAbsolute - m.bottom.diagramAbsolute;
                double sx = m.left.diagramAbsolute;
                double sy = m.top.diagramAbsolute;
                mw = PageDesc.toPoints((double)mw);
                mh = PageDesc.toPoints((double)mh);
                sx = PageDesc.toPoints((double)sx);
                sy = PageDesc.toPoints((double)sy);
                g2d.translate(sx, sy);
            }
            g2d.scale((double)w / pw, (double)h / ph);
            return g2d;
        }

        public double getWidth() {
            MarginUtils.Margins m = this.pageDesc.getMargins();
            return this.pageDesc.getOrientedWidth() - m.left.diagramAbsolute - m.right.diagramAbsolute;
        }

        public double getHeight() {
            MarginUtils.Margins m = this.pageDesc.getMargins();
            return this.pageDesc.getOrientedHeight() - m.top.diagramAbsolute - m.bottom.diagramAbsolute;
        }

        public void addAttachment(Content content) throws ExportException {
            ExportPdfWriter.this.addAttachment(content);
        }

        public void close() throws ExportException {
            try {
                if (this.document != null) {
                    this.document.close();
                    this.document = null;
                }
                if (this.pdfWriter != null) {
                    this.pdfWriter.close();
                    this.pdfWriter = null;
                }
                if (this.fos != null) {
                    this.fos.close();
                    this.fos = null;
                }
                if (this.cb != null) {
                    this.cb = null;
                }
            }
            catch (IOException e) {
                throw new ExportException(e);
            }
        }
    }

    public class Template {
        public PageDesc pageDesc;
        public Rectangle rectangle;
        public String name;
        public PdfTemplate tp;

        Template(String name, PageDesc pd, Rectangle rect, PdfTemplate tp) {
            this.pageDesc = pd;
            this.rectangle = rect;
            this.name = name;
            this.tp = tp;
        }

        public Graphics2D createGraphics() {
            double w = this.pageDesc.getWidth();
            double h = this.pageDesc.getHeight();
            return this.tp.createGraphics((float)w, (float)h, ExportPdfWriter.this.fontMapper);
        }
    }
}

