/*******************************************************************************
 * Copyright (c) 2007, 2015 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph;

import java.awt.geom.AffineTransform;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.modeling.ModelingResources;

/**
 * @author Tuukka Lehtonen
 */
public class TransformElement extends ModificationAdapter {

    Resource elementResource;
    AffineTransform tr;

    public TransformElement(Resource element, AffineTransform tr) {
        super(LOW_PRIORITY);
        this.elementResource = element;
        this.tr = tr;
    }

    @Override
    public void perform(WriteGraph g) throws DatabaseException {
        DiagramGraphUtil.setTransform(g, elementResource, tr);

        // Add comment to change set.
        CommentMetadata cm = g.getMetadata(CommentMetadata.class);
        ModelingResources MOD = ModelingResources.getInstance(g);
        Resource component = g.getPossibleObject(elementResource, MOD.ElementToComponent);
        if (component != null)
            g.addMetadata(cm.add("Transformed " + NameUtils.getSafeName(g, component)));
        else
            g.addMetadata(cm.add("Transformed " + elementResource));
    }

}
