/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization;

import org.simantics.utils.ui.ErrorLogger;

/**
 * @author Tuukka Lehtonen
 */
public class LogErrorHandler implements ErrorHandler {

    public static final LogErrorHandler INSTANCE = new LogErrorHandler();

    private LogErrorHandler() {
    }

    @Override
    public void error(String message, Throwable t) {
        ErrorLogger.defaultLogError(message, t);
    }

    @Override
    public void warning(String message, Exception e) {
        ErrorLogger.defaultLogWarning(message, e);
    }

}
