/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.query;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceAsyncRead;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.diagram.adapter.ElementFactory;
import org.simantics.g2d.canvas.impl.DisposedCanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class ElementClassQuery extends ResourceAsyncRead<ElementClass> {

    /**
     * External hints for loading an element class.
     */
    IHintObservable hints;

    public ElementClassQuery(Resource resource, IHintObservable hints) {
        super(resource);
        this.hints = hints;
    }

    @Override
    public void perform(AsyncReadGraph graph, AsyncProcedure<ElementClass> procedure) {
        graph.forAdapted(resource , ElementFactory.class, createElementClass(procedure));
    }

    private AsyncProcedure<ElementFactory> createElementClass(final AsyncProcedure<ElementClass> parent) {
        return new AsyncProcedure<ElementFactory>() {
            @Override
            public void exception(AsyncReadGraph graph, Throwable throwable) {
                parent.exception(graph, throwable);
            }

            @Override
            public void execute(AsyncReadGraph graph, ElementFactory factory) {
                // TODO: remove (IDiagram) cast
                factory.create(graph, DisposedCanvasContext.INSTANCE, (IDiagram) hints, resource, new AsyncProcedure<ElementClass>() {
                    @Override
                    public void execute(AsyncReadGraph graph, ElementClass result) {
                        parent.execute(graph, result);
                    }
                    @Override
                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        parent.exception(graph, throwable);
                    }
                });
            }
        };
    }

}
