/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.handler;

import org.simantics.Simantics;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.utils.ui.ErrorLogger;

/**
 * The default strategy for pasting diagram elements.
 * 
 * @author Tuukka Lehtonen
 */
public class DefaultCopyPasteStrategy implements CopyPasteStrategy {

    @Override
    public void paste(final PasteOperation op) {
        try {
            if (op.sameDiagram() && op.cut) {
                CopyPasteUtil.localCutPaste(op);
            } else {
                Session session = Simantics.getSession();
                if (CopyPasteUtil.onlyFlagsWithoutCorrespondence(session, op.ea)
                        && CopyPasteUtil.checkFlagExternality(session, op.ea.flags, false)) {
                    CopyPasteUtil.continueFlags(op);
                } else {
                    CopyPasteUtil.performDefaultPaste(op);
                }
            }
        } catch (DatabaseException e) {
            ErrorLogger.defaultLogError(e);
        }
    }

    @Override
    public void copyToClipboard(DiagramSelection selection) {
        
        Simantics.setClipboard( new SimanticsClipboardImpl( new DiagramSelectionRepresentation(selection) ) );
        
    }
    
}