/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.elements;

import java.util.Map;

import org.eclipse.core.runtime.IAdaptable;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.threads.IThreadWorkQueue;

public class AdaptableImmutableProxyElement implements IAdaptable, IElement {

    private final IElement element;

    public AdaptableImmutableProxyElement(IElement element) {
        this.element = element;
    }

    @SuppressWarnings({ "rawtypes", "unchecked" })
    @Override
    public Object getAdapter(Class adapter) {
        Object object = element.getHint(ElementHints.KEY_OBJECT);
        if (object != null) {
            if (adapter.isAssignableFrom(object.getClass()))
                return object;
            if (object instanceof IAdaptable) {
                IAdaptable a = (IAdaptable) object;
                return a.getAdapter(adapter);
            }
            if(WorkbenchSelectionElement.class.equals(adapter)) {
                return getWSE(object);
            }
        }
        return null;
    }

    public WorkbenchSelectionElement getWSE(Object object) {
        return null;
    }

    @Override
    public void addedToDiagram(IDiagram diagram) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IDiagram getDiagram() {
        return ElementUtils.getDiagram(element);
    }

    @Override
    public IDiagram peekDiagram() {
        return ElementUtils.peekDiagram(element);
    }

    @Override
    public ElementClass getElementClass() {
        return element.getElementClass();
    }

    @Override
    public void clearWithoutNotification() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <E> E removeHint(Key key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHint(Key key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHints(Map<Key, Object> hints) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addHintListener(IHintListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addHintListener(IThreadWorkQueue threadAccess, IHintListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addKeyHintListener(Key key, IHintListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addKeyHintListener(IThreadWorkQueue threadAccess, Key key, IHintListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsHint(Key key) {
        return element.containsHint(key);
    }

    @Override
    public <E> E getHint(Key key) {
        return element.getHint(key);
    }

    @Override
    public Map<Key, Object> getHints() {
        return element.getHints();
    }

    @Override
    public Map<Key, Object> getHintsUnsafe() {
        return element.getHintsUnsafe();
    }

    @Override
    public <E extends Key> Map<E, Object> getHintsOfClass(Class<E> clazz) {
        return element.getHintsOfClass(clazz);
    }

    @Override
    public void removeHintListener(IHintListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeHintListener(IThreadWorkQueue threadAccess, IHintListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeKeyHintListener(Key key, IHintListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeKeyHintListener(IThreadWorkQueue threadAccess, Key key, IHintListener listener) {
        throw new UnsupportedOperationException();
    }

}
