package org.simantics.debug.graphical.model;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Node {
    public static final Font FONT = new Font("Arial", Font.PLAIN, 12);
    public static final FontRenderContext FRC = 
            new FontRenderContext(new AffineTransform(), true, true);
    public static final Rectangle2D MAX_BOUNDS = FONT.getMaxCharBounds(FRC);
    public static final double FONT_HEIGHT = MAX_BOUNDS.getHeight();
    
    public static double PADDING = 3.0;
    
    NodeData data;       
    Content content;
    
    double x;
    double y;
    
    double radiusX;
    double radiusY;
    
    // for layouter
    public double forceX, forceY;
    
    public Node(NodeData data) {
        this.data = data;
    }

    public void setContent(Content content) {
        this.content = content;
        this.radiusX = content.radiusX;
        this.radiusY = content.radiusY;
    }
    
    public NodeData getData() {
        return data;
    }
    
    public void setPos(double x, double y) {
        this.x = x;
        this.y = y;
    }
    
    public void render(Graphics2D g) {
        Rectangle2D rect = new Rectangle2D.Double(x-radiusX, y-radiusY, 2*radiusX, 2*radiusY);
        g.setColor(new Color(200, 200, 255));
        g.fill(rect);
        g.setColor(Color.BLACK);
        
        if(content != null)
            content.render(g, x, y);
        
        g.draw(rect);
    }
    
    public Point2D clipLineFromCenter(double targetX, double targetY) {
        targetX -= x;
        targetY -= y;
        if(radiusX * Math.abs(targetY) < radiusY * Math.abs(targetX)) {
            return new Point2D.Double(
                    x+Math.signum(targetX)*radiusX, 
                    y+targetY * radiusX / Math.abs(targetX));
        }
        else {
            return new Point2D.Double(                     
                    x+targetX * radiusY / Math.abs(targetY),
                    y+Math.signum(targetY)*radiusY);
        }
    }
    
    public boolean pick(double px, double py) {
        return Math.abs(px - x) <= radiusX && Math.abs(py - y) <= radiusY; 
    }

    public double getX() {
        return x;
    }
    
    public double getY() {
        return y;
    }
    
    public double getMinX() {
        return x - radiusX;
    }
    
    public double getMinY() {
        return y - radiusY;
    }
    
    public double getMaxX() {
        return x + radiusX;
    }
    
    public double getMaxY() {
        return y + radiusY;
    }
}
